/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.http2;

import io.undertow.protocols.http2.Hpack;
import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import io.undertow.util.HttpString;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class HpackEncoder
extends Hpack {
    private int currentBitPos;
    private long headersIterator = -1L;
    private boolean firstPass = true;
    private HeaderMap currentHeaders;
    private static final Map<HttpString, StaticTableEntry[]> ENCODING_STATIC_TABLE;
    private int tableSize;
    private int extraData;

    public HpackEncoder(int tableSize) {
        this.tableSize = tableSize;
    }

    public State encode(HeaderMap headers, ByteBuffer target) {
        if (target.remaining() < 3) {
            return State.UNDERFLOW;
        }
        long it = this.headersIterator;
        if (this.headersIterator == -1L) {
            this.currentBitPos = 0;
            it = headers.fastIterate();
            this.currentHeaders = headers;
        } else {
            if (headers != this.currentHeaders) {
                throw new IllegalStateException();
            }
            if (this.currentBitPos > 0) {
                target.put((byte)this.extraData);
            }
        }
        while (it != -1L) {
            HeaderValues values = headers.fiCurrent(it);
            boolean skip = false;
            if (this.firstPass) {
                if (values.getHeaderName().byteAt(0) != 58) {
                    skip = true;
                }
            } else if (values.getHeaderName().byteAt(0) == 58) {
                skip = true;
            }
            if (!skip) {
                for (int i = 0; i < values.size(); ++i) {
                    int required = 11 + values.getHeaderName().length();
                    StaticTableEntry[] staticTable = ENCODING_STATIC_TABLE.get(values.getHeaderName());
                    String val = values.get(i);
                    if (target.remaining() < (required += 1 + val.length())) {
                        this.headersIterator = it;
                        this.currentBitPos = 0;
                        return State.UNDERFLOW;
                    }
                    if (staticTable == null) {
                        target.put((byte)0);
                        target.put((byte)0);
                        HpackEncoder.encodeInteger(target, values.getHeaderName().length(), 7);
                        values.getHeaderName().appendTo(target);
                    } else {
                        boolean found = false;
                        for (StaticTableEntry st : staticTable) {
                            if (st.value == null || !st.value.equals(val)) continue;
                            target.put((byte)-128);
                            HpackEncoder.encodeInteger(target, st.pos, 7);
                            found = true;
                            break;
                        }
                        if (found) continue;
                        target.put((byte)0);
                        HpackEncoder.encodeInteger(target, staticTable[0].pos, 4);
                    }
                    target.put((byte)0);
                    HpackEncoder.encodeInteger(target, val.length(), 7);
                    for (int j = 0; j < val.length(); ++j) {
                        target.put((byte)val.charAt(j));
                    }
                }
            }
            if ((it = headers.fiNext(it)) != -1L || !this.firstPass) continue;
            this.firstPass = false;
            it = headers.fastIterate();
        }
        this.headersIterator = -1L;
        this.firstPass = true;
        return State.COMPLETE;
    }

    static int pushBits(ByteBuffer buffer, int value, int n, int currentBitPos) {
        int forThisByte;
        int bitsLeft = n;
        if (currentBitPos != 0) {
            int rem = 8 - currentBitPos;
            int forThisByte2 = n > rem ? rem : n;
            int toPush = value >> n - forThisByte2;
            int shift = 8 - (currentBitPos + forThisByte2);
            int pos = buffer.position() - 1;
            buffer.put(pos, (byte)(buffer.get(pos) | toPush << shift));
            if ((bitsLeft -= forThisByte2) == 0) {
                int newPos = currentBitPos + n;
                return newPos == 8 ? 0 : newPos;
            }
        }
        do {
            forThisByte = bitsLeft > 8 ? 8 : bitsLeft;
            int toPush = value >> bitsLeft - forThisByte;
            int shift = 8 - forThisByte;
            buffer.put((byte)(toPush << shift));
        } while ((bitsLeft -= forThisByte) != 0);
        return forThisByte;
    }

    static {
        HashMap<HttpString, StaticTableEntry[]> map = new HashMap<HttpString, StaticTableEntry[]>();
        for (int i = 1; i < STATIC_TABLE.length; ++i) {
            Hpack.HeaderField m = STATIC_TABLE[i];
            StaticTableEntry[] existing = (StaticTableEntry[])map.get(m.name);
            if (existing == null) {
                map.put(m.name, new StaticTableEntry[]{new StaticTableEntry(m.value, i)});
                continue;
            }
            StaticTableEntry[] newEntry = new StaticTableEntry[existing.length + 1];
            System.arraycopy(existing, 0, newEntry, 0, existing.length);
            newEntry[existing.length] = new StaticTableEntry(m.value, i);
            map.put(m.name, newEntry);
        }
        ENCODING_STATIC_TABLE = Collections.unmodifiableMap(map);
    }

    static final class StaticTableEntry {
        final String value;
        final int pos;

        private StaticTableEntry(String value, int pos) {
            this.value = value;
            this.pos = pos;
        }
    }

    public static enum State {
        COMPLETE,
        UNDERFLOW;

    }
}

