/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.path;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.PathHandler;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import io.undertow.util.HttpString;
import java.io.IOException;
import java.util.Collections;
import java.util.Deque;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class PathTestCase {
    public static final String MATCHED = "matched";
    public static final String PATH = "path";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBasicPathHanding() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            PathHandler handler = new PathHandler();
            handler.addPrefixPath("a", (HttpHandler)new RemainingPathHandler("/a"));
            handler.addPrefixPath("/aa", (HttpHandler)new RemainingPathHandler("/aa"));
            handler.addExactPath("/aa", new HttpHandler(){

                public void handleRequest(HttpServerExchange exchange) throws Exception {
                    exchange.getResponseSender().send("Exact /aa match:" + exchange.getRelativePath() + ":" + exchange.getResolvedPath());
                }
            });
            handler.addPrefixPath("/aa/anotherSubPath", (HttpHandler)new RemainingPathHandler("/aa/anotherSubPath"));
            PathHandler sub = new PathHandler();
            handler.addPrefixPath("/path", (HttpHandler)sub);
            sub.addPrefixPath("/subpath", (HttpHandler)new RemainingPathHandler("/subpath"));
            sub.addPrefixPath("/", (HttpHandler)new RemainingPathHandler("/path"));
            DefaultServer.setRootHandler((HttpHandler)handler);
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/notamatchingpath");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)404L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse(result);
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)404L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse(result);
            this.runPathTest(client, "/path", "/path", "");
            this.runPathTest(client, "/path/a", "/path", "/a");
            this.runPathTest(client, "/path/subpath", "/subpath", "");
            this.runPathTest(client, "/path/subpath/", "/subpath", "/");
            this.runPathTest(client, "/path/subpath/foo", "/subpath", "/foo");
            this.runPathTest(client, "/a", "/a", "");
            this.runPathTest(client, "/aa/anotherSubPath", "/aa/anotherSubPath", "");
            this.runPathTest(client, "/aa/anotherSubPath/bob", "/aa/anotherSubPath", "/bob");
            this.runPathTest(client, "/aa/b?a=b", "/aa", "/b", Collections.singletonMap("a", "b"));
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/aa");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)"Exact /aa match::/aa", (Object)HttpClientUtils.readResponse(result));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    private void runPathTest(TestHttpClient client, String path, String expectedMatch, String expectedRemaining) throws IOException {
        this.runPathTest(client, path, expectedMatch, expectedRemaining, Collections.emptyMap());
    }

    private void runPathTest(TestHttpClient client, String path, String expectedMatch, String expectedRemaining, Map<String, String> queryParams) throws IOException {
        HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + path);
        HttpResponse result = client.execute((HttpUriRequest)get);
        Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
        Header[] header = result.getHeaders(MATCHED);
        Assert.assertEquals((Object)expectedMatch, (Object)header[0].getValue());
        header = result.getHeaders(PATH);
        Assert.assertEquals((Object)expectedRemaining, (Object)header[0].getValue());
        HttpClientUtils.readResponse(result);
        for (Map.Entry<String, String> entry : queryParams.entrySet()) {
            header = result.getHeaders(entry.getKey());
            Assert.assertEquals((Object)entry.getValue(), (Object)header[0].getValue());
        }
    }

    private static class RemainingPathHandler
    implements HttpHandler {
        private final String matched;

        private RemainingPathHandler(String matched) {
            this.matched = matched;
        }

        public void handleRequest(HttpServerExchange exchange) throws Exception {
            exchange.getResponseHeaders().add(new HttpString(PathTestCase.MATCHED), this.matched);
            exchange.getResponseHeaders().add(new HttpString(PathTestCase.PATH), exchange.getRelativePath());
            for (Map.Entry param : exchange.getQueryParameters().entrySet()) {
                exchange.getResponseHeaders().put(new HttpString((String)param.getKey()), (String)((Deque)param.getValue()).getFirst());
            }
            exchange.endExchange();
        }
    }
}

