/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.utils;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.concurrent.TimeUnit;
import org.xnio.ChannelListener;
import org.xnio.Option;
import org.xnio.XnioExecutor;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;

public class StreamSourceChannelAdapter
implements StreamSourceChannel {
    private final ReadableByteChannel channel;
    private final ChannelListener.SimpleSetter<? extends StreamSourceChannel> readSetter = new ChannelListener.SimpleSetter();
    private final ChannelListener.SimpleSetter<? extends StreamSourceChannel> closeSetter = new ChannelListener.SimpleSetter();

    public StreamSourceChannelAdapter(ReadableByteChannel channel) {
        this.channel = channel;
    }

    public int read(ByteBuffer dst) throws IOException {
        return this.channel.read(dst);
    }

    public void close() throws IOException {
        this.channel.close();
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public long read(ByteBuffer[] dst) throws IOException {
        return this.read(dst, 0, dst.length);
    }

    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        return this.channel.read(dsts[0]);
    }

    public void suspendReads() {
        throw new UnsupportedOperationException();
    }

    public void resumeReads() {
        throw new UnsupportedOperationException();
    }

    public boolean isReadResumed() {
        throw new UnsupportedOperationException();
    }

    public void wakeupReads() {
        throw new UnsupportedOperationException();
    }

    public void shutdownReads() throws IOException {
        throw new UnsupportedOperationException();
    }

    public void awaitReadable() throws IOException {
        throw new UnsupportedOperationException();
    }

    public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        throw new UnsupportedOperationException();
    }

    public XnioExecutor getReadThread() {
        throw new UnsupportedOperationException();
    }

    public XnioWorker getWorker() {
        throw new UnsupportedOperationException();
    }

    public XnioIoThread getIoThread() {
        return null;
    }

    public boolean supportsOption(Option<?> option) {
        return false;
    }

    public <T> T getOption(Option<T> option) throws IOException {
        return null;
    }

    public <T> T setOption(Option<T> option, T value) throws IOException {
        return null;
    }

    public long transferTo(long position, long count, FileChannel target) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate((int)count);
        int r = this.channel.read(buf);
        buf.flip();
        while (buf.hasRemaining()) {
            if (target.write(buf) >= 1) continue;
            throw new IOException("Unable to write out all bytes");
        }
        buf.clear();
        return r;
    }

    public long transferTo(long count, ByteBuffer buf, StreamSinkChannel target) throws IOException {
        buf.flip();
        if (count < (long)buf.remaining()) {
            buf.limit(buf.position() + (int)count);
        }
        int r = this.channel.read(buf);
        while (buf.hasRemaining()) {
            if (target.write(buf) >= 1) continue;
            throw new IOException("Unable to write out all bytes");
        }
        return r;
    }

    public ChannelListener.Setter<? extends StreamSourceChannel> getReadSetter() {
        return this.readSetter;
    }

    public ChannelListener.Setter<? extends StreamSourceChannel> getCloseSetter() {
        return this.closeSetter;
    }
}

