/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.client.http;

import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientExchange;
import io.undertow.client.ClientRequest;
import io.undertow.client.ClientResponse;
import io.undertow.client.UndertowClient;
import io.undertow.io.Sender;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpOneOnly;
import io.undertow.util.AttachmentKey;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import io.undertow.util.StringReadChannelListener;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.xnio.ByteBufferSlicePool;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Pool;
import org.xnio.Xnio;
import org.xnio.XnioWorker;
import org.xnio.ssl.JsseXnioSsl;
import org.xnio.ssl.XnioSsl;

@RunWith(value=DefaultServer.class)
@HttpOneOnly
public class HttpClientTestCase {
    private static final String message = "Hello World!";
    private static XnioWorker worker;
    private static final OptionMap DEFAULT_OPTIONS;
    private static final HttpHandler SIMPLE_MESSAGE_HANDLER;
    private static final URI ADDRESS;
    private static final AttachmentKey<String> RESPONSE_BODY;

    static void sendMessage(HttpServerExchange exchange) {
        exchange.setResponseCode(200);
        exchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, message.length() + "");
        Sender sender = exchange.getResponseSender();
        sender.send(message);
    }

    @BeforeClass
    public static void beforeClass() throws IOException {
        XnioWorker xnioWorker;
        Xnio xnio = Xnio.getInstance();
        worker = xnioWorker = xnio.createWorker(null, DEFAULT_OPTIONS);
    }

    @AfterClass
    public static void afterClass() {
        worker.shutdown();
    }

    static UndertowClient createClient() {
        return HttpClientTestCase.createClient(OptionMap.EMPTY);
    }

    static UndertowClient createClient(OptionMap options) {
        return UndertowClient.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleBasic() throws Exception {
        DefaultServer.setRootHandler(SIMPLE_MESSAGE_HANDLER);
        UndertowClient client = HttpClientTestCase.createClient();
        final CopyOnWriteArrayList responses = new CopyOnWriteArrayList();
        final CountDownLatch latch = new CountDownLatch(10);
        final ClientConnection connection = (ClientConnection)client.connect(ADDRESS, worker, (Pool)new ByteBufferSlicePool(1024, 1024), OptionMap.EMPTY).get();
        try {
            connection.getIoThread().execute(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < 10; ++i) {
                        ClientRequest request = new ClientRequest().setMethod(Methods.GET).setPath("/");
                        connection.sendRequest(request, HttpClientTestCase.this.createClientCallback(responses, latch));
                    }
                }
            });
            latch.await(10L, TimeUnit.MINUTES);
            Assert.assertEquals((long)10L, (long)responses.size());
            for (ClientResponse response : responses) {
                Assert.assertEquals((Object)message, (Object)response.getAttachment(RESPONSE_BODY));
            }
        }
        finally {
            IoUtils.safeClose((Closeable)connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSsl() throws Exception {
        DefaultServer.setRootHandler(SIMPLE_MESSAGE_HANDLER);
        UndertowClient client = HttpClientTestCase.createClient();
        final CopyOnWriteArrayList responses = new CopyOnWriteArrayList();
        final CountDownLatch latch = new CountDownLatch(10);
        DefaultServer.startSSLServer();
        SSLContext context = DefaultServer.getClientSSLContext();
        JsseXnioSsl ssl = new JsseXnioSsl(DefaultServer.getWorker().getXnio(), OptionMap.EMPTY, context);
        final ClientConnection connection = (ClientConnection)client.connect(new URI(DefaultServer.getDefaultServerSSLAddress()), worker, (XnioSsl)ssl, (Pool)new ByteBufferSlicePool(1024, 1024), OptionMap.EMPTY).get();
        try {
            connection.getIoThread().execute(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < 10; ++i) {
                        ClientRequest request = new ClientRequest().setMethod(Methods.GET).setPath("/");
                        connection.sendRequest(request, HttpClientTestCase.this.createClientCallback(responses, latch));
                    }
                }
            });
            latch.await(10L, TimeUnit.MINUTES);
            Assert.assertEquals((long)10L, (long)responses.size());
            for (ClientResponse response : responses) {
                Assert.assertEquals((Object)message, (Object)response.getAttachment(RESPONSE_BODY));
            }
        }
        finally {
            IoUtils.safeClose((Closeable)connection);
            DefaultServer.stopSSLServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnectionClose() throws Exception {
        DefaultServer.setRootHandler(SIMPLE_MESSAGE_HANDLER);
        UndertowClient client = HttpClientTestCase.createClient();
        CountDownLatch latch = new CountDownLatch(1);
        ClientConnection connection = (ClientConnection)client.connect(ADDRESS, worker, (Pool)new ByteBufferSlicePool(1024, 1024), OptionMap.EMPTY).get();
        try {
            ClientRequest request = new ClientRequest().setPath("/1324").setMethod(Methods.GET);
            CopyOnWriteArrayList<ClientResponse> responses = new CopyOnWriteArrayList<ClientResponse>();
            request.getRequestHeaders().add(Headers.CONNECTION, Headers.CLOSE.toString());
            connection.sendRequest(request, this.createClientCallback(responses, latch));
            latch.await();
            ClientResponse response = (ClientResponse)responses.iterator().next();
            Assert.assertEquals((Object)message, (Object)response.getAttachment(RESPONSE_BODY));
            Assert.assertEquals((Object)false, (Object)connection.isOpen());
        }
        finally {
            IoUtils.safeClose((Closeable)connection);
        }
    }

    private ClientCallback<ClientExchange> createClientCallback(final List<ClientResponse> responses, final CountDownLatch latch) {
        return new ClientCallback<ClientExchange>(){

            public void completed(ClientExchange result) {
                result.setResponseListener((ClientCallback)new ClientCallback<ClientExchange>(){

                    public void completed(final ClientExchange result) {
                        responses.add(result.getResponse());
                        new StringReadChannelListener(result.getConnection().getBufferPool()){

                            protected void stringDone(String string) {
                                result.getResponse().putAttachment(RESPONSE_BODY, (Object)string);
                                latch.countDown();
                            }

                            protected void error(IOException e) {
                                e.printStackTrace();
                                latch.countDown();
                            }
                        }.setup(result.getResponseChannel());
                    }

                    public void failed(IOException e) {
                        e.printStackTrace();
                        latch.countDown();
                    }
                });
                try {
                    result.getRequestChannel().shutdownWrites();
                    if (!result.getRequestChannel().flush()) {
                        result.getRequestChannel().getWriteSetter().set(ChannelListeners.flushingChannelListener(null, null));
                        result.getRequestChannel().resumeWrites();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    latch.countDown();
                }
            }

            public void failed(IOException e) {
                e.printStackTrace();
                latch.countDown();
            }
        };
    }

    static {
        RESPONSE_BODY = AttachmentKey.create(String.class);
        OptionMap.Builder builder = OptionMap.builder().set(Options.WORKER_IO_THREADS, 8).set(Options.TCP_NODELAY, true).set(Options.KEEP_ALIVE, true).set(Options.WORKER_NAME, (Object)"Client");
        DEFAULT_OPTIONS = builder.getMap();
        SIMPLE_MESSAGE_HANDLER = new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                HttpClientTestCase.sendMessage(exchange);
            }
        };
        try {
            ADDRESS = new URI(DefaultServer.getDefaultServerURL());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

