/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.UndertowOptions;
import io.undertow.channels.DetachableStreamSinkChannel;
import io.undertow.channels.DetachableStreamSourceChannel;
import io.undertow.conduits.EmptyStreamSourceConduit;
import io.undertow.io.AsyncSenderImpl;
import io.undertow.io.BlockingSenderImpl;
import io.undertow.io.Sender;
import io.undertow.io.UndertowInputStream;
import io.undertow.io.UndertowOutputStream;
import io.undertow.security.api.SecurityContext;
import io.undertow.server.BlockingHttpExchange;
import io.undertow.server.ConduitWrapper;
import io.undertow.server.Connectors;
import io.undertow.server.DefaultResponseListener;
import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpUpgradeListener;
import io.undertow.server.ServerConnection;
import io.undertow.server.handlers.Cookie;
import io.undertow.util.AbstractAttachable;
import io.undertow.util.AttachmentKey;
import io.undertow.util.ConduitFactory;
import io.undertow.util.Cookies;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.NetworkUtils;
import io.undertow.util.Protocols;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.security.AccessController;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.jboss.logging.Logger;
import org.xnio.Bits;
import org.xnio.Buffers;
import org.xnio.ChannelExceptionHandler;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.Pooled;
import org.xnio.XnioIoThread;
import org.xnio.channels.Channels;
import org.xnio.channels.Configurable;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.Conduit;
import org.xnio.conduits.ConduitStreamSinkChannel;
import org.xnio.conduits.ConduitStreamSourceChannel;
import org.xnio.conduits.StreamSinkConduit;
import org.xnio.conduits.StreamSourceConduit;

public final class HttpServerExchange
extends AbstractAttachable {
    private static final Logger log = Logger.getLogger(HttpServerExchange.class);
    private static final RuntimePermission SET_SECURITY_CONTEXT = new RuntimePermission("io.undertow.SET_SECURITY_CONTEXT");
    private static final String ISO_8859_1 = "ISO-8859-1";
    static final AttachmentKey<Pooled<ByteBuffer>[]> BUFFERED_REQUEST_DATA = AttachmentKey.create(Pooled[].class);
    private final ServerConnection connection;
    private final HeaderMap requestHeaders;
    private final HeaderMap responseHeaders;
    private int exchangeCompletionListenersCount = 0;
    private ExchangeCompletionListener[] exchangeCompleteListeners;
    private DefaultResponseListener[] defaultResponseListeners;
    private Map<String, Deque<String>> queryParameters;
    private Map<String, Deque<String>> pathParameters;
    private Map<String, Cookie> requestCookies;
    private Map<String, Cookie> responseCookies;
    private WriteDispatchChannel responseChannel;
    protected ReadDispatchChannel requestChannel;
    private BlockingHttpExchange blockingHttpExchange;
    private HttpString protocol;
    private SecurityContext securityContext;
    private int state = 200;
    private HttpString requestMethod;
    private String requestScheme;
    private String requestURI;
    private String requestPath;
    private String relativePath;
    private String resolvedPath = "";
    private String queryString = "";
    private int requestWrapperCount = 0;
    private ConduitWrapper<StreamSourceConduit>[] requestWrappers;
    private int responseWrapperCount = 0;
    private ConduitWrapper<StreamSinkConduit>[] responseWrappers;
    private Sender sender;
    private long requestStartTime = -1L;
    private long maxEntitySize;
    private Runnable dispatchTask;
    private Executor dispatchExecutor;
    private long responseBytesSent = 0L;
    private static final int MASK_RESPONSE_CODE = Bits.intBitMask((int)0, (int)9);
    private static final int FLAG_RESPONSE_SENT = 1024;
    private static final int FLAG_RESPONSE_TERMINATED = 2048;
    private static final int FLAG_REQUEST_TERMINATED = 4096;
    private static final int FLAG_PERSISTENT = 16384;
    private static final int FLAG_DISPATCHED = 32768;
    private static final int FLAG_URI_CONTAINS_HOST = 65536;
    private static final int FLAG_IN_CALL = 131072;
    private static final int FLAG_SHOULD_RESUME_READS = 262144;
    private static final int FLAG_SHOULD_RESUME_WRITES = 524288;
    private InetSocketAddress sourceAddress;
    private InetSocketAddress destinationAddress;

    public HttpServerExchange(ServerConnection connection, long maxEntitySize) {
        this(connection, new HeaderMap(), new HeaderMap(), maxEntitySize);
    }

    public HttpServerExchange(ServerConnection connection) {
        this(connection, 0L);
    }

    public HttpServerExchange(ServerConnection connection, HeaderMap requestHeaders, HeaderMap responseHeaders, long maxEntitySize) {
        this.connection = connection;
        this.maxEntitySize = maxEntitySize;
        this.requestHeaders = requestHeaders;
        this.responseHeaders = responseHeaders;
    }

    public HttpString getProtocol() {
        return this.protocol;
    }

    public HttpServerExchange setProtocol(HttpString protocol) {
        this.protocol = protocol;
        return this;
    }

    public boolean isHttp09() {
        return this.protocol.equals(Protocols.HTTP_0_9);
    }

    public boolean isHttp10() {
        return this.protocol.equals(Protocols.HTTP_1_0);
    }

    public boolean isHttp11() {
        return this.protocol.equals(Protocols.HTTP_1_1);
    }

    public HttpString getRequestMethod() {
        return this.requestMethod;
    }

    public HttpServerExchange setRequestMethod(HttpString requestMethod) {
        this.requestMethod = requestMethod;
        return this;
    }

    public String getRequestScheme() {
        return this.requestScheme;
    }

    public HttpServerExchange setRequestScheme(String requestScheme) {
        this.requestScheme = requestScheme;
        return this;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public HttpServerExchange setRequestURI(String requestURI) {
        this.requestURI = requestURI;
        return this;
    }

    public HttpServerExchange setRequestURI(String requestURI, boolean containsHost) {
        this.requestURI = requestURI;
        this.state = containsHost ? (this.state |= 0x10000) : (this.state &= 0xFFFEFFFF);
        return this;
    }

    public boolean isHostIncludedInRequestURI() {
        return Bits.anyAreSet((int)this.state, (int)65536);
    }

    public String getRequestPath() {
        return this.requestPath;
    }

    public HttpServerExchange setRequestPath(String requestPath) {
        this.requestPath = requestPath;
        return this;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public HttpServerExchange setRelativePath(String relativePath) {
        this.relativePath = relativePath;
        return this;
    }

    public String getResolvedPath() {
        return this.resolvedPath;
    }

    public HttpServerExchange setResolvedPath(String resolvedPath) {
        this.resolvedPath = resolvedPath;
        return this;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public HttpServerExchange setQueryString(String queryString) {
        this.queryString = queryString;
        return this;
    }

    public String getRequestURL() {
        if (this.isHostIncludedInRequestURI()) {
            return this.getRequestURI();
        }
        return this.getRequestScheme() + "://" + this.getHostAndPort() + this.getRequestURI();
    }

    public String getRequestCharset() {
        return this.extractCharset(this.requestHeaders);
    }

    public String getResponseCharset() {
        HeaderMap headers = this.responseHeaders;
        return this.extractCharset(headers);
    }

    private String extractCharset(HeaderMap headers) {
        String contentType = headers.getFirst(Headers.CONTENT_TYPE);
        if (contentType == null) {
            return null;
        }
        String value = Headers.extractQuotedValueFromHeader(contentType, "charset");
        if (value != null) {
            return value;
        }
        return ISO_8859_1;
    }

    public String getHostName() {
        String host = this.requestHeaders.getFirst(Headers.HOST);
        if (host == null) {
            host = this.getDestinationAddress().getAddress().getHostAddress();
        } else if (host.startsWith("[")) {
            host = host.substring(1, host.indexOf(93));
        } else if (host.indexOf(58) != -1) {
            host = host.substring(0, host.indexOf(58));
        }
        return host;
    }

    public String getHostAndPort() {
        String host = this.requestHeaders.getFirst(Headers.HOST);
        if (host == null) {
            host = NetworkUtils.formatPossibleIpv6Address(this.getDestinationAddress().getAddress().getHostAddress());
            int port = this.getDestinationAddress().getPort();
            if (!(this.getRequestScheme().equals("http") && port == 80 || this.getRequestScheme().equals("https") && port == 8080)) {
                host = host + ":" + port;
            }
        }
        return host;
    }

    public int getHostPort() {
        String host = this.requestHeaders.getFirst(Headers.HOST);
        if (host != null) {
            int colonIndex = host.startsWith("[") ? host.indexOf(58, host.indexOf(93)) : host.indexOf(58);
            if (colonIndex != -1) {
                return Integer.parseInt(host.substring(colonIndex + 1));
            }
            if (this.getRequestScheme().equals("https")) {
                return 443;
            }
            if (this.getRequestScheme().equals("http")) {
                return 80;
            }
        }
        return this.getDestinationAddress().getPort();
    }

    public ServerConnection getConnection() {
        return this.connection;
    }

    public boolean isPersistent() {
        return Bits.anyAreSet((int)this.state, (int)16384);
    }

    public boolean isInIoThread() {
        return this.getIoThread() == Thread.currentThread();
    }

    public boolean isUpgrade() {
        return this.getResponseCode() == 101;
    }

    public long getResponseBytesSent() {
        return this.responseBytesSent;
    }

    public HttpServerExchange setPersistent(boolean persistent) {
        this.state = persistent ? (this.state |= 0x4000) : (this.state &= 0xFFFFBFFF);
        return this;
    }

    public boolean isDispatched() {
        return Bits.anyAreSet((int)this.state, (int)32768);
    }

    public HttpServerExchange unDispatch() {
        this.state &= 0xFFFF7FFF;
        this.dispatchTask = null;
        return this;
    }

    public HttpServerExchange dispatch() {
        this.state |= 0x8000;
        return this;
    }

    public HttpServerExchange dispatch(Runnable runnable) {
        this.dispatch(null, runnable);
        return this;
    }

    public HttpServerExchange dispatch(Executor executor, Runnable runnable) {
        if (executor != null) {
            this.dispatchExecutor = executor;
        }
        if (this.isInCall()) {
            this.state |= 0x8000;
            this.dispatchTask = runnable;
        } else if (executor == null) {
            this.getConnection().getWorker().execute(runnable);
        } else {
            executor.execute(runnable);
        }
        return this;
    }

    public HttpServerExchange dispatch(HttpHandler handler) {
        this.dispatch(null, handler);
        return this;
    }

    public HttpServerExchange dispatch(Executor executor, final HttpHandler handler) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Connectors.executeRootHandler(handler, HttpServerExchange.this);
            }
        };
        this.dispatch(executor, runnable);
        return this;
    }

    public HttpServerExchange setDispatchExecutor(Executor executor) {
        this.dispatchExecutor = executor == null ? null : executor;
        return this;
    }

    public Executor getDispatchExecutor() {
        return this.dispatchExecutor;
    }

    Runnable getDispatchTask() {
        return this.dispatchTask;
    }

    boolean isInCall() {
        return Bits.anyAreSet((int)this.state, (int)131072);
    }

    HttpServerExchange setInCall(boolean value) {
        this.state = value ? (this.state |= 0x20000) : (this.state &= 0xFFFDFFFF);
        return this;
    }

    public HttpServerExchange upgradeChannel(HttpUpgradeListener listener) {
        if (!this.connection.isUpgradeSupported()) {
            throw UndertowMessages.MESSAGES.upgradeNotSupported();
        }
        this.connection.setUpgradeListener(listener);
        this.setResponseCode(101);
        this.getResponseHeaders().put(Headers.CONNECTION, "Upgrade");
        return this;
    }

    public HttpServerExchange upgradeChannel(String productName, HttpUpgradeListener listener) {
        if (!this.connection.isUpgradeSupported()) {
            throw UndertowMessages.MESSAGES.upgradeNotSupported();
        }
        this.connection.setUpgradeListener(listener);
        this.setResponseCode(101);
        HeaderMap headers = this.getResponseHeaders();
        headers.put(Headers.UPGRADE, productName);
        headers.put(Headers.CONNECTION, "Upgrade");
        return this;
    }

    public HttpServerExchange addExchangeCompleteListener(ExchangeCompletionListener listener) {
        int exchangeCompletionListenersCount = this.exchangeCompletionListenersCount++;
        ExchangeCompletionListener[] exchangeCompleteListeners = this.exchangeCompleteListeners;
        if (exchangeCompleteListeners == null || exchangeCompleteListeners.length == exchangeCompletionListenersCount) {
            ExchangeCompletionListener[] old = exchangeCompleteListeners;
            this.exchangeCompleteListeners = exchangeCompleteListeners = new ExchangeCompletionListener[exchangeCompletionListenersCount + 2];
            if (old != null) {
                System.arraycopy(old, 0, exchangeCompleteListeners, 0, exchangeCompletionListenersCount);
            }
        }
        exchangeCompleteListeners[exchangeCompletionListenersCount] = listener;
        return this;
    }

    public HttpServerExchange addDefaultResponseListener(DefaultResponseListener listener) {
        if (this.defaultResponseListeners == null) {
            this.defaultResponseListeners = new DefaultResponseListener[2];
        } else {
            int i;
            for (i = 0; i != this.defaultResponseListeners.length && this.defaultResponseListeners[i] != null; ++i) {
            }
            if (i == this.defaultResponseListeners.length) {
                DefaultResponseListener[] old = this.defaultResponseListeners;
                this.defaultResponseListeners = new DefaultResponseListener[this.defaultResponseListeners.length + 2];
                System.arraycopy(old, 0, this.defaultResponseListeners, 0, old.length);
            }
        }
        this.defaultResponseListeners[i] = listener;
        return this;
    }

    public InetSocketAddress getSourceAddress() {
        if (this.sourceAddress != null) {
            return this.sourceAddress;
        }
        return this.connection.getPeerAddress(InetSocketAddress.class);
    }

    public HttpServerExchange setSourceAddress(InetSocketAddress sourceAddress) {
        this.sourceAddress = sourceAddress;
        return this;
    }

    public InetSocketAddress getDestinationAddress() {
        if (this.destinationAddress != null) {
            return this.destinationAddress;
        }
        return this.connection.getLocalAddress(InetSocketAddress.class);
    }

    public HttpServerExchange setDestinationAddress(InetSocketAddress destinationAddress) {
        this.destinationAddress = destinationAddress;
        return this;
    }

    public HeaderMap getRequestHeaders() {
        return this.requestHeaders;
    }

    public long getRequestContentLength() {
        String contentLengthString = this.requestHeaders.getFirst(Headers.CONTENT_LENGTH);
        if (contentLengthString == null) {
            return -1L;
        }
        return Long.parseLong(contentLengthString);
    }

    public HeaderMap getResponseHeaders() {
        return this.responseHeaders;
    }

    public long getResponseContentLength() {
        String contentLengthString = this.responseHeaders.getFirst(Headers.CONTENT_LENGTH);
        if (contentLengthString == null) {
            return -1L;
        }
        return Long.parseLong(contentLengthString);
    }

    public HttpServerExchange setResponseContentLength(long length) {
        if (length == -1L) {
            this.responseHeaders.remove(Headers.CONTENT_LENGTH);
        } else {
            this.responseHeaders.put(Headers.CONTENT_LENGTH, Long.toString(length));
        }
        return this;
    }

    public Map<String, Deque<String>> getQueryParameters() {
        if (this.queryParameters == null) {
            this.queryParameters = new TreeMap<String, Deque<String>>();
        }
        return this.queryParameters;
    }

    public HttpServerExchange addQueryParam(String name, String param) {
        Deque<String> list;
        if (this.queryParameters == null) {
            this.queryParameters = new TreeMap<String, Deque<String>>();
        }
        if ((list = this.queryParameters.get(name)) == null) {
            list = new ArrayDeque<String>(2);
            this.queryParameters.put(name, list);
        }
        list.add(param);
        return this;
    }

    public Map<String, Deque<String>> getPathParameters() {
        if (this.pathParameters == null) {
            this.pathParameters = new TreeMap<String, Deque<String>>();
        }
        return this.pathParameters;
    }

    public HttpServerExchange addPathParam(String name, String param) {
        Deque<String> list;
        if (this.pathParameters == null) {
            this.pathParameters = new TreeMap<String, Deque<String>>();
        }
        if ((list = this.pathParameters.get(name)) == null) {
            list = new ArrayDeque<String>(2);
            this.pathParameters.put(name, list);
        }
        list.add(param);
        return this;
    }

    public Map<String, Cookie> getRequestCookies() {
        if (this.requestCookies == null) {
            this.requestCookies = Cookies.parseRequestCookies(this.getConnection().getUndertowOptions().get(UndertowOptions.MAX_COOKIES, 200), this.getConnection().getUndertowOptions().get(UndertowOptions.ALLOW_EQUALS_IN_COOKIE_VALUE, false), this.requestHeaders.get(Headers.COOKIE));
        }
        return this.requestCookies;
    }

    public HttpServerExchange setResponseCookie(Cookie cookie) {
        if (this.responseCookies == null) {
            this.responseCookies = new TreeMap<String, Cookie>();
        }
        this.responseCookies.put(cookie.getName(), cookie);
        return this;
    }

    public Map<String, Cookie> getResponseCookies() {
        if (this.responseCookies == null) {
            this.responseCookies = new TreeMap<String, Cookie>();
        }
        return this.responseCookies;
    }

    Map<String, Cookie> getResponseCookiesInternal() {
        return this.responseCookies;
    }

    public boolean isResponseStarted() {
        return Bits.allAreSet((int)this.state, (int)1024);
    }

    public StreamSourceChannel getRequestChannel() {
        if (this.requestChannel != null) {
            return null;
        }
        if (Bits.anyAreSet((int)this.state, (int)4096)) {
            this.requestChannel = new ReadDispatchChannel(new ConduitStreamSourceChannel(Configurable.EMPTY, (StreamSourceConduit)new EmptyStreamSourceConduit(this.getIoThread())));
            return this.requestChannel;
        }
        ConduitWrapper<StreamSourceConduit>[] wrappers = this.requestWrappers;
        ConduitStreamSourceChannel sourceChannel = this.connection.getSourceChannel();
        if (wrappers != null) {
            this.requestWrappers = null;
            WrapperConduitFactory<StreamSourceConduit> factory = new WrapperConduitFactory<StreamSourceConduit>(wrappers, this.requestWrapperCount, sourceChannel.getConduit(), this);
            sourceChannel.setConduit(factory.create());
        }
        this.requestChannel = new ReadDispatchChannel(sourceChannel);
        return this.requestChannel;
    }

    public boolean isRequestChannelAvailable() {
        return this.requestChannel == null;
    }

    public boolean isComplete() {
        return Bits.allAreSet((int)this.state, (int)6144);
    }

    public boolean isRequestComplete() {
        return Bits.allAreSet((int)this.state, (int)4096);
    }

    public boolean isResponseComplete() {
        return Bits.allAreSet((int)this.state, (int)2048);
    }

    void terminateRequest() {
        int oldVal = this.state;
        if (Bits.allAreSet((int)oldVal, (int)4096)) {
            return;
        }
        if (this.requestChannel != null) {
            this.requestChannel.requestDone();
        }
        this.state = oldVal | 0x1000;
        if (Bits.anyAreSet((int)oldVal, (int)2048)) {
            this.invokeExchangeCompleteListeners();
        }
    }

    private void invokeExchangeCompleteListeners() {
        if (this.exchangeCompletionListenersCount > 0) {
            int i = this.exchangeCompletionListenersCount - 1;
            ExchangeCompletionListener next = this.exchangeCompleteListeners[i];
            this.exchangeCompletionListenersCount = -1;
            next.exchangeEvent(this, new ExchangeCompleteNextListener(this.exchangeCompleteListeners, this, i));
        } else if (this.exchangeCompletionListenersCount == 0) {
            this.exchangeCompletionListenersCount = -1;
            this.connection.exchangeComplete(this);
        }
    }

    public StreamSinkChannel getResponseChannel() {
        if (this.responseChannel != null) {
            return null;
        }
        ConduitWrapper<StreamSinkConduit>[] wrappers = this.responseWrappers;
        this.responseWrappers = null;
        ConduitStreamSinkChannel sinkChannel = this.connection.getSinkChannel();
        if (sinkChannel == null) {
            return null;
        }
        if (wrappers != null) {
            WrapperStreamSinkConduitFactory factory = new WrapperStreamSinkConduitFactory(wrappers, this.responseWrapperCount, this, sinkChannel.getConduit());
            sinkChannel.setConduit(factory.create());
        } else {
            sinkChannel.setConduit(this.connection.getSinkConduit(this, sinkChannel.getConduit()));
        }
        this.responseChannel = new WriteDispatchChannel(sinkChannel);
        this.startResponse();
        return this.responseChannel;
    }

    public Sender getResponseSender() {
        if (this.blockingHttpExchange != null) {
            return this.blockingHttpExchange.getSender();
        }
        if (this.sender != null) {
            return this.sender;
        }
        this.sender = new AsyncSenderImpl(this);
        return this.sender;
    }

    public boolean isResponseChannelAvailable() {
        return this.responseChannel == null;
    }

    public HttpServerExchange setResponseCode(int responseCode) {
        if (responseCode < 0 || responseCode > 999) {
            throw new IllegalArgumentException("Invalid response code");
        }
        int oldVal = this.state;
        if (Bits.allAreSet((int)oldVal, (int)1024)) {
            throw UndertowMessages.MESSAGES.responseAlreadyStarted();
        }
        this.state = oldVal & ~MASK_RESPONSE_CODE | responseCode & MASK_RESPONSE_CODE;
        return this;
    }

    public HttpServerExchange addRequestWrapper(ConduitWrapper<StreamSourceConduit> wrapper) {
        ConduitWrapper<StreamSourceConduit>[] wrappers = this.requestWrappers;
        if (this.requestChannel != null) {
            throw UndertowMessages.MESSAGES.requestChannelAlreadyProvided();
        }
        if (wrappers == null) {
            wrappers = this.requestWrappers = new ConduitWrapper[2];
        } else if (wrappers.length == this.requestWrapperCount) {
            this.requestWrappers = new ConduitWrapper[wrappers.length + 2];
            System.arraycopy(wrappers, 0, this.requestWrappers, 0, wrappers.length);
            wrappers = this.requestWrappers;
        }
        wrappers[this.requestWrapperCount++] = wrapper;
        return this;
    }

    public HttpServerExchange addResponseWrapper(ConduitWrapper<StreamSinkConduit> wrapper) {
        ConduitWrapper<StreamSinkConduit>[] wrappers = this.responseWrappers;
        if (this.responseChannel != null) {
            throw UndertowMessages.MESSAGES.responseChannelAlreadyProvided();
        }
        if (wrappers == null) {
            this.responseWrappers = wrappers = new ConduitWrapper[2];
        } else if (wrappers.length == this.responseWrapperCount) {
            this.responseWrappers = new ConduitWrapper[wrappers.length + 2];
            System.arraycopy(wrappers, 0, this.responseWrappers, 0, wrappers.length);
            wrappers = this.responseWrappers;
        }
        wrappers[this.responseWrapperCount++] = wrapper;
        return this;
    }

    public BlockingHttpExchange startBlocking() {
        BlockingHttpExchange old = this.blockingHttpExchange;
        this.blockingHttpExchange = new DefaultBlockingHttpExchange(this);
        return old;
    }

    public BlockingHttpExchange startBlocking(BlockingHttpExchange httpExchange) {
        BlockingHttpExchange old = this.blockingHttpExchange;
        this.blockingHttpExchange = httpExchange;
        return old;
    }

    public boolean isBlocking() {
        return this.blockingHttpExchange != null;
    }

    public InputStream getInputStream() {
        if (this.blockingHttpExchange == null) {
            throw UndertowMessages.MESSAGES.startBlockingHasNotBeenCalled();
        }
        return this.blockingHttpExchange.getInputStream();
    }

    public OutputStream getOutputStream() {
        if (this.blockingHttpExchange == null) {
            throw UndertowMessages.MESSAGES.startBlockingHasNotBeenCalled();
        }
        return this.blockingHttpExchange.getOutputStream();
    }

    public int getResponseCode() {
        return this.state & MASK_RESPONSE_CODE;
    }

    HttpServerExchange terminateResponse() {
        int oldVal = this.state;
        if (Bits.allAreSet((int)oldVal, (int)2048)) {
            return this;
        }
        this.responseChannel.responseDone();
        this.state = oldVal | 0x800;
        if (Bits.anyAreSet((int)oldVal, (int)4096)) {
            this.invokeExchangeCompleteListeners();
        }
        return this;
    }

    public long getRequestStartTime() {
        return this.requestStartTime;
    }

    HttpServerExchange setRequestStartTime(long requestStartTime) {
        this.requestStartTime = requestStartTime;
        return this;
    }

    public HttpServerExchange endExchange() {
        final int state = this.state;
        if (Bits.allAreSet((int)state, (int)6144)) {
            if (this.blockingHttpExchange != null) {
                IoUtils.safeClose((Closeable)this.blockingHttpExchange);
            }
            return this;
        }
        if (this.defaultResponseListeners != null) {
            for (int i = this.defaultResponseListeners.length - 1; i >= 0; --i) {
                DefaultResponseListener listener = this.defaultResponseListeners[i];
                if (listener == null) continue;
                this.defaultResponseListeners[i] = null;
                try {
                    if (listener.handleDefaultResponse(this)) {
                        return this;
                    }
                    continue;
                }
                catch (Exception e) {
                    UndertowLogger.REQUEST_LOGGER.debug("Exception running default response listener", e);
                }
            }
        }
        if (Bits.anyAreClear((int)state, (int)4096)) {
            this.connection.terminateRequestChannel(this);
        }
        if (this.blockingHttpExchange != null) {
            try {
                this.blockingHttpExchange.close();
            }
            catch (IOException e) {
                UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
                IoUtils.safeClose((Closeable)((Object)this.connection));
            }
        }
        if (Bits.anyAreClear((int)state, (int)4096)) {
            if (this.requestChannel == null) {
                this.getRequestChannel();
            }
            int totalRead = 0;
            try {
                long read;
                do {
                    read = Channels.drain((StreamSourceChannel)this.requestChannel, (long)Long.MAX_VALUE);
                    totalRead = (int)((long)totalRead + read);
                    if (read != 0L) continue;
                    if (this.getResponseCode() != 417 || totalRead > 0) {
                        this.requestChannel.getReadSetter().set(ChannelListeners.drainListener((long)Long.MAX_VALUE, (ChannelListener)new ChannelListener<StreamSourceChannel>(){

                            public void handleEvent(StreamSourceChannel channel) {
                                if (Bits.anyAreClear((int)state, (int)2048)) {
                                    HttpServerExchange.this.closeAndFlushResponse();
                                }
                            }
                        }, (ChannelExceptionHandler)new ChannelExceptionHandler<StreamSourceChannel>(){

                            public void handleException(StreamSourceChannel channel, IOException e) {
                                HttpServerExchange.this.invokeExchangeCompleteListeners();
                                UndertowLogger.REQUEST_LOGGER.debug("Exception draining request stream", e);
                                IoUtils.safeClose((Closeable)((Object)HttpServerExchange.this.connection));
                            }
                        }));
                        this.requestChannel.resumeReads();
                        return this;
                    }
                    break;
                } while (read != -1L);
            }
            catch (IOException e) {
                UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
                IoUtils.safeClose((Closeable)((Object)this.connection));
            }
        }
        if (Bits.anyAreClear((int)state, (int)2048)) {
            this.closeAndFlushResponse();
        }
        return this;
    }

    private void closeAndFlushResponse() {
        if (!this.connection.isOpen()) {
            this.invokeExchangeCompleteListeners();
            return;
        }
        try {
            if (this.isResponseChannelAvailable()) {
                this.getResponseHeaders().put(Headers.CONTENT_LENGTH, "0");
                this.getResponseChannel();
            }
            this.responseChannel.shutdownWrites();
            if (!this.responseChannel.flush()) {
                this.responseChannel.getWriteSetter().set(ChannelListeners.flushingChannelListener((ChannelListener)new ChannelListener<StreamSinkChannel>(){

                    public void handleEvent(StreamSinkChannel channel) {
                        channel.suspendWrites();
                        channel.getWriteSetter().set(null);
                    }
                }, (ChannelExceptionHandler)new ChannelExceptionHandler<Channel>(){

                    public void handleException(Channel channel, IOException exception) {
                        HttpServerExchange.this.invokeExchangeCompleteListeners();
                        UndertowLogger.REQUEST_LOGGER.debug("Exception ending request", exception);
                        IoUtils.safeClose((Closeable)((Object)HttpServerExchange.this.connection));
                    }
                }));
                this.responseChannel.resumeWrites();
            }
        }
        catch (IOException e) {
            UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
            IoUtils.safeClose((Closeable)((Object)this.connection));
        }
    }

    HttpServerExchange startResponse() throws IllegalStateException {
        int oldVal = this.state;
        if (Bits.allAreSet((int)oldVal, (int)1024)) {
            throw UndertowMessages.MESSAGES.responseAlreadyStarted();
        }
        this.state = oldVal | 0x400;
        log.tracef("Starting to write response for %s", (Object)this);
        return this;
    }

    public XnioIoThread getIoThread() {
        return this.connection.getIoThread();
    }

    public long getMaxEntitySize() {
        return this.maxEntitySize;
    }

    public HttpServerExchange setMaxEntitySize(long maxEntitySize) {
        if (!this.isRequestChannelAvailable()) {
            throw UndertowMessages.MESSAGES.requestChannelAlreadyProvided();
        }
        this.maxEntitySize = maxEntitySize;
        this.connection.maxEntitySizeUpdated(this);
        return this;
    }

    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public void setSecurityContext(SecurityContext securityContext) {
        if (System.getSecurityManager() != null) {
            AccessController.checkPermission(SET_SECURITY_CONTEXT);
        }
        this.securityContext = securityContext;
    }

    boolean runResumeReadWrite() {
        boolean ret = false;
        if (Bits.anyAreSet((int)this.state, (int)524288)) {
            this.responseChannel.runResume();
            ret = true;
        }
        if (Bits.anyAreSet((int)this.state, (int)262144)) {
            this.requestChannel.runResume();
            ret = true;
        }
        this.state &= 0xFFF3FFFF;
        return ret;
    }

    public String toString() {
        return "HttpServerExchange{ " + this.getRequestMethod().toString() + " " + this.getRequestURI() + '}';
    }

    public static class WrapperConduitFactory<T extends Conduit>
    implements ConduitFactory<T> {
        private final HttpServerExchange exchange;
        private final ConduitWrapper<T>[] wrappers;
        private int position;
        private T first;

        public WrapperConduitFactory(ConduitWrapper<T>[] wrappers, int wrapperCount, T first, HttpServerExchange exchange) {
            this.wrappers = wrappers;
            this.exchange = exchange;
            this.position = wrapperCount - 1;
            this.first = first;
        }

        @Override
        public T create() {
            if (this.position == -1) {
                return this.first;
            }
            return this.wrappers[this.position--].wrap(this, this.exchange);
        }
    }

    public static class WrapperStreamSinkConduitFactory
    implements ConduitFactory<StreamSinkConduit> {
        private final HttpServerExchange exchange;
        private final ConduitWrapper<StreamSinkConduit>[] wrappers;
        private int position;
        private final StreamSinkConduit first;

        public WrapperStreamSinkConduitFactory(ConduitWrapper<StreamSinkConduit>[] wrappers, int wrapperCount, HttpServerExchange exchange, StreamSinkConduit first) {
            this.wrappers = wrappers;
            this.exchange = exchange;
            this.first = first;
            this.position = wrapperCount - 1;
        }

        @Override
        public StreamSinkConduit create() {
            if (this.position == -1) {
                return this.exchange.getConnection().getSinkConduit(this.exchange, this.first);
            }
            return this.wrappers[this.position--].wrap(this, this.exchange);
        }
    }

    private final class ReadDispatchChannel
    extends DetachableStreamSourceChannel
    implements StreamSourceChannel {
        private boolean wakeup;
        private boolean readsResumed;

        public ReadDispatchChannel(ConduitStreamSourceChannel delegate) {
            super((StreamSourceChannel)delegate);
            this.wakeup = true;
            this.readsResumed = false;
        }

        @Override
        protected boolean isFinished() {
            return Bits.allAreSet((int)HttpServerExchange.this.state, (int)4096);
        }

        @Override
        public void resumeReads() {
            this.readsResumed = true;
            if (this.isFinished()) {
                return;
            }
            if (HttpServerExchange.this.isInCall()) {
                HttpServerExchange.this.state |= 262144;
            } else {
                this.delegate.resumeReads();
            }
        }

        @Override
        public void wakeupReads() {
            if (HttpServerExchange.this.isInCall()) {
                this.wakeup = true;
                HttpServerExchange.this.state |= 262144;
            } else if (this.isFinished()) {
                this.invokeListener();
            } else {
                this.delegate.wakeupReads();
            }
        }

        private void invokeListener() {
            if (this.readSetter != null) {
                this.getIoThread().execute(new Runnable(){

                    @Override
                    public void run() {
                        ChannelListeners.invokeChannelListener((Channel)((Object)ReadDispatchChannel.this), (ChannelListener)ReadDispatchChannel.this.readSetter.get());
                    }
                });
            }
        }

        public void requestDone() {
            if (this.delegate instanceof ConduitStreamSourceChannel) {
                ((ConduitStreamSourceChannel)this.delegate).setReadListener(null);
                ((ConduitStreamSourceChannel)this.delegate).setCloseListener(null);
            } else {
                this.delegate.getReadSetter().set(null);
                this.delegate.getCloseSetter().set(null);
            }
        }

        @Override
        public long transferTo(long position, long count, FileChannel target) throws IOException {
            Pooled<ByteBuffer>[] buffered = HttpServerExchange.this.getAttachment(BUFFERED_REQUEST_DATA);
            if (buffered == null) {
                return super.transferTo(position, count, target);
            }
            return target.transferFrom((ReadableByteChannel)((Object)this), position, count);
        }

        @Override
        public void awaitReadable() throws IOException {
            if (Thread.currentThread() == this.getIoThread()) {
                throw UndertowMessages.MESSAGES.awaitCalledFromIoThread();
            }
            Pooled<ByteBuffer>[] buffered = HttpServerExchange.this.getAttachment(BUFFERED_REQUEST_DATA);
            if (buffered == null) {
                super.awaitReadable();
            }
        }

        @Override
        public void suspendReads() {
            this.readsResumed = false;
            super.suspendReads();
        }

        @Override
        public long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
            Pooled<ByteBuffer>[] buffered = HttpServerExchange.this.getAttachment(BUFFERED_REQUEST_DATA);
            if (buffered == null) {
                return super.transferTo(count, throughBuffer, target);
            }
            throughBuffer.position(0);
            throughBuffer.limit(0);
            long copied = 0L;
            for (int i = 0; i < buffered.length; ++i) {
                Pooled<ByteBuffer> pooled = buffered[i];
                if (pooled == null) continue;
                ByteBuffer buf = (ByteBuffer)pooled.getResource();
                if (buf.hasRemaining()) {
                    int res = target.write(buf);
                    if (!buf.hasRemaining()) {
                        pooled.free();
                        buffered[i] = null;
                    }
                    if (res == 0) {
                        return copied;
                    }
                    copied += (long)res;
                    continue;
                }
                pooled.free();
                buffered[i] = null;
            }
            HttpServerExchange.this.removeAttachment(BUFFERED_REQUEST_DATA);
            if (copied == 0L) {
                return super.transferTo(count, throughBuffer, target);
            }
            return copied;
        }

        @Override
        public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
            if (Thread.currentThread() == this.getIoThread()) {
                throw UndertowMessages.MESSAGES.awaitCalledFromIoThread();
            }
            Pooled<ByteBuffer>[] buffered = HttpServerExchange.this.getAttachment(BUFFERED_REQUEST_DATA);
            if (buffered == null) {
                super.awaitReadable(time, timeUnit);
            }
        }

        @Override
        public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
            Pooled<ByteBuffer>[] buffered = HttpServerExchange.this.getAttachment(BUFFERED_REQUEST_DATA);
            if (buffered == null) {
                return super.read(dsts, offset, length);
            }
            long copied = 0L;
            for (int i = 0; i < buffered.length; ++i) {
                Pooled<ByteBuffer> pooled = buffered[i];
                if (pooled == null) continue;
                ByteBuffer buf = (ByteBuffer)pooled.getResource();
                if (buf.hasRemaining()) {
                    copied += (long)Buffers.copy((ByteBuffer[])dsts, (int)offset, (int)length, (ByteBuffer)buf);
                    if (!buf.hasRemaining()) {
                        pooled.free();
                        buffered[i] = null;
                    }
                    if (Buffers.hasRemaining((Buffer[])dsts, (int)offset, (int)length)) continue;
                    return copied;
                }
                pooled.free();
                buffered[i] = null;
            }
            HttpServerExchange.this.removeAttachment(BUFFERED_REQUEST_DATA);
            if (copied == 0L) {
                return super.read(dsts, offset, length);
            }
            return copied;
        }

        @Override
        public long read(ByteBuffer[] dsts) throws IOException {
            return this.read(dsts, 0, dsts.length);
        }

        @Override
        public boolean isOpen() {
            Pooled<ByteBuffer>[] buffered = HttpServerExchange.this.getAttachment(BUFFERED_REQUEST_DATA);
            if (buffered != null) {
                return true;
            }
            return super.isOpen();
        }

        @Override
        public void close() throws IOException {
            Pooled<ByteBuffer>[] buffered = HttpServerExchange.this.getAttachment(BUFFERED_REQUEST_DATA);
            if (buffered != null) {
                for (Pooled<ByteBuffer> pooled : buffered) {
                    if (pooled == null) continue;
                    pooled.free();
                }
            }
            HttpServerExchange.this.removeAttachment(BUFFERED_REQUEST_DATA);
            super.close();
        }

        @Override
        public boolean isReadResumed() {
            Pooled<ByteBuffer>[] buffered = HttpServerExchange.this.getAttachment(BUFFERED_REQUEST_DATA);
            if (buffered != null) {
                return this.readsResumed;
            }
            if (this.isFinished()) {
                return false;
            }
            return Bits.anyAreSet((int)HttpServerExchange.this.state, (int)262144) || super.isReadResumed();
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            Pooled<ByteBuffer>[] buffered = HttpServerExchange.this.getAttachment(BUFFERED_REQUEST_DATA);
            if (buffered == null) {
                return super.read(dst);
            }
            int copied = 0;
            for (int i = 0; i < buffered.length; ++i) {
                Pooled<ByteBuffer> pooled = buffered[i];
                if (pooled == null) continue;
                ByteBuffer buf = (ByteBuffer)pooled.getResource();
                if (buf.hasRemaining()) {
                    copied += Buffers.copy((ByteBuffer)dst, (ByteBuffer)buf);
                    if (!buf.hasRemaining()) {
                        pooled.free();
                        buffered[i] = null;
                    }
                    if (dst.hasRemaining()) continue;
                    return copied;
                }
                pooled.free();
                buffered[i] = null;
            }
            HttpServerExchange.this.removeAttachment(BUFFERED_REQUEST_DATA);
            if (copied == 0) {
                return super.read(dst);
            }
            return copied;
        }

        public void runResume() {
            if (this.isReadResumed()) {
                if (this.wakeup) {
                    this.wakeup = false;
                    this.delegate.wakeupReads();
                } else {
                    this.delegate.resumeReads();
                }
            } else if (this.wakeup) {
                this.wakeup = false;
                this.invokeListener();
            }
        }
    }

    private class WriteDispatchChannel
    extends DetachableStreamSinkChannel
    implements StreamSinkChannel {
        private boolean wakeup;

        public WriteDispatchChannel(ConduitStreamSinkChannel delegate) {
            super((StreamSinkChannel)delegate);
        }

        @Override
        protected boolean isFinished() {
            return Bits.allAreSet((int)HttpServerExchange.this.state, (int)2048);
        }

        @Override
        public void resumeWrites() {
            if (this.isFinished()) {
                return;
            }
            if (HttpServerExchange.this.isInCall()) {
                HttpServerExchange.this.state |= 524288;
            } else {
                this.delegate.resumeWrites();
            }
        }

        @Override
        public void wakeupWrites() {
            if (this.isFinished()) {
                return;
            }
            if (HttpServerExchange.this.isInCall()) {
                this.wakeup = true;
                HttpServerExchange.this.state |= 524288;
            } else {
                this.delegate.wakeupWrites();
            }
        }

        @Override
        public boolean isWriteResumed() {
            return Bits.anyAreSet((int)HttpServerExchange.this.state, (int)524288) || super.isWriteResumed();
        }

        public void runResume() {
            if (!this.isFinished() && this.isWriteResumed()) {
                if (this.wakeup) {
                    this.wakeup = false;
                    this.delegate.wakeupWrites();
                } else {
                    this.delegate.resumeWrites();
                }
            } else if (this.wakeup) {
                this.wakeup = false;
                this.invokeListener();
            }
        }

        private void invokeListener() {
            if (this.writeSetter != null) {
                this.getIoThread().execute(new Runnable(){

                    @Override
                    public void run() {
                        ChannelListeners.invokeChannelListener((Channel)((Object)WriteDispatchChannel.this), (ChannelListener)WriteDispatchChannel.this.writeSetter.get());
                    }
                });
            }
        }

        @Override
        public void awaitWritable() throws IOException {
            if (Thread.currentThread() == this.getIoThread()) {
                throw UndertowMessages.MESSAGES.awaitCalledFromIoThread();
            }
            super.awaitWritable();
        }

        @Override
        public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
            if (Thread.currentThread() == this.getIoThread()) {
                throw UndertowMessages.MESSAGES.awaitCalledFromIoThread();
            }
            super.awaitWritable(time, timeUnit);
        }

        @Override
        public long transferFrom(FileChannel src, long position, long count) throws IOException {
            long l = super.transferFrom(src, position, count);
            HttpServerExchange.this.responseBytesSent += l;
            return l;
        }

        @Override
        public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
            long l = super.transferFrom(source, count, throughBuffer);
            HttpServerExchange.this.responseBytesSent += l;
            return l;
        }

        @Override
        public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
            long l = super.write(srcs, offset, length);
            HttpServerExchange.this.responseBytesSent += l;
            return l;
        }

        @Override
        public long write(ByteBuffer[] srcs) throws IOException {
            long l = super.write(srcs);
            HttpServerExchange.this.responseBytesSent += l;
            return l;
        }

        @Override
        public int writeFinal(ByteBuffer src) throws IOException {
            int l = super.writeFinal(src);
            HttpServerExchange.this.responseBytesSent += l;
            return l;
        }

        @Override
        public long writeFinal(ByteBuffer[] srcs, int offset, int length) throws IOException {
            long l = super.writeFinal(srcs, offset, length);
            HttpServerExchange.this.responseBytesSent += l;
            return l;
        }

        @Override
        public long writeFinal(ByteBuffer[] srcs) throws IOException {
            long l = super.writeFinal(srcs);
            HttpServerExchange.this.responseBytesSent += l;
            return l;
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            int l = super.write(src);
            HttpServerExchange.this.responseBytesSent += l;
            return l;
        }
    }

    private static class DefaultBlockingHttpExchange
    implements BlockingHttpExchange {
        private InputStream inputStream;
        private OutputStream outputStream;
        private Sender sender;
        private final HttpServerExchange exchange;

        DefaultBlockingHttpExchange(HttpServerExchange exchange) {
            this.exchange = exchange;
        }

        @Override
        public InputStream getInputStream() {
            if (this.inputStream == null) {
                this.inputStream = new UndertowInputStream(this.exchange);
            }
            return this.inputStream;
        }

        @Override
        public OutputStream getOutputStream() {
            if (this.outputStream == null) {
                this.outputStream = new UndertowOutputStream(this.exchange);
            }
            return this.outputStream;
        }

        @Override
        public Sender getSender() {
            if (this.sender == null) {
                this.sender = new BlockingSenderImpl(this.exchange, this.getOutputStream());
            }
            return this.sender;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            try {
                this.getInputStream().close();
            }
            finally {
                this.getOutputStream().close();
            }
        }
    }

    private static class ExchangeCompleteNextListener
    implements ExchangeCompletionListener.NextListener {
        private final ExchangeCompletionListener[] list;
        private final HttpServerExchange exchange;
        private int i;

        public ExchangeCompleteNextListener(ExchangeCompletionListener[] list, HttpServerExchange exchange, int i) {
            this.list = list;
            this.exchange = exchange;
            this.i = i;
        }

        @Override
        public void proceed() {
            if (--this.i >= 0) {
                ExchangeCompletionListener next = this.list[this.i];
                next.exchangeEvent(this.exchange, this);
            } else if (this.i == -1) {
                this.exchange.connection.exchangeComplete(this.exchange);
            }
        }
    }
}

