/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.proxy.mod_cluster;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.proxy.mod_cluster.MCMPHandler;
import io.undertow.server.handlers.proxy.mod_cluster.MCMPWebManager;
import io.undertow.server.handlers.proxy.mod_cluster.ModCluster;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class MCMPConfig {
    private final String managementHost;
    private final String managementHostIp;
    private final int managementPort;
    private final AdvertiseConfig advertiseConfig;

    public static Builder builder() {
        return new Builder();
    }

    public static WebBuilder webBuilder() {
        return new WebBuilder();
    }

    public MCMPConfig(Builder builder) {
        this.managementHost = builder.managementHost;
        this.managementPort = builder.managementPort;
        this.advertiseConfig = builder.advertiseBuilder != null ? new AdvertiseConfig(builder.advertiseBuilder, this) : null;
        String mhip = this.managementHost;
        try {
            mhip = InetAddress.getByName(this.managementHost).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.managementHostIp = mhip;
    }

    public String getManagementHost() {
        return this.managementHost;
    }

    public int getManagementPort() {
        return this.managementPort;
    }

    public String getManagementHostIp() {
        return this.managementHostIp;
    }

    AdvertiseConfig getAdvertiseConfig() {
        return this.advertiseConfig;
    }

    public HttpHandler create(ModCluster modCluster, HttpHandler next) {
        return new MCMPHandler(this, modCluster, next);
    }

    public static class AdvertiseBuilder {
        String advertiseGroup = "224.0.1.105";
        String advertiseAddress = "127.0.0.1";
        int advertisePort = 23364;
        String securityKey;
        String protocol = "http";
        String path = "/";
        int advertiseFrequency = 10000;
        private final Builder parent;

        public AdvertiseBuilder(Builder parent) {
            this.parent = parent;
        }

        public AdvertiseBuilder setAdvertiseGroup(String advertiseGroup) {
            this.advertiseGroup = advertiseGroup;
            return this;
        }

        public AdvertiseBuilder setAdvertiseAddress(String advertiseAddress) {
            this.advertiseAddress = advertiseAddress;
            return this;
        }

        public AdvertiseBuilder setAdvertisePort(int advertisePort) {
            this.advertisePort = advertisePort;
            return this;
        }

        public AdvertiseBuilder setSecurityKey(String securityKey) {
            this.securityKey = securityKey;
            return this;
        }

        public AdvertiseBuilder setProtocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public AdvertiseBuilder setPath(String path) {
            this.path = path.startsWith("/") ? path : "/" + path;
            return this;
        }

        public AdvertiseBuilder setAdvertiseFrequency(int advertiseFrequency) {
            this.advertiseFrequency = advertiseFrequency;
            return this;
        }

        public Builder getParent() {
            return this.parent;
        }
    }

    public static class WebBuilder
    extends Builder {
        boolean checkNonce = true;
        boolean reduceDisplay = false;
        boolean allowCmd = true;
        boolean displaySessionids = false;

        public WebBuilder setCheckNonce(boolean checkNonce) {
            this.checkNonce = checkNonce;
            return this;
        }

        public WebBuilder setReduceDisplay(boolean reduceDisplay) {
            this.reduceDisplay = reduceDisplay;
            return this;
        }

        public WebBuilder setAllowCmd(boolean allowCmd) {
            this.allowCmd = allowCmd;
            return this;
        }

        public WebBuilder setDisplaySessionids(boolean displaySessionids) {
            this.displaySessionids = displaySessionids;
            return this;
        }

        @Override
        public MCMPConfig build() {
            return new MCMPWebManagerConfig(this);
        }
    }

    public static class Builder {
        private String managementHost;
        private int managementPort;
        private AdvertiseBuilder advertiseBuilder;

        public Builder setManagementHost(String managementHost) {
            this.managementHost = managementHost;
            return this;
        }

        public Builder setManagementPort(int managementPort) {
            this.managementPort = managementPort;
            return this;
        }

        public AdvertiseBuilder enableAdvertise() {
            this.advertiseBuilder = new AdvertiseBuilder(this);
            return this.advertiseBuilder;
        }

        public MCMPConfig build() {
            return new MCMPConfig(this);
        }

        public HttpHandler create(ModCluster modCluster, HttpHandler next) {
            MCMPConfig config = this.build();
            return config.create(modCluster, next);
        }
    }

    static class AdvertiseConfig {
        private final String advertiseGroup;
        private final String advertiseAddress;
        private final int advertisePort;
        private final String securityKey;
        private final String protocol;
        private final String path;
        private final int advertiseFrequency;
        private final String managementHost;
        private final int managementPort;

        AdvertiseConfig(AdvertiseBuilder builder, MCMPConfig config) {
            this.advertiseGroup = builder.advertiseGroup;
            this.advertiseAddress = builder.advertiseAddress;
            this.advertiseFrequency = builder.advertiseFrequency;
            this.advertisePort = builder.advertisePort;
            this.securityKey = builder.securityKey;
            this.protocol = builder.protocol;
            this.path = builder.path;
            this.managementHost = config.getManagementHost();
            this.managementPort = config.getManagementPort();
        }

        public String getAdvertiseGroup() {
            return this.advertiseGroup;
        }

        public String getAdvertiseAddress() {
            return this.advertiseAddress;
        }

        public int getAdvertisePort() {
            return this.advertisePort;
        }

        public String getSecurityKey() {
            return this.securityKey;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public String getPath() {
            return this.path;
        }

        public int getAdvertiseFrequency() {
            return this.advertiseFrequency;
        }

        public String getManagementHost() {
            return this.managementHost;
        }

        public int getManagementPort() {
            return this.managementPort;
        }
    }

    static class MCMPWebManagerConfig
    extends MCMPConfig {
        private final boolean allowCmd;
        private final boolean checkNonce;
        private final boolean reduceDisplay;
        private final boolean displaySessionids;

        MCMPWebManagerConfig(WebBuilder builder) {
            super(builder);
            this.allowCmd = builder.allowCmd;
            this.checkNonce = builder.checkNonce;
            this.reduceDisplay = builder.reduceDisplay;
            this.displaySessionids = builder.displaySessionids;
        }

        public boolean isAllowCmd() {
            return this.allowCmd;
        }

        public boolean isCheckNonce() {
            return this.checkNonce;
        }

        public boolean isReduceDisplay() {
            return this.reduceDisplay;
        }

        public boolean isDisplaySessionids() {
            return this.displaySessionids;
        }

        @Override
        public HttpHandler create(ModCluster modCluster, HttpHandler next) {
            return new MCMPWebManager(this, modCluster, next);
        }
    }
}

