/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.core.protocol.version07;

import io.undertow.websockets.core.FixedPayloadFrameSourceChannel;
import io.undertow.websockets.core.WebSocketFrameType;
import io.undertow.websockets.core.WebSocketInvalidCloseCodeException;
import io.undertow.websockets.core.WebSocketMessages;
import io.undertow.websockets.core.protocol.version07.Masker;
import io.undertow.websockets.core.protocol.version07.UTF8Checker;
import io.undertow.websockets.core.protocol.version07.WebSocket07Channel;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.xnio.Pooled;

class WebSocket07CloseFrameSourceChannel
extends FixedPayloadFrameSourceChannel {
    private final ByteBuffer status = ByteBuffer.allocate(2);
    private boolean statusValidated;
    private final Masker masker;

    WebSocket07CloseFrameSourceChannel(WebSocket07Channel wsChannel, long payloadSize, int rsv, Masker masker, Pooled<ByteBuffer> pooled, long frameLength) {
        super(wsChannel, WebSocketFrameType.CLOSE, payloadSize, rsv, true, pooled, frameLength, masker, new UTF8Checker());
        this.masker = masker;
    }

    WebSocket07CloseFrameSourceChannel(WebSocket07Channel wsChannel, long payloadSize, int rsv, Pooled<ByteBuffer> pooled, long frameLength) {
        super(wsChannel, WebSocketFrameType.CLOSE, payloadSize, rsv, true, pooled, frameLength, new UTF8Checker());
        this.masker = null;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        switch (this.validateStatus()) {
            case DONE: {
                if (this.status.hasRemaining()) {
                    int copied = 0;
                    while (dst.hasRemaining() && this.status.hasRemaining()) {
                        dst.put(this.status.get());
                        ++copied;
                    }
                    return copied;
                }
                return super.read(dst);
            }
            case EOF: {
                return -1;
            }
        }
        return 0;
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        switch (this.validateStatus()) {
            case DONE: {
                if (this.status.hasRemaining()) {
                    int copied = 0;
                    for (int i = offset; i < length; ++i) {
                        ByteBuffer dst = dsts[i];
                        while (dst.hasRemaining() && this.status.hasRemaining()) {
                            dst.put(this.status.get());
                            ++copied;
                        }
                        if (!dst.hasRemaining()) continue;
                        return (long)copied + super.read(dsts, offset, length);
                    }
                    return copied;
                }
                return super.read(dsts, offset, length);
            }
            case EOF: {
                return -1L;
            }
        }
        return 0L;
    }

    private State validateStatus() throws IOException {
        int r;
        if (this.statusValidated) {
            return State.DONE;
        }
        do {
            if ((r = super.read(this.status)) == -1) {
                return State.EOF;
            }
            if (this.status.hasRemaining()) continue;
            this.statusValidated = true;
            this.status.flip();
            short statusCode = this.status.getShort(0);
            if (statusCode >= 0 && statusCode <= 999 || statusCode >= 1004 && statusCode <= 1006 || statusCode >= 1012 && statusCode <= 2999) {
                WebSocketInvalidCloseCodeException exception = WebSocketMessages.MESSAGES.invalidCloseFrameStatusCode(statusCode);
                ((WebSocket07Channel)this.getFramedChannel()).markReadsBroken(exception);
                throw exception;
            }
            return State.DONE;
        } while (r != 0);
        return State.VALIDATE;
    }

    @Override
    protected void afterRead(ByteBuffer buffer, int position, int length) throws IOException {
        if (!this.statusValidated) {
            if (this.masker != null) {
                this.masker.afterRead(buffer, position, length);
            }
            return;
        }
        super.afterRead(buffer, position, length);
    }

    static enum State {
        EOF,
        DONE,
        VALIDATE;

    }
}

