/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.proxy.mod_cluster;

import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import io.undertow.client.UndertowClient;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.proxy.mod_cluster.MCMPConfig;
import io.undertow.server.handlers.proxy.mod_cluster.MCMPTestClient;
import io.undertow.server.handlers.proxy.mod_cluster.ModCluster;
import io.undertow.server.handlers.proxy.mod_cluster.NodeTestConfig;
import io.undertow.server.session.InMemorySessionManager;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionAttachmentHandler;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionCookieConfig;
import io.undertow.server.session.SessionManager;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.message.BasicHeader;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.XnioWorker;
import org.xnio.ssl.JsseXnioSsl;
import org.xnio.ssl.XnioSsl;

@RunWith(value=DefaultServer.class)
public abstract class AbstractModClusterTestBase {
    protected static final MCMPTestClient.App NAME = new MCMPTestClient.App("/name", "localhost");
    protected static final MCMPTestClient.App SESSION = new MCMPTestClient.App("/session", "localhost");
    protected static Undertow[] servers;
    protected static DefaultHttpClient httpClient;
    protected static MCMPTestClient modClusterClient;
    protected static final int port;
    protected static final String hostName;
    private static ModCluster modCluster;
    private static final XnioSsl xnioSsl;
    private static final UndertowClient undertowClient;
    private static final String COUNT = "count";
    protected List<NodeTestConfig> nodes;

    static String getType() {
        if (DefaultServer.isAjp()) {
            return "ajp";
        }
        if (DefaultServer.isSpdy()) {
            return "spdy";
        }
        if (DefaultServer.isHttps()) {
            return "https";
        }
        return "http";
    }

    @BeforeClass
    public static void setupModCluster() {
        modCluster = ModCluster.builder((XnioWorker)DefaultServer.getWorker(), (UndertowClient)undertowClient, (XnioSsl)xnioSsl).build();
        int serverPort = DefaultServer.getHostPort("default");
        HttpHandler proxy = modCluster.getProxyHandler();
        HttpHandler mcmp = MCMPConfig.webBuilder().setManagementHost(DefaultServer.getHostAddress("default")).setManagementPort(serverPort).create(modCluster, (HttpHandler)ResponseCodeHandler.HANDLE_404);
        DefaultServer.setRootHandler((HttpHandler)Handlers.path((HttpHandler)proxy).addPrefixPath("manager", mcmp));
        modCluster.start();
        httpClient = new DefaultHttpClient();
        modClusterClient = new MCMPTestClient((HttpClient)httpClient, DefaultServer.getDefaultServerURL() + "/manager");
    }

    @AfterClass
    public static void stopModCluster() {
        if (servers != null) {
            AbstractModClusterTestBase.stopServers();
        }
        modCluster.stop();
        modCluster = null;
        httpClient.getConnectionManager().shutdown();
    }

    protected void registerNodes(boolean updateLoad, NodeTestConfig ... configs) throws IOException {
        if (this.nodes == null) {
            this.nodes = new ArrayList<NodeTestConfig>();
        }
        modClusterClient.info();
        for (NodeTestConfig config : configs) {
            this.nodes.add(config);
            modClusterClient.registerNode(config);
        }
        if (updateLoad) {
            this.updateLoad(configs);
        }
    }

    protected void updateLoad(NodeTestConfig ... configs) throws IOException {
        for (NodeTestConfig config : configs) {
            modClusterClient.updateLoad(config.getJvmRoute(), 100);
        }
    }

    @After
    public void unregisterNodes() {
        try {
            modClusterClient.info();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.nodes != null) {
            for (NodeTestConfig config : this.nodes) {
                try {
                    modClusterClient.removeNode(config.getJvmRoute());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        this.nodes = null;
        httpClient.getCookieStore().clear();
    }

    static void stopServers() {
        if (servers != null) {
            for (Undertow server : servers) {
                if (server == null) continue;
                try {
                    server.stop();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            servers = null;
        }
    }

    static void startServers(NodeTestConfig ... configs) {
        int l = configs.length;
        servers = new Undertow[l];
        for (int i = 0; i < l; ++i) {
            AbstractModClusterTestBase.servers[i] = AbstractModClusterTestBase.createNode(configs[i]);
            servers[i].start();
        }
    }

    static String checkGet(String context, int statusCode) throws IOException {
        return AbstractModClusterTestBase.checkGet(context, statusCode, null);
    }

    static String checkGet(String context, int statusCode, String route) throws IOException {
        HttpGet get = AbstractModClusterTestBase.get(context);
        if (route != null && AbstractModClusterTestBase.getSessionRoute() == null) {
            BasicClientCookie cookie = new BasicClientCookie("JSESSIONID", "randomSessionID." + route);
            httpClient.getCookieStore().addCookie((Cookie)cookie);
        }
        HttpResponse result = httpClient.execute((HttpUriRequest)get);
        String response = HttpClientUtils.readResponse(result);
        Assert.assertEquals((long)statusCode, (long)result.getStatusLine().getStatusCode());
        if (route != null) {
            Assert.assertEquals((Object)route, (Object)AbstractModClusterTestBase.getSessionRoute());
        }
        return response;
    }

    static HttpGet get(String context) {
        return AbstractModClusterTestBase.get(context, "localhost");
    }

    static HttpGet get(String context, String host) {
        HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + context);
        get.addHeader((Header)new BasicHeader("Host", host));
        return get;
    }

    static Undertow createNode(NodeTestConfig config) {
        String type;
        Undertow.Builder builder = Undertow.builder();
        switch (type = config.getType()) {
            case "ajp": {
                builder.addAjpListener(config.getPort().intValue(), config.getHostname());
                break;
            }
            case "http": {
                builder.addHttpListener(config.getPort().intValue(), config.getHostname());
                break;
            }
            case "spdy": {
                builder.setServerOption(UndertowOptions.ENABLE_SPDY, (Object)true);
            }
            case "https": {
                builder.addHttpsListener(config.getPort().intValue(), config.getHostname(), DefaultServer.getServerSslContext());
                break;
            }
            default: {
                throw new IllegalArgumentException(type);
            }
        }
        SessionCookieConfig sessionConfig = new SessionCookieConfig();
        if (config.getStickySessionCookie() != null) {
            sessionConfig.setCookieName(config.getStickySessionCookie());
        }
        PathHandler pathHandler = Handlers.path((HttpHandler)ResponseCodeHandler.HANDLE_200).addPrefixPath("/name", (HttpHandler)new StringSendHandler(config.getJvmRoute())).addPrefixPath("/session", (HttpHandler)new SessionAttachmentHandler((HttpHandler)new SessionTestHandler(config.getJvmRoute(), sessionConfig), (SessionManager)new InMemorySessionManager(""), (SessionConfig)sessionConfig));
        config.setupHandlers(pathHandler);
        builder.setSocketOption(Options.REUSE_ADDRESSES, (Object)true).setHandler((HttpHandler)Handlers.jvmRoute((String)"JSESSIONID", (String)config.getJvmRoute(), (HttpHandler)pathHandler));
        return builder.build();
    }

    static String getJVMRoute(String sessionId) {
        int index = sessionId.indexOf(46);
        if (index == -1) {
            return null;
        }
        String route = sessionId.substring(index + 1);
        if ((index = route.indexOf(46)) != -1) {
            route = route.substring(0, index);
        }
        return route;
    }

    static String getSessionRoute() {
        for (Cookie cookie : httpClient.getCookieStore().getCookies()) {
            if (!"JSESSIONID".equals(cookie.getName())) continue;
            return AbstractModClusterTestBase.getJVMRoute(cookie.getValue());
        }
        return null;
    }

    static NodeTestConfig[] createConfigs(int number) {
        NodeTestConfig[] configs = new NodeTestConfig[number];
        for (int i = 0; i < number; ++i) {
            configs[i] = NodeTestConfig.builder().setJvmRoute("server" + i).setType("http").setHostname("localhost").setPort(port + i + 1);
        }
        return configs;
    }

    static {
        undertowClient = UndertowClient.getInstance();
        port = DefaultServer.getHostPort("default");
        hostName = DefaultServer.getHostAddress("default");
        xnioSsl = new JsseXnioSsl(DefaultServer.getWorker().getXnio(), OptionMap.EMPTY, DefaultServer.getClientSSLContext());
    }

    protected static final class StringSendHandler
    implements HttpHandler {
        private final String serverName;

        protected StringSendHandler(String serverName) {
            this.serverName = serverName;
        }

        public void handleRequest(HttpServerExchange exchange) throws Exception {
            exchange.getResponseSender().send(this.serverName);
        }
    }

    protected static final class SessionTestHandler
    implements HttpHandler {
        private final String serverName;
        private final SessionCookieConfig sessionConfig;

        public SessionTestHandler(String serverName, SessionCookieConfig sessionConfig) {
            this.serverName = serverName;
            this.sessionConfig = sessionConfig;
        }

        public void handleRequest(HttpServerExchange exchange) throws Exception {
            SessionManager manager = (SessionManager)exchange.getAttachment(SessionManager.ATTACHMENT_KEY);
            Session session = manager.getSession(exchange, (SessionConfig)this.sessionConfig);
            if (session == null) {
                session = manager.createSession(exchange, (SessionConfig)this.sessionConfig);
                session.setAttribute(AbstractModClusterTestBase.COUNT, (Object)0);
            }
            Integer count = (Integer)session.getAttribute(AbstractModClusterTestBase.COUNT);
            session.setAttribute(AbstractModClusterTestBase.COUNT, (Object)(count + 1));
            exchange.getResponseSender().send(this.serverName + ":" + count);
        }
    }
}

