/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.core.protocol;

import io.undertow.server.HttpHandler;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpOneOnly;
import io.undertow.util.NetworkUtils;
import io.undertow.websockets.WebSocketConnectionCallback;
import io.undertow.websockets.WebSocketProtocolHandshakeHandler;
import io.undertow.websockets.core.AbstractReceiveListener;
import io.undertow.websockets.core.BufferedBinaryMessage;
import io.undertow.websockets.core.BufferedTextMessage;
import io.undertow.websockets.core.WebSocketCallback;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSockets;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import io.undertow.websockets.utils.FrameChecker;
import io.undertow.websockets.utils.WebSocketTestClient;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketVersion;
import org.jboss.netty.util.CharsetUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.xnio.ChannelListener;
import org.xnio.FutureResult;
import org.xnio.Pooled;

@RunWith(value=DefaultServer.class)
@HttpOneOnly
public class AbstractWebSocketServerTest {
    @Test
    public void testText() throws Exception {
        if (this.getVersion() == WebSocketVersion.V00) {
            return;
        }
        final AtomicBoolean connected = new AtomicBoolean(false);
        DefaultServer.setRootHandler((HttpHandler)new WebSocketProtocolHandshakeHandler(new WebSocketConnectionCallback(){

            public void onConnect(WebSocketHttpExchange exchange, WebSocketChannel channel) {
                connected.set(true);
                channel.getReceiveSetter().set((ChannelListener)new AbstractReceiveListener(){

                    protected void onFullTextMessage(WebSocketChannel channel, BufferedTextMessage message) throws IOException {
                        String string = message.getData();
                        if (string.equals("hello")) {
                            WebSockets.sendText((String)"world", (WebSocketChannel)channel, null);
                        } else {
                            WebSockets.sendText((String)string, (WebSocketChannel)channel, null);
                        }
                    }
                });
                channel.resumeReceives();
            }
        }));
        FutureResult latch = new FutureResult();
        WebSocketTestClient client = new WebSocketTestClient(this.getVersion(), new URI("ws://" + NetworkUtils.formatPossibleIpv6Address((String)DefaultServer.getHostAddress("default")) + ":" + DefaultServer.getHostPort("default") + "/"));
        client.connect();
        client.send((WebSocketFrame)new TextWebSocketFrame(ChannelBuffers.copiedBuffer((CharSequence)"hello", (Charset)CharsetUtil.US_ASCII)), new FrameChecker(TextWebSocketFrame.class, "world".getBytes(CharsetUtil.US_ASCII), latch));
        latch.getIoFuture().get();
        client.destroy();
    }

    @Test
    public void testBinary() throws Exception {
        if (this.getVersion() == WebSocketVersion.V00) {
            return;
        }
        final AtomicBoolean connected = new AtomicBoolean(false);
        DefaultServer.setRootHandler((HttpHandler)new WebSocketProtocolHandshakeHandler(new WebSocketConnectionCallback(){

            public void onConnect(WebSocketHttpExchange exchange, WebSocketChannel channel) {
                connected.set(true);
                channel.getReceiveSetter().set((ChannelListener)new AbstractReceiveListener(){

                    protected void onFullBinaryMessage(WebSocketChannel channel, BufferedBinaryMessage message) throws IOException {
                        final Pooled data = message.getData();
                        WebSockets.sendBinary((ByteBuffer[])((ByteBuffer[])data.getResource()), (WebSocketChannel)channel, (WebSocketCallback)new WebSocketCallback<Void>(){

                            public void complete(WebSocketChannel channel, Void context) {
                                data.free();
                            }

                            public void onError(WebSocketChannel channel, Void context, Throwable throwable) {
                                data.free();
                            }
                        });
                    }
                });
                channel.resumeReceives();
            }
        }));
        FutureResult latch = new FutureResult();
        byte[] payload = "payload".getBytes();
        WebSocketTestClient client = new WebSocketTestClient(this.getVersion(), new URI("ws://" + NetworkUtils.formatPossibleIpv6Address((String)DefaultServer.getHostAddress("default")) + ":" + DefaultServer.getHostPort("default") + "/"));
        client.connect();
        client.send((WebSocketFrame)new BinaryWebSocketFrame(ChannelBuffers.wrappedBuffer((byte[])payload)), new FrameChecker(BinaryWebSocketFrame.class, payload, latch));
        latch.getIoFuture().get();
        client.destroy();
    }

    @Test
    public void testCloseFrame() throws Exception {
        if (this.getVersion() == WebSocketVersion.V00) {
            return;
        }
        final AtomicBoolean connected = new AtomicBoolean(false);
        DefaultServer.setRootHandler((HttpHandler)new WebSocketProtocolHandshakeHandler(new WebSocketConnectionCallback(){

            public void onConnect(WebSocketHttpExchange exchange, WebSocketChannel channel) {
                connected.set(true);
                channel.getReceiveSetter().set((ChannelListener)new AbstractReceiveListener(){

                    protected void onFullCloseMessage(WebSocketChannel channel, BufferedBinaryMessage message) throws IOException {
                        message.getData().free();
                        channel.sendClose();
                    }
                });
                channel.resumeReceives();
            }
        }));
        AtomicBoolean receivedResponse = new AtomicBoolean(false);
        FutureResult latch = new FutureResult();
        WebSocketTestClient client = new WebSocketTestClient(this.getVersion(), new URI("ws://" + NetworkUtils.formatPossibleIpv6Address((String)DefaultServer.getHostAddress("default")) + ":" + DefaultServer.getHostPort("default") + "/"));
        client.connect();
        client.send((WebSocketFrame)new CloseWebSocketFrame(), new FrameChecker(CloseWebSocketFrame.class, new byte[0], latch));
        latch.getIoFuture().get();
        Assert.assertFalse((boolean)receivedResponse.get());
        client.destroy();
    }

    protected WebSocketVersion getVersion() {
        return WebSocketVersion.V00;
    }
}

