/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.http2;

import io.undertow.protocols.http2.Hpack;
import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HpackEncoder
extends Hpack {
    private static final byte LOWER_DIFF = 32;
    public static final IndexFunction DEFAULT_INDEX_FUNCTION = new IndexFunction(){

        @Override
        public boolean shouldUseIndexing(HttpString headerName, String value) {
            return !headerName.equals(Headers.CONTENT_LENGTH);
        }
    };
    private long headersIterator = -1L;
    private boolean firstPass = true;
    private HeaderMap currentHeaders;
    private int entryPositionCounter;
    private int newMaxHeaderSize = -1;
    private int minNewMaxHeeaderSize = -1;
    private static final Map<HttpString, TableEntry[]> ENCODING_STATIC_TABLE;
    private final Deque<TableEntry> evictionQueue = new ArrayDeque<TableEntry>();
    private final Map<HttpString, List<TableEntry>> dynamicTable = new HashMap<HttpString, List<TableEntry>>();
    private int maxTableSize;
    private int currentTableSize;
    private final IndexFunction indexFunction = DEFAULT_INDEX_FUNCTION;

    public HpackEncoder(int maxTableSize) {
        this.maxTableSize = maxTableSize;
    }

    public State encode(HeaderMap headers, ByteBuffer target) {
        if (target.remaining() < 20) {
            return State.UNDERFLOW;
        }
        long it = this.headersIterator;
        if (this.headersIterator == -1L) {
            this.handleTableSizeChange(target);
            it = headers.fastIterate();
            this.currentHeaders = headers;
        } else if (headers != this.currentHeaders) {
            throw new IllegalStateException();
        }
        while (it != -1L) {
            HeaderValues values = headers.fiCurrent(it);
            boolean skip = false;
            if (this.firstPass) {
                if (values.getHeaderName().byteAt(0) != 58) {
                    skip = true;
                }
            } else if (values.getHeaderName().byteAt(0) == 58) {
                skip = true;
            }
            if (!skip) {
                for (int i = 0; i < values.size(); ++i) {
                    int j;
                    boolean canIndex;
                    HttpString headerName = values.getHeaderName();
                    int required = 11 + headerName.length();
                    String val = values.get(i);
                    TableEntry tableEntry = this.findInTable(headerName, val);
                    if (target.remaining() < (required += 1 + val.length())) {
                        this.headersIterator = it;
                        return State.UNDERFLOW;
                    }
                    boolean bl = canIndex = this.indexFunction.shouldUseIndexing(headerName, val) && headerName.length() + val.length() + 32 < this.maxTableSize;
                    if (tableEntry == null && canIndex) {
                        target.put((byte)64);
                        target.put((byte)0);
                        HpackEncoder.encodeInteger(target, headerName.length(), 7);
                        for (j = 0; j < headerName.length(); ++j) {
                            target.put(this.toLower(headerName.byteAt(j)));
                        }
                        target.put((byte)0);
                        HpackEncoder.encodeInteger(target, val.length(), 7);
                        for (j = 0; j < val.length(); ++j) {
                            target.put((byte)val.charAt(j));
                        }
                        this.addToDynamicTable(headerName, val);
                        continue;
                    }
                    if (tableEntry == null) {
                        target.put((byte)16);
                        target.put((byte)0);
                        HpackEncoder.encodeInteger(target, headerName.length(), 7);
                        for (j = 0; j < headerName.length(); ++j) {
                            target.put(this.toLower(headerName.byteAt(j)));
                        }
                        target.put((byte)0);
                        HpackEncoder.encodeInteger(target, val.length(), 7);
                        for (j = 0; j < val.length(); ++j) {
                            target.put((byte)val.charAt(j));
                        }
                        continue;
                    }
                    if (val.equals(tableEntry.value)) {
                        target.put((byte)-128);
                        HpackEncoder.encodeInteger(target, tableEntry.getPosition(), 7);
                        continue;
                    }
                    if (canIndex) {
                        target.put((byte)64);
                        HpackEncoder.encodeInteger(target, tableEntry.getPosition(), 6);
                        target.put((byte)0);
                        HpackEncoder.encodeInteger(target, val.length(), 7);
                        for (j = 0; j < val.length(); ++j) {
                            target.put((byte)val.charAt(j));
                        }
                        this.addToDynamicTable(headerName, val);
                        continue;
                    }
                    target.put((byte)16);
                    HpackEncoder.encodeInteger(target, tableEntry.getPosition(), 4);
                    target.put((byte)0);
                    HpackEncoder.encodeInteger(target, val.length(), 7);
                    for (j = 0; j < val.length(); ++j) {
                        target.put((byte)val.charAt(j));
                    }
                }
            }
            if ((it = headers.fiNext(it)) != -1L || !this.firstPass) continue;
            this.firstPass = false;
            it = headers.fastIterate();
        }
        this.headersIterator = -1L;
        this.firstPass = true;
        return State.COMPLETE;
    }

    private byte toLower(byte b) {
        if (b >= 65 && b <= 90) {
            return (byte)(b + 32);
        }
        return b;
    }

    private void addToDynamicTable(HttpString headerName, String val) {
        int pos = this.entryPositionCounter++;
        DynamicTableEntry d = new DynamicTableEntry(headerName, val, -pos);
        List<TableEntry> existing = this.dynamicTable.get(headerName);
        if (existing == null) {
            existing = new ArrayList<TableEntry>(1);
            this.dynamicTable.put(headerName, existing);
        }
        existing.add(d);
        this.evictionQueue.add(d);
        this.currentTableSize += d.size;
        this.runEvictionIfRequired();
        if (this.entryPositionCounter == Integer.MAX_VALUE) {
            this.preventPositionRollover();
        }
    }

    private void preventPositionRollover() {
        for (Map.Entry<HttpString, List<TableEntry>> entry : this.dynamicTable.entrySet()) {
            for (TableEntry t : entry.getValue()) {
                t.position = t.getPosition();
            }
        }
        this.entryPositionCounter = 0;
    }

    private void runEvictionIfRequired() {
        while (this.currentTableSize > this.maxTableSize) {
            TableEntry next = this.evictionQueue.poll();
            if (next == null) {
                return;
            }
            this.currentTableSize -= next.size;
            List<TableEntry> list = this.dynamicTable.get(next.name);
            list.remove(next);
            if (!list.isEmpty()) continue;
            this.dynamicTable.remove(next.name);
        }
    }

    private TableEntry findInTable(HttpString headerName, String value) {
        List<TableEntry> dynamic;
        TableEntry[] staticTable = ENCODING_STATIC_TABLE.get(headerName);
        if (staticTable != null) {
            for (TableEntry st : staticTable) {
                if (st.value == null || !st.value.equals(value)) continue;
                return st;
            }
        }
        if ((dynamic = this.dynamicTable.get(headerName)) != null) {
            for (TableEntry st : dynamic) {
                if (!st.value.equals(value)) continue;
                return st;
            }
        }
        if (staticTable != null) {
            return staticTable[0];
        }
        return null;
    }

    static int pushBits(ByteBuffer buffer, int value, int n, int currentBitPos) {
        int forThisByte;
        int bitsLeft = n;
        if (currentBitPos != 0) {
            int rem = 8 - currentBitPos;
            int forThisByte2 = n > rem ? rem : n;
            int toPush = value >> n - forThisByte2;
            int shift = 8 - (currentBitPos + forThisByte2);
            int pos = buffer.position() - 1;
            buffer.put(pos, (byte)(buffer.get(pos) | toPush << shift));
            if ((bitsLeft -= forThisByte2) == 0) {
                int newPos = currentBitPos + n;
                return newPos == 8 ? 0 : newPos;
            }
        }
        do {
            forThisByte = bitsLeft > 8 ? 8 : bitsLeft;
            int toPush = value >> bitsLeft - forThisByte;
            int shift = 8 - forThisByte;
            buffer.put((byte)(toPush << shift));
        } while ((bitsLeft -= forThisByte) != 0);
        return forThisByte;
    }

    public void setMaxTableSize(int newSize) {
        this.newMaxHeaderSize = newSize;
        this.minNewMaxHeeaderSize = this.minNewMaxHeeaderSize == -1 ? newSize : Math.min(newSize, this.minNewMaxHeeaderSize);
    }

    private void handleTableSizeChange(ByteBuffer target) {
        if (this.newMaxHeaderSize == -1) {
            return;
        }
        if (this.minNewMaxHeeaderSize != this.newMaxHeaderSize) {
            target.put((byte)32);
            HpackEncoder.encodeInteger(target, this.minNewMaxHeeaderSize, 5);
        }
        target.put((byte)32);
        HpackEncoder.encodeInteger(target, this.newMaxHeaderSize, 5);
        this.maxTableSize = this.newMaxHeaderSize;
        this.runEvictionIfRequired();
        this.newMaxHeaderSize = -1;
        this.minNewMaxHeeaderSize = -1;
    }

    static {
        HashMap<HttpString, TableEntry[]> map = new HashMap<HttpString, TableEntry[]>();
        for (int i = 1; i < STATIC_TABLE.length; ++i) {
            Hpack.HeaderField m = STATIC_TABLE[i];
            TableEntry[] existing = (TableEntry[])map.get(m.name);
            if (existing == null) {
                map.put(m.name, new TableEntry[]{new TableEntry(m.name, m.value, i)});
                continue;
            }
            TableEntry[] newEntry = new TableEntry[existing.length + 1];
            System.arraycopy(existing, 0, newEntry, 0, existing.length);
            newEntry[existing.length] = new TableEntry(m.name, m.value, i);
            map.put(m.name, newEntry);
        }
        ENCODING_STATIC_TABLE = Collections.unmodifiableMap(map);
    }

    public static interface IndexFunction {
        public boolean shouldUseIndexing(HttpString var1, String var2);
    }

    class DynamicTableEntry
    extends TableEntry {
        DynamicTableEntry(HttpString name, String value, int position) {
            super(name, value, position);
        }

        @Override
        public int getPosition() {
            return super.getPosition() + HpackEncoder.this.entryPositionCounter + Hpack.STATIC_TABLE_LENGTH;
        }
    }

    static class TableEntry {
        final HttpString name;
        final String value;
        final int size;
        int position;

        TableEntry(HttpString name, String value, int position) {
            this.name = name;
            this.value = value;
            this.position = position;
            this.size = value != null ? 32 + name.length() + value.length() : -1;
        }

        public int getPosition() {
            return this.position;
        }
    }

    public static enum State {
        COMPLETE,
        UNDERFLOW;

    }
}

