/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.security.impl;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.AuthenticationMechanismFactory;
import io.undertow.security.api.NonceManager;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import io.undertow.security.idm.DigestAlgorithm;
import io.undertow.security.idm.DigestCredential;
import io.undertow.security.idm.IdentityManager;
import io.undertow.security.impl.DigestAuthorizationToken;
import io.undertow.security.impl.DigestQop;
import io.undertow.security.impl.SimpleNonceManager;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.form.FormParserFactory;
import io.undertow.util.AttachmentKey;
import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.HexConverter;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DigestAuthenticationMechanism
implements AuthenticationMechanism {
    private static final String DEFAULT_NAME = "DIGEST";
    private final String mechanismName;
    private static final String DIGEST_PREFIX = Headers.DIGEST + " ";
    private static final int PREFIX_LENGTH = DIGEST_PREFIX.length();
    private static final String OPAQUE_VALUE = "00000000000000000000000000000000";
    private static final byte COLON = 58;
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    public static final Factory FACTORY = new Factory();
    private static final Set<DigestAuthorizationToken> MANDATORY_REQUEST_TOKENS;
    private final List<DigestAlgorithm> supportedAlgorithms;
    private final List<DigestQop> supportedQops;
    private final String qopString;
    private final String realmName;
    private final String domain;
    private final NonceManager nonceManager;

    public DigestAuthenticationMechanism(List<DigestAlgorithm> supportedAlgorithms, List<DigestQop> supportedQops, String realmName, String domain, NonceManager nonceManager) {
        this(supportedAlgorithms, supportedQops, realmName, domain, nonceManager, DEFAULT_NAME);
    }

    public DigestAuthenticationMechanism(List<DigestAlgorithm> supportedAlgorithms, List<DigestQop> supportedQops, String realmName, String domain, NonceManager nonceManager, String mechanismName) {
        this.supportedAlgorithms = supportedAlgorithms;
        this.supportedQops = supportedQops;
        this.realmName = realmName;
        this.domain = domain;
        this.nonceManager = nonceManager;
        this.mechanismName = mechanismName;
        if (!supportedQops.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            Iterator<DigestQop> it = supportedQops.iterator();
            sb.append(it.next().getToken());
            while (it.hasNext()) {
                sb.append(",").append(it.next().getToken());
            }
            this.qopString = sb.toString();
        } else {
            this.qopString = null;
        }
    }

    public DigestAuthenticationMechanism(String realmName, String domain, String mechanismName) {
        this(Collections.singletonList(DigestAlgorithm.MD5), new ArrayList<DigestQop>(0), realmName, domain, new SimpleNonceManager());
    }

    @Override
    public AuthenticationMechanism.AuthenticationMechanismOutcome authenticate(HttpServerExchange exchange, SecurityContext securityContext) {
        Iterator iterator;
        HeaderValues authHeaders = exchange.getRequestHeaders().get(Headers.AUTHORIZATION);
        if (authHeaders != null && (iterator = authHeaders.iterator()).hasNext()) {
            String current = (String)iterator.next();
            if (current.startsWith(DIGEST_PREFIX)) {
                String digestChallenge = current.substring(PREFIX_LENGTH);
                try {
                    DigestContext context = new DigestContext();
                    Map<DigestAuthorizationToken, String> parsedHeader = DigestAuthorizationToken.parseHeader(digestChallenge);
                    context.setMethod(exchange.getRequestMethod().toString());
                    context.setParsedHeader(parsedHeader);
                    exchange.putAttachment(DigestContext.ATTACHMENT_KEY, context);
                    return this.handleDigestHeader(exchange, securityContext);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
        }
        return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED;
    }

    public AuthenticationMechanism.AuthenticationMechanismOutcome handleDigestHeader(HttpServerExchange exchange, SecurityContext securityContext) {
        DigestAlgorithm algorithm;
        DigestContext context = exchange.getAttachment(DigestContext.ATTACHMENT_KEY);
        Map<DigestAuthorizationToken, String> parsedHeader = context.getParsedHeader();
        HashSet<DigestAuthorizationToken> mandatoryTokens = new HashSet<DigestAuthorizationToken>(MANDATORY_REQUEST_TOKENS);
        if (!this.supportedAlgorithms.contains((Object)DigestAlgorithm.MD5)) {
            mandatoryTokens.add(DigestAuthorizationToken.ALGORITHM);
        }
        if (!this.supportedQops.isEmpty() && !this.supportedQops.contains((Object)DigestQop.AUTH)) {
            mandatoryTokens.add(DigestAuthorizationToken.MESSAGE_QOP);
        }
        DigestQop qop = null;
        if (parsedHeader.containsKey(DigestAuthorizationToken.MESSAGE_QOP)) {
            qop = DigestQop.forName(parsedHeader.get(DigestAuthorizationToken.MESSAGE_QOP));
            if (qop == null || !this.supportedQops.contains((Object)qop)) {
                UndertowLogger.REQUEST_LOGGER.invalidTokenReceived(DigestAuthorizationToken.MESSAGE_QOP.getName(), parsedHeader.get(DigestAuthorizationToken.MESSAGE_QOP));
                return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
            }
            context.setQop(qop);
            mandatoryTokens.add(DigestAuthorizationToken.CNONCE);
            mandatoryTokens.add(DigestAuthorizationToken.NONCE_COUNT);
        }
        mandatoryTokens.removeAll(parsedHeader.keySet());
        if (mandatoryTokens.size() > 0) {
            for (DigestAuthorizationToken currentToken : mandatoryTokens) {
                UndertowLogger.REQUEST_LOGGER.missingAuthorizationToken(currentToken.getName());
            }
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
        }
        if (!this.realmName.equals(parsedHeader.get(DigestAuthorizationToken.REALM))) {
            UndertowLogger.REQUEST_LOGGER.invalidTokenReceived(DigestAuthorizationToken.REALM.getName(), parsedHeader.get(DigestAuthorizationToken.REALM));
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
        }
        if (parsedHeader.containsKey(DigestAuthorizationToken.OPAQUE) && !OPAQUE_VALUE.equals(parsedHeader.get(DigestAuthorizationToken.OPAQUE))) {
            UndertowLogger.REQUEST_LOGGER.invalidTokenReceived(DigestAuthorizationToken.OPAQUE.getName(), parsedHeader.get(DigestAuthorizationToken.OPAQUE));
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
        }
        if (parsedHeader.containsKey(DigestAuthorizationToken.ALGORITHM)) {
            algorithm = DigestAlgorithm.forName(parsedHeader.get(DigestAuthorizationToken.ALGORITHM));
            if (algorithm == null || !this.supportedAlgorithms.contains((Object)algorithm)) {
                UndertowLogger.REQUEST_LOGGER.invalidTokenReceived(DigestAuthorizationToken.ALGORITHM.getName(), parsedHeader.get(DigestAuthorizationToken.ALGORITHM));
                return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
            }
        } else {
            algorithm = DigestAlgorithm.MD5;
        }
        try {
            context.setAlgorithm(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            UndertowLogger.REQUEST_LOGGER.exceptionProcessingRequest(e);
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
        }
        String userName = parsedHeader.get(DigestAuthorizationToken.USERNAME);
        IdentityManager identityManager = securityContext.getIdentityManager();
        if (algorithm.isSession()) {
            throw new IllegalStateException("Not yet implemented.");
        }
        DigestCredentialImpl credential = new DigestCredentialImpl(context);
        Account account = identityManager.verify(userName, credential);
        if (account == null) {
            securityContext.authenticationFailed(UndertowMessages.MESSAGES.authenticationFailed(userName), this.mechanismName);
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
        }
        if (!this.validateNonceUse(context, parsedHeader, exchange)) {
            context.markStale();
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
        }
        this.sendAuthenticationInfoHeader(exchange);
        securityContext.authenticationComplete(account, this.mechanismName, false);
        return AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED;
    }

    private boolean validateRequest(DigestContext context, byte[] ha1) {
        DigestQop qop = context.getQop();
        byte[] ha2 = qop == null || qop.equals((Object)DigestQop.AUTH) ? this.createHA2Auth(context, context.getParsedHeader()) : this.createHA2AuthInt();
        byte[] requestDigest = qop == null ? this.createRFC2069RequestDigest(ha1, ha2, context) : this.createRFC2617RequestDigest(ha1, ha2, context);
        byte[] providedResponse = context.getParsedHeader().get(DigestAuthorizationToken.RESPONSE).getBytes(UTF_8);
        return MessageDigest.isEqual(requestDigest, providedResponse);
    }

    private boolean validateNonceUse(DigestContext context, Map<DigestAuthorizationToken, String> parsedHeader, HttpServerExchange exchange) {
        String suppliedNonce = parsedHeader.get(DigestAuthorizationToken.NONCE);
        int nonceCount = -1;
        if (parsedHeader.containsKey(DigestAuthorizationToken.NONCE_COUNT)) {
            String nonceCountHex = parsedHeader.get(DigestAuthorizationToken.NONCE_COUNT);
            nonceCount = Integer.parseInt(nonceCountHex, 16);
        }
        context.setNonce(suppliedNonce);
        return this.nonceManager.validateNonce(suppliedNonce, nonceCount, exchange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] createHA2Auth(DigestContext context, Map<DigestAuthorizationToken, String> parsedHeader) {
        byte[] method = context.getMethod().getBytes(UTF_8);
        byte[] digestUri = parsedHeader.get(DigestAuthorizationToken.DIGEST_URI).getBytes(UTF_8);
        MessageDigest digest = context.getDigest();
        try {
            digest.update(method);
            digest.update((byte)58);
            digest.update(digestUri);
            byte[] byArray = HexConverter.convertToHexBytes(digest.digest());
            return byArray;
        }
        finally {
            digest.reset();
        }
    }

    private byte[] createHA2AuthInt() {
        throw new IllegalStateException("Method not implemented.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] createRFC2069RequestDigest(byte[] ha1, byte[] ha2, DigestContext context) {
        MessageDigest digest = context.getDigest();
        Map<DigestAuthorizationToken, String> parsedHeader = context.getParsedHeader();
        byte[] nonce = parsedHeader.get(DigestAuthorizationToken.NONCE).getBytes(UTF_8);
        try {
            digest.update(ha1);
            digest.update((byte)58);
            digest.update(nonce);
            digest.update((byte)58);
            digest.update(ha2);
            byte[] byArray = HexConverter.convertToHexBytes(digest.digest());
            return byArray;
        }
        finally {
            digest.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] createRFC2617RequestDigest(byte[] ha1, byte[] ha2, DigestContext context) {
        MessageDigest digest = context.getDigest();
        Map<DigestAuthorizationToken, String> parsedHeader = context.getParsedHeader();
        byte[] nonce = parsedHeader.get(DigestAuthorizationToken.NONCE).getBytes(UTF_8);
        byte[] nonceCount = parsedHeader.get(DigestAuthorizationToken.NONCE_COUNT).getBytes(UTF_8);
        byte[] cnonce = parsedHeader.get(DigestAuthorizationToken.CNONCE).getBytes(UTF_8);
        byte[] qop = parsedHeader.get(DigestAuthorizationToken.MESSAGE_QOP).getBytes(UTF_8);
        try {
            digest.update(ha1);
            digest.update((byte)58);
            digest.update(nonce);
            digest.update((byte)58);
            digest.update(nonceCount);
            digest.update((byte)58);
            digest.update(cnonce);
            digest.update((byte)58);
            digest.update(qop);
            digest.update((byte)58);
            digest.update(ha2);
            byte[] byArray = HexConverter.convertToHexBytes(digest.digest());
            return byArray;
        }
        finally {
            digest.reset();
        }
    }

    @Override
    public AuthenticationMechanism.ChallengeResult sendChallenge(HttpServerExchange exchange, SecurityContext securityContext) {
        DigestContext context = exchange.getAttachment(DigestContext.ATTACHMENT_KEY);
        boolean stale = context == null ? false : context.isStale();
        StringBuilder rb = new StringBuilder(DIGEST_PREFIX);
        rb.append(Headers.REALM.toString()).append("=\"").append(this.realmName).append("\",");
        rb.append(Headers.DOMAIN.toString()).append("=\"").append(this.domain).append("\",");
        rb.append(Headers.NONCE.toString()).append("=\"").append(this.nonceManager.nextNonce(null, exchange)).append("\",");
        rb.append(Headers.OPAQUE.toString()).append("=\"00000000000000000000000000000000\"");
        if (stale) {
            rb.append(",stale=true");
        }
        if (this.supportedAlgorithms.size() > 0) {
            rb.append(",").append(Headers.ALGORITHM.toString()).append("=%s");
        }
        if (this.qopString != null) {
            rb.append(",").append(Headers.QOP.toString()).append("=\"").append(this.qopString).append("\"");
        }
        String theChallenge = rb.toString();
        HeaderMap responseHeader = exchange.getResponseHeaders();
        if (this.supportedAlgorithms.isEmpty()) {
            responseHeader.add(Headers.WWW_AUTHENTICATE, theChallenge);
        } else {
            for (DigestAlgorithm current : this.supportedAlgorithms) {
                responseHeader.add(Headers.WWW_AUTHENTICATE, String.format(theChallenge, current.getToken()));
            }
        }
        return new AuthenticationMechanism.ChallengeResult(true, 401);
    }

    public void sendAuthenticationInfoHeader(HttpServerExchange exchange) {
        DigestContext context = exchange.getAttachment(DigestContext.ATTACHMENT_KEY);
        DigestQop qop = context.getQop();
        String currentNonce = context.getNonce();
        String nextNonce = this.nonceManager.nextNonce(currentNonce, exchange);
        if (qop != null || !nextNonce.equals(currentNonce)) {
            StringBuilder sb = new StringBuilder();
            sb.append(Headers.NEXT_NONCE).append("=\"").append(nextNonce).append("\"");
            if (qop != null) {
                Map<DigestAuthorizationToken, String> parsedHeader = context.getParsedHeader();
                sb.append(",").append(Headers.QOP.toString()).append("=\"").append(qop.getToken()).append("\"");
                byte[] ha1 = context.getHa1();
                byte[] ha2 = qop == DigestQop.AUTH ? this.createHA2Auth(context) : this.createHA2AuthInt();
                String rspauth = new String(this.createRFC2617RequestDigest(ha1, ha2, context), UTF_8);
                sb.append(",").append(Headers.RESPONSE_AUTH.toString()).append("=\"").append(rspauth).append("\"");
                sb.append(",").append(Headers.CNONCE.toString()).append("=\"").append(parsedHeader.get(DigestAuthorizationToken.CNONCE)).append("\"");
                sb.append(",").append(Headers.NONCE_COUNT.toString()).append("=").append(parsedHeader.get(DigestAuthorizationToken.NONCE_COUNT));
            }
            HeaderMap responseHeader = exchange.getResponseHeaders();
            responseHeader.add(Headers.AUTHENTICATION_INFO, sb.toString());
        }
        exchange.removeAttachment(DigestContext.ATTACHMENT_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] createHA2Auth(DigestContext context) {
        byte[] digestUri = context.getParsedHeader().get(DigestAuthorizationToken.DIGEST_URI).getBytes(UTF_8);
        MessageDigest digest = context.getDigest();
        try {
            digest.update((byte)58);
            digest.update(digestUri);
            byte[] byArray = HexConverter.convertToHexBytes(digest.digest());
            return byArray;
        }
        finally {
            digest.reset();
        }
    }

    static {
        HashSet<DigestAuthorizationToken> mandatoryTokens = new HashSet<DigestAuthorizationToken>();
        mandatoryTokens.add(DigestAuthorizationToken.USERNAME);
        mandatoryTokens.add(DigestAuthorizationToken.REALM);
        mandatoryTokens.add(DigestAuthorizationToken.NONCE);
        mandatoryTokens.add(DigestAuthorizationToken.DIGEST_URI);
        mandatoryTokens.add(DigestAuthorizationToken.RESPONSE);
        MANDATORY_REQUEST_TOKENS = Collections.unmodifiableSet(mandatoryTokens);
    }

    private static final class Factory
    implements AuthenticationMechanismFactory {
        private Factory() {
        }

        @Override
        public AuthenticationMechanism create(String mechanismName, FormParserFactory formParserFactory, Map<String, String> properties) {
            return new DigestAuthenticationMechanism(properties.get("realm"), properties.get("context_path"), mechanismName);
        }
    }

    private class AuthenticationException
    extends Exception {
        private static final long serialVersionUID = 4123187263595319747L;

        public AuthenticationException() {
        }

        public AuthenticationException(String message, Throwable cause) {
            super(message, cause);
        }

        public AuthenticationException(String message) {
            super(message);
        }

        public AuthenticationException(Throwable cause) {
            super(cause);
        }
    }

    private class DigestCredentialImpl
    implements DigestCredential {
        private final DigestContext context;

        private DigestCredentialImpl(DigestContext digestContext) {
            this.context = digestContext;
        }

        @Override
        public DigestAlgorithm getAlgorithm() {
            return this.context.getAlgorithm();
        }

        @Override
        public boolean verifyHA1(byte[] ha1) {
            this.context.setHa1(ha1);
            return DigestAuthenticationMechanism.this.validateRequest(this.context, ha1);
        }

        @Override
        public String getRealm() {
            return DigestAuthenticationMechanism.this.realmName;
        }

        @Override
        public byte[] getSessionData() {
            if (!this.context.getAlgorithm().isSession()) {
                throw UndertowMessages.MESSAGES.noSessionData();
            }
            byte[] nonce = this.context.getParsedHeader().get(DigestAuthorizationToken.NONCE).getBytes(UTF_8);
            byte[] cnonce = this.context.getParsedHeader().get(DigestAuthorizationToken.CNONCE).getBytes(UTF_8);
            byte[] response = new byte[nonce.length + cnonce.length + 1];
            System.arraycopy(nonce, 0, response, 0, nonce.length);
            response[nonce.length] = 58;
            System.arraycopy(cnonce, 0, response, nonce.length + 1, cnonce.length);
            return response;
        }
    }

    private static class DigestContext {
        static final AttachmentKey<DigestContext> ATTACHMENT_KEY = AttachmentKey.create(DigestContext.class);
        private String method;
        private String nonce;
        private DigestQop qop;
        private byte[] ha1;
        private DigestAlgorithm algorithm;
        private MessageDigest digest;
        private boolean stale = false;
        Map<DigestAuthorizationToken, String> parsedHeader;

        private DigestContext() {
        }

        String getMethod() {
            return this.method;
        }

        void setMethod(String method) {
            this.method = method;
        }

        boolean isStale() {
            return this.stale;
        }

        void markStale() {
            this.stale = true;
        }

        String getNonce() {
            return this.nonce;
        }

        void setNonce(String nonce) {
            this.nonce = nonce;
        }

        DigestQop getQop() {
            return this.qop;
        }

        void setQop(DigestQop qop) {
            this.qop = qop;
        }

        byte[] getHa1() {
            return this.ha1;
        }

        void setHa1(byte[] ha1) {
            this.ha1 = ha1;
        }

        DigestAlgorithm getAlgorithm() {
            return this.algorithm;
        }

        void setAlgorithm(DigestAlgorithm algorithm) throws NoSuchAlgorithmException {
            this.algorithm = algorithm;
            this.digest = algorithm.getMessageDigest();
        }

        MessageDigest getDigest() {
            return this.digest;
        }

        Map<DigestAuthorizationToken, String> getParsedHeader() {
            return this.parsedHeader;
        }

        void setParsedHeader(Map<DigestAuthorizationToken, String> parsedHeader) {
            this.parsedHeader = parsedHeader;
        }
    }
}

