/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.ssl;

import io.undertow.UndertowLogger;
import io.undertow.protocols.ssl.UndertowSslConnection;
import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.xnio.Bits;
import org.xnio.Buffers;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.Pool;
import org.xnio.Pooled;
import org.xnio.StreamConnection;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.ConduitReadableByteChannel;
import org.xnio.conduits.ConduitWritableByteChannel;
import org.xnio.conduits.Conduits;
import org.xnio.conduits.ReadReadyHandler;
import org.xnio.conduits.StreamSinkConduit;
import org.xnio.conduits.StreamSourceConduit;
import org.xnio.conduits.WriteReadyHandler;

public class SslConduit
implements StreamSourceConduit,
StreamSinkConduit {
    private static final int FLAG_READ_REQUIRES_WRITE = 1;
    private static final int FLAG_WRITE_REQUIRES_READ = 2;
    private static final int FLAG_READS_RESUMED = 4;
    private static final int FLAG_WRITES_RESUMED = 8;
    private static final int FLAG_DATA_TO_UNWRAP = 16;
    private static final int FLAG_READ_SHUTDOWN = 32;
    private static final int FLAG_WRITE_SHUTDOWN = 64;
    private static final int FLAG_ENGINE_INBOUND_SHUTDOWN = 128;
    private static final int FLAG_ENGINE_OUTBOUND_SHUTDOWN = 256;
    private static final int FLAG_DELEGATE_SINK_SHUTDOWN = 512;
    private static final int FLAG_DELEGATE_SOURCE_SHUTDOWN = 1024;
    private static final int FLAG_IN_HANDSHAKE = 2048;
    private static final int FLAG_CLOSED = 4096;
    private static final int FLAG_WRITE_CLOSED = 8192;
    private static final int FLAG_READ_CLOSED = 16384;
    public static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);
    private final UndertowSslConnection connection;
    private final StreamConnection delegate;
    private final SSLEngine engine;
    private final StreamSinkConduit sink;
    private final StreamSourceConduit source;
    private final Pool<ByteBuffer> bufferPool;
    private final Runnable handshakeCallback;
    private int state = 0;
    private volatile int outstandingTasks = 0;
    private Pooled<ByteBuffer> wrappedData;
    private Pooled<ByteBuffer> dataToUnwrap;
    private Pooled<ByteBuffer> unwrappedData;
    private SslWriteReadyHandler writeReadyHandler;
    private SslReadReadyHandler readReadyHandler;

    SslConduit(UndertowSslConnection connection, StreamConnection delegate, SSLEngine engine, Pool<ByteBuffer> bufferPool, Runnable handshakeCallback) {
        this.connection = connection;
        this.delegate = delegate;
        this.handshakeCallback = handshakeCallback;
        this.sink = delegate.getSinkChannel().getConduit();
        this.source = delegate.getSourceChannel().getConduit();
        this.engine = engine;
        this.bufferPool = bufferPool;
        this.readReadyHandler = new SslReadReadyHandler(null);
        delegate.getSourceChannel().getConduit().setReadReadyHandler((ReadReadyHandler)this.readReadyHandler);
        this.writeReadyHandler = new SslWriteReadyHandler(null);
        delegate.getSinkChannel().getConduit().setWriteReadyHandler((WriteReadyHandler)this.writeReadyHandler);
        this.state = engine.getUseClientMode() ? 2049 : 2050;
    }

    public void terminateReads() throws IOException {
        this.state |= 0x20;
        this.notifyReadClosed();
    }

    public boolean isReadShutdown() {
        return Bits.anyAreSet((int)this.state, (int)32);
    }

    public void resumeReads() {
        this.resumeReads(false);
    }

    public void suspendReads() {
        this.state &= 0xFFFFFFFB;
        if (!Bits.allAreSet((int)this.state, (int)10)) {
            this.delegate.getSourceChannel().suspendReads();
        }
    }

    public void wakeupReads() {
        this.resumeReads(true);
    }

    private void resumeReads(boolean wakeup) {
        this.state |= 4;
        if (Bits.anyAreSet((int)this.state, (int)1)) {
            this.delegate.getSinkChannel().resumeWrites();
        } else {
            this.delegate.getSourceChannel().resumeReads();
            if (Bits.anyAreSet((int)this.state, (int)16) || wakeup) {
                this.runReadListener();
            }
        }
    }

    private void runReadListener() {
        try {
            this.delegate.getIoThread().execute(new Runnable(){

                @Override
                public void run() {
                    SslConduit.this.readReadyHandler.readReady();
                }
            });
        }
        catch (Exception e) {
            IoUtils.safeClose((Closeable[])new Closeable[]{this.connection, this.delegate});
            UndertowLogger.REQUEST_IO_LOGGER.debugf(e, "Failed to queue read listener invocation", new Object[0]);
        }
    }

    public boolean isReadResumed() {
        return Bits.anyAreSet((int)this.state, (int)4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitReadable() throws IOException {
        SslConduit sslConduit = this;
        synchronized (sslConduit) {
            if (this.outstandingTasks > 0) {
                try {
                    this.wait();
                    return;
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException();
                }
            }
        }
        if (this.unwrappedData != null) {
            return;
        }
        if (Bits.anyAreSet((int)this.state, (int)16)) {
            return;
        }
        if (Bits.anyAreSet((int)this.state, (int)1)) {
            this.awaitWritable();
            return;
        }
        this.source.awaitReadable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        SslConduit sslConduit = this;
        synchronized (sslConduit) {
            if (this.outstandingTasks > 0) {
                try {
                    this.wait(timeUnit.toMillis(time));
                    return;
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException();
                }
            }
        }
        if (this.unwrappedData != null) {
            return;
        }
        if (Bits.anyAreSet((int)this.state, (int)16)) {
            return;
        }
        if (Bits.anyAreSet((int)this.state, (int)1)) {
            this.awaitWritable(time, timeUnit);
            return;
        }
        this.source.awaitReadable(time, timeUnit);
    }

    public XnioIoThread getReadThread() {
        return this.delegate.getIoThread();
    }

    public void setReadReadyHandler(ReadReadyHandler handler) {
        this.readReadyHandler = new SslReadReadyHandler(handler);
        this.delegate.getSourceChannel().getConduit().setReadReadyHandler((ReadReadyHandler)this.readReadyHandler);
    }

    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)64)) {
            throw new ClosedChannelException();
        }
        return src.transferTo(position, count, (WritableByteChannel)new ConduitWritableByteChannel((StreamSinkConduit)this));
    }

    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)64)) {
            throw new ClosedChannelException();
        }
        return IoUtils.transfer((ReadableByteChannel)source, (long)count, (ByteBuffer)throughBuffer, (WritableByteChannel)new ConduitWritableByteChannel((StreamSinkConduit)this));
    }

    public int write(ByteBuffer src) throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)64)) {
            throw new ClosedChannelException();
        }
        return (int)this.doWrap(new ByteBuffer[]{src}, 0, 1);
    }

    public long write(ByteBuffer[] srcs, int offs, int len) throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)64)) {
            throw new ClosedChannelException();
        }
        return this.doWrap(srcs, offs, len);
    }

    public int writeFinal(ByteBuffer src) throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)64)) {
            throw new ClosedChannelException();
        }
        return Conduits.writeFinalBasic((StreamSinkConduit)this, (ByteBuffer)src);
    }

    public long writeFinal(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return Conduits.writeFinalBasic((StreamSinkConduit)this, (ByteBuffer[])srcs, (int)offset, (int)length);
    }

    public void terminateWrites() throws IOException {
        this.state |= 0x40;
    }

    public boolean isWriteShutdown() {
        return false;
    }

    public void resumeWrites() {
        this.state |= 8;
        if (Bits.anyAreSet((int)this.state, (int)2)) {
            this.delegate.getSourceChannel().resumeReads();
        } else {
            this.delegate.getSinkChannel().resumeWrites();
        }
    }

    public void suspendWrites() {
        this.state &= 0xFFFFFFF7;
        if (!Bits.allAreSet((int)this.state, (int)5)) {
            this.delegate.getSinkChannel().suspendWrites();
        }
    }

    public void wakeupWrites() {
        this.resumeWrites();
        this.getWriteThread().execute(new Runnable(){

            @Override
            public void run() {
                SslConduit.this.writeReadyHandler.writeReady();
            }
        });
    }

    public boolean isWriteResumed() {
        return Bits.anyAreSet((int)this.state, (int)8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitWritable() throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)64)) {
            return;
        }
        if (this.outstandingTasks > 0) {
            SslConduit sslConduit = this;
            synchronized (sslConduit) {
                if (this.outstandingTasks > 0) {
                    try {
                        this.wait();
                        return;
                    }
                    catch (InterruptedException e) {
                        throw new InterruptedIOException();
                    }
                }
            }
        }
        if (Bits.anyAreSet((int)this.state, (int)2)) {
            this.awaitReadable();
            return;
        }
        this.sink.awaitWritable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)64)) {
            return;
        }
        if (this.outstandingTasks > 0) {
            SslConduit sslConduit = this;
            synchronized (sslConduit) {
                if (this.outstandingTasks > 0) {
                    try {
                        this.wait(timeUnit.toMillis(time));
                        return;
                    }
                    catch (InterruptedException e) {
                        throw new InterruptedIOException();
                    }
                }
            }
        }
        if (Bits.anyAreSet((int)this.state, (int)2)) {
            this.awaitReadable(time, timeUnit);
            return;
        }
        this.sink.awaitWritable();
    }

    public XnioIoThread getWriteThread() {
        return this.delegate.getIoThread();
    }

    public void setWriteReadyHandler(WriteReadyHandler handler) {
        this.writeReadyHandler = new SslWriteReadyHandler(handler);
        this.delegate.getSinkChannel().getConduit().setWriteReadyHandler((WriteReadyHandler)this.writeReadyHandler);
    }

    public void truncateWrites() throws IOException {
        this.notifyWriteClosed();
    }

    public boolean flush() throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)512)) {
            return this.sink.flush();
        }
        if (this.wrappedData != null) {
            this.doWrap(null, 0, 0);
            if (this.wrappedData != null) {
                return false;
            }
        }
        if (Bits.allAreSet((int)this.state, (int)64)) {
            if (Bits.allAreClear((int)this.state, (int)256)) {
                this.state |= 0x100;
                this.engine.closeOutbound();
                this.doWrap(null, 0, 0);
                if (this.wrappedData != null) {
                    return false;
                }
            } else if (this.wrappedData != null && Bits.allAreClear((int)this.state, (int)512)) {
                this.doWrap(null, 0, 0);
                if (this.wrappedData != null) {
                    return false;
                }
            }
            if (Bits.allAreClear((int)this.state, (int)512)) {
                this.sink.terminateWrites();
                this.state |= 0x200;
            }
        }
        return this.sink.flush();
    }

    public long transferTo(long position, long count, FileChannel target) throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)32)) {
            throw new ClosedChannelException();
        }
        return target.transferFrom((ReadableByteChannel)new ConduitReadableByteChannel((StreamSourceConduit)this), position, count);
    }

    public long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)32)) {
            throw new ClosedChannelException();
        }
        return IoUtils.transfer((ReadableByteChannel)new ConduitReadableByteChannel((StreamSourceConduit)this), (long)count, (ByteBuffer)throughBuffer, (WritableByteChannel)target);
    }

    public int read(ByteBuffer dst) throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)32)) {
            throw new ClosedChannelException();
        }
        return (int)this.doUnwrap(new ByteBuffer[]{dst}, 0, 1);
    }

    public long read(ByteBuffer[] dsts, int offs, int len) throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)32)) {
            throw new ClosedChannelException();
        }
        return this.doUnwrap(dsts, offs, len);
    }

    public XnioWorker getWorker() {
        return this.delegate.getWorker();
    }

    void notifyWriteClosed() {
        if (Bits.anyAreSet((int)this.state, (int)8192)) {
            return;
        }
        this.connection.writeClosed();
        this.state |= 0x2000;
        if (Bits.anyAreSet((int)this.state, (int)16384)) {
            this.closed();
        }
    }

    void notifyReadClosed() {
        if (Bits.anyAreSet((int)this.state, (int)16384)) {
            return;
        }
        this.connection.readClosed();
        this.state |= 0x4000;
        if (Bits.anyAreSet((int)this.state, (int)8192)) {
            this.closed();
        }
    }

    public void startHandshake() throws SSLException {
        this.engine.beginHandshake();
    }

    public SSLSession getSslSession() {
        return this.engine.getSession();
    }

    private void doHandshake() throws IOException {
        this.doUnwrap(null, 0, 0);
        this.doWrap(null, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long doUnwrap(ByteBuffer[] userBuffers, int off, int len) throws IOException {
        Pooled unwrappedData;
        if (Bits.anyAreSet((int)this.state, (int)4096)) {
            throw new ClosedChannelException();
        }
        if (this.outstandingTasks > 0) {
            return 0L;
        }
        if (Bits.anyAreSet((int)this.state, (int)1)) {
            this.doWrap(null, 0, 0);
            if (Bits.allAreClear((int)this.state, (int)2)) {
                return 0L;
            }
        }
        if ((unwrappedData = this.unwrappedData) != null && userBuffers != null) {
            long copied = Buffers.copy((ByteBuffer[])userBuffers, (int)off, (int)len, (ByteBuffer)((ByteBuffer)unwrappedData.getResource()));
            if (!((ByteBuffer)unwrappedData.getResource()).hasRemaining()) {
                unwrappedData.free();
                this.unwrappedData = null;
            }
            return copied;
        }
        try {
            SSLEngineResult result;
            if (Bits.allAreClear((int)this.state, (int)16)) {
                int res;
                if (this.dataToUnwrap == null) {
                    this.dataToUnwrap = this.bufferPool.allocate();
                }
                try {
                    res = this.source.read((ByteBuffer)this.dataToUnwrap.getResource());
                }
                catch (IOException e) {
                    this.dataToUnwrap.free();
                    this.dataToUnwrap = null;
                    throw e;
                }
                ((ByteBuffer)this.dataToUnwrap.getResource()).flip();
                if (res == -1) {
                    this.dataToUnwrap.free();
                    this.dataToUnwrap = null;
                    this.notifyReadClosed();
                    long l = -1L;
                    return l;
                }
                if (res == 0 && this.engine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
                    long l = 0L;
                    return l;
                }
            }
            long original = 0L;
            if (userBuffers != null) {
                original = Buffers.remaining((Buffer[])userBuffers);
            }
            boolean unwrapBufferUsed = false;
            try {
                if (userBuffers != null) {
                    result = this.engine.unwrap((ByteBuffer)this.dataToUnwrap.getResource(), userBuffers, off, len);
                    if (result.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                        unwrappedData = this.bufferPool.allocate();
                        ByteBuffer[] d = new ByteBuffer[len + 1];
                        System.arraycopy(userBuffers, off, d, 0, len);
                        d[len] = (ByteBuffer)unwrappedData.getResource();
                        result = this.engine.unwrap((ByteBuffer)this.dataToUnwrap.getResource(), d);
                        unwrapBufferUsed = true;
                    }
                } else {
                    unwrapBufferUsed = true;
                    if (unwrappedData == null) {
                        unwrappedData = this.bufferPool.allocate();
                    } else {
                        ((ByteBuffer)unwrappedData.getResource()).compact();
                    }
                    result = this.engine.unwrap((ByteBuffer)this.dataToUnwrap.getResource(), (ByteBuffer)unwrappedData.getResource());
                }
            }
            finally {
                if (unwrapBufferUsed) {
                    ((ByteBuffer)unwrappedData.getResource()).flip();
                    if (!((ByteBuffer)unwrappedData.getResource()).hasRemaining()) {
                        unwrappedData.free();
                        unwrappedData = null;
                    }
                }
                this.unwrappedData = unwrappedData;
            }
            if (!this.handleHandshakeResult(result)) {
                if (((ByteBuffer)this.dataToUnwrap.getResource()).hasRemaining()) {
                    this.state |= 0x10;
                }
                long l = 0L;
                return l;
            }
            if (result.getStatus() == SSLEngineResult.Status.CLOSED) {
                this.notifyReadClosed();
                long l = -1L;
                return l;
            }
            if (result.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                this.state &= 0xFFFFFFEF;
            } else {
                if (result.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                    throw new IOException("overflow");
                }
                if (((ByteBuffer)this.dataToUnwrap.getResource()).hasRemaining()) {
                    this.state |= 0x10;
                }
            }
            if (userBuffers == null) {
                long l = 0L;
                return l;
            }
            long l = original - Buffers.remaining((Buffer[])userBuffers);
            return l;
        }
        finally {
            boolean requiresListenerInvocation = false;
            if (unwrappedData != null && ((ByteBuffer)unwrappedData.getResource()).hasRemaining()) {
                requiresListenerInvocation = true;
            }
            if (this.dataToUnwrap != null) {
                if (!((ByteBuffer)this.dataToUnwrap.getResource()).hasRemaining()) {
                    this.dataToUnwrap.free();
                    this.dataToUnwrap = null;
                    this.state &= 0xFFFFFFEF;
                } else if (Bits.allAreClear((int)this.state, (int)16)) {
                    ((ByteBuffer)this.dataToUnwrap.getResource()).compact();
                } else {
                    requiresListenerInvocation = true;
                }
            }
            if (requiresListenerInvocation && Bits.anyAreSet((int)this.state, (int)4)) {
                this.runReadListener();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long doWrap(ByteBuffer[] userBuffers, int off, int len) throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)4096)) {
            throw new ClosedChannelException();
        }
        if (this.outstandingTasks > 0) {
            return 0L;
        }
        if (Bits.anyAreSet((int)this.state, (int)2)) {
            this.doUnwrap(null, 0, 0);
            if (Bits.allAreClear((int)this.state, (int)1)) {
                return 0L;
            }
        }
        if (this.wrappedData != null) {
            int res = this.sink.write((ByteBuffer)this.wrappedData.getResource());
            if (res == 0 || ((ByteBuffer)this.wrappedData.getResource()).hasRemaining()) {
                return 0L;
            }
            ((ByteBuffer)this.wrappedData.getResource()).clear();
        } else {
            this.wrappedData = this.bufferPool.allocate();
        }
        try {
            SSLEngineResult result = null;
            while (result == null || result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_WRAP && result.getStatus() != SSLEngineResult.Status.BUFFER_OVERFLOW) {
                if (userBuffers == null) {
                    result = this.engine.wrap(EMPTY_BUFFER, (ByteBuffer)this.wrappedData.getResource());
                    continue;
                }
                result = this.engine.wrap(userBuffers, off, len, (ByteBuffer)this.wrappedData.getResource());
            }
            ((ByteBuffer)this.wrappedData.getResource()).flip();
            if (result.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                throw new IOException("underflow");
            }
            if (result.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW && !((ByteBuffer)this.wrappedData.getResource()).hasRemaining()) {
                throw new IOException("overflow");
            }
            int res = this.sink.write((ByteBuffer)this.wrappedData.getResource());
            if (((ByteBuffer)this.wrappedData.getResource()).hasRemaining()) {
                long l = result.bytesConsumed();
                return l;
            }
            if (!this.handleHandshakeResult(result)) {
                long l = 0L;
                return l;
            }
            if (result.getStatus() == SSLEngineResult.Status.CLOSED && userBuffers != null) {
                this.notifyWriteClosed();
                throw new ClosedChannelException();
            }
            long l = result.bytesConsumed();
            return l;
        }
        finally {
            if (this.wrappedData != null && !((ByteBuffer)this.wrappedData.getResource()).hasRemaining()) {
                this.wrappedData.free();
                this.wrappedData = null;
            }
        }
    }

    private boolean handleHandshakeResult(SSLEngineResult result) throws IOException {
        switch (result.getHandshakeStatus()) {
            case NEED_TASK: {
                this.state |= 0x800;
                this.clearReadRequiresWrite();
                this.clearWriteRequiresRead();
                this.runTasks();
                return false;
            }
            case NEED_UNWRAP: {
                this.clearReadRequiresWrite();
                this.state |= 0x802;
                this.sink.suspendWrites();
                if (Bits.anyAreSet((int)this.state, (int)8)) {
                    this.source.resumeReads();
                }
                if (Bits.anyAreSet((int)this.state, (int)16) && Bits.anyAreSet((int)this.state, (int)12)) {
                    this.runReadListener();
                }
                return false;
            }
            case NEED_WRAP: {
                this.clearWriteRequiresRead();
                this.state |= 0x801;
                this.source.suspendReads();
                if (Bits.anyAreSet((int)this.state, (int)4)) {
                    this.sink.resumeWrites();
                }
                return false;
            }
            case FINISHED: {
                if (!Bits.anyAreSet((int)this.state, (int)2048)) break;
                this.state &= 0xFFFFF7FF;
                this.handshakeCallback.run();
            }
        }
        this.clearReadRequiresWrite();
        this.clearWriteRequiresRead();
        return true;
    }

    private void clearReadRequiresWrite() {
        if (Bits.anyAreSet((int)this.state, (int)1)) {
            this.state &= 0xFFFFFFFE;
            if (Bits.anyAreSet((int)this.state, (int)4)) {
                this.resumeReads();
            }
            if (Bits.allAreClear((int)this.state, (int)8)) {
                this.sink.suspendWrites();
            }
        }
    }

    private void clearWriteRequiresRead() {
        if (Bits.anyAreSet((int)this.state, (int)2)) {
            this.state &= 0xFFFFFFFD;
            if (Bits.anyAreSet((int)this.state, (int)8)) {
                this.wakeupWrites();
            }
            if (Bits.allAreClear((int)this.state, (int)4)) {
                this.source.suspendReads();
            }
        }
    }

    private void closed() {
        if (Bits.anyAreSet((int)this.state, (int)4096)) {
            return;
        }
        this.state |= 0x1660;
        this.notifyReadClosed();
        this.notifyWriteClosed();
        if (this.dataToUnwrap != null) {
            this.dataToUnwrap.free();
            this.dataToUnwrap = null;
        }
        if (this.unwrappedData != null) {
            this.unwrappedData.free();
            this.unwrappedData = null;
        }
        if (this.wrappedData != null) {
            this.wrappedData.free();
            this.wrappedData = null;
        }
        if (Bits.allAreClear((int)this.state, (int)256)) {
            this.engine.closeOutbound();
        }
        if (Bits.allAreClear((int)this.state, (int)128)) {
            try {
                this.engine.closeInbound();
            }
            catch (SSLException e) {
                UndertowLogger.REQUEST_LOGGER.ioException(e);
            }
        }
        IoUtils.safeClose((Closeable)this.delegate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTasks() {
        this.delegate.getSinkChannel().suspendWrites();
        this.delegate.getSourceChannel().suspendReads();
        ArrayList<Runnable> tasks = new ArrayList<Runnable>();
        Runnable t = this.engine.getDelegatedTask();
        while (t != null) {
            tasks.add(t);
            t = this.engine.getDelegatedTask();
        }
        SslConduit sslConduit = this;
        synchronized (sslConduit) {
            this.outstandingTasks += tasks.size();
            for (final Runnable task : tasks) {
                this.getWorker().execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        SslConduit sslConduit;
                        try {
                            task.run();
                            sslConduit = SslConduit.this;
                        }
                        catch (Throwable throwable) {
                            SslConduit sslConduit2 = SslConduit.this;
                            synchronized (sslConduit2) {
                                if (SslConduit.this.outstandingTasks == 1) {
                                    SslConduit.this.getWriteThread().execute(new Runnable(){

                                        /*
                                         * WARNING - Removed try catching itself - possible behaviour change.
                                         */
                                        @Override
                                        public void run() {
                                            SslConduit sslConduit = SslConduit.this;
                                            synchronized (sslConduit) {
                                                SslConduit.this.notifyAll();
                                                --SslConduit.this.outstandingTasks;
                                                try {
                                                    SslConduit.this.doHandshake();
                                                }
                                                catch (IOException e) {
                                                    IoUtils.safeClose((Closeable)((Object)SslConduit.this.connection));
                                                }
                                                if (Bits.anyAreSet((int)SslConduit.this.state, (int)4)) {
                                                    SslConduit.this.wakeupReads();
                                                }
                                                if (Bits.anyAreSet((int)SslConduit.this.state, (int)8)) {
                                                    SslConduit.this.resumeWrites();
                                                }
                                            }
                                        }
                                    });
                                } else {
                                    SslConduit.this.outstandingTasks--;
                                }
                            }
                            throw throwable;
                        }
                        synchronized (sslConduit) {
                            if (SslConduit.this.outstandingTasks == 1) {
                                SslConduit.this.getWriteThread().execute(new /* invalid duplicate definition of identical inner class */);
                            } else {
                                SslConduit.this.outstandingTasks--;
                            }
                        }
                    }
                });
            }
        }
    }

    public SSLEngine getSSLEngine() {
        return this.engine;
    }

    public void close() {
        this.closed();
    }

    public String toString() {
        return "SslConduit{state=" + this.state + ", outstandingTasks=" + this.outstandingTasks + ", wrappedData=" + this.wrappedData + ", dataToUnwrap=" + this.dataToUnwrap + ", unwrappedData=" + this.unwrappedData + '}';
    }

    private class SslWriteReadyHandler
    implements WriteReadyHandler {
        private final WriteReadyHandler delegateHandler;

        private SslWriteReadyHandler(WriteReadyHandler delegateHandler) {
            this.delegateHandler = delegateHandler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void forceTermination() {
            try {
                if (this.delegateHandler != null) {
                    this.delegateHandler.forceTermination();
                }
            }
            finally {
                IoUtils.safeClose((Closeable)SslConduit.this.delegate);
            }
        }

        public void terminated() {
            ChannelListeners.invokeChannelListener((Channel)SslConduit.this.connection.getSinkChannel(), (ChannelListener)SslConduit.this.connection.getSinkChannel().getCloseListener());
        }

        public void writeReady() {
            if (Bits.anyAreSet((int)SslConduit.this.state, (int)1)) {
                try {
                    SslConduit.this.doHandshake();
                }
                catch (IOException e) {
                    UndertowLogger.REQUEST_LOGGER.ioException(e);
                    IoUtils.safeClose((Closeable)SslConduit.this.delegate);
                }
            }
            if (Bits.anyAreSet((int)SslConduit.this.state, (int)8)) {
                if (this.delegateHandler == null) {
                    ChannelListener writeListener = SslConduit.this.connection.getSinkChannel().getWriteListener();
                    if (writeListener == null) {
                        SslConduit.this.suspendWrites();
                    } else {
                        ChannelListeners.invokeChannelListener((Channel)SslConduit.this.connection.getSinkChannel(), (ChannelListener)writeListener);
                    }
                } else {
                    this.delegateHandler.writeReady();
                }
            }
            if (!Bits.anyAreSet((int)SslConduit.this.state, (int)9)) {
                SslConduit.this.delegate.getSinkChannel().suspendWrites();
            }
        }
    }

    private class SslReadReadyHandler
    implements ReadReadyHandler {
        private final ReadReadyHandler delegateHandler;

        private SslReadReadyHandler(ReadReadyHandler delegateHandler) {
            this.delegateHandler = delegateHandler;
        }

        public void readReady() {
            if (Bits.anyAreSet((int)SslConduit.this.state, (int)2)) {
                try {
                    SslConduit.this.doHandshake();
                }
                catch (IOException e) {
                    UndertowLogger.REQUEST_LOGGER.ioException(e);
                    IoUtils.safeClose((Closeable)SslConduit.this.delegate);
                }
            }
            if (Bits.anyAreSet((int)SslConduit.this.state, (int)4)) {
                if (this.delegateHandler == null) {
                    ChannelListener readListener = SslConduit.this.connection.getSourceChannel().getReadListener();
                    if (readListener == null) {
                        SslConduit.this.suspendReads();
                    } else {
                        ChannelListeners.invokeChannelListener((Channel)SslConduit.this.connection.getSourceChannel(), (ChannelListener)readListener);
                    }
                } else {
                    this.delegateHandler.readReady();
                }
            }
            if (!Bits.anyAreSet((int)SslConduit.this.state, (int)6)) {
                SslConduit.this.delegate.getSourceChannel().suspendReads();
            } else if (Bits.anyAreSet((int)SslConduit.this.state, (int)4) && (SslConduit.this.unwrappedData != null || Bits.anyAreSet((int)SslConduit.this.state, (int)16))) {
                if (Bits.anyAreSet((int)SslConduit.this.state, (int)16384)) {
                    if (SslConduit.this.unwrappedData != null) {
                        SslConduit.this.unwrappedData.free();
                    }
                    if (SslConduit.this.dataToUnwrap != null) {
                        SslConduit.this.dataToUnwrap.free();
                    }
                    SslConduit.this.unwrappedData = null;
                    SslConduit.this.dataToUnwrap = null;
                } else {
                    SslConduit.this.runReadListener();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void forceTermination() {
            try {
                if (this.delegateHandler != null) {
                    this.delegateHandler.forceTermination();
                }
            }
            finally {
                IoUtils.safeClose((Closeable)SslConduit.this.delegate);
            }
        }

        public void terminated() {
            ChannelListeners.invokeChannelListener((Channel)SslConduit.this.connection.getSourceChannel(), (ChannelListener)SslConduit.this.connection.getSourceChannel().getCloseListener());
        }
    }
}

