/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.client;

import io.undertow.util.FlexBase64;
import io.undertow.websockets.WebSocketExtension;
import io.undertow.websockets.client.WebSocketClientHandshake;
import io.undertow.websockets.client.WebSocketClientNegotiation;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSocketMessages;
import io.undertow.websockets.core.WebSocketUtils;
import io.undertow.websockets.core.WebSocketVersion;
import io.undertow.websockets.core.protocol.version13.WebSocket13Channel;
import io.undertow.websockets.extensions.ExtensionFunction;
import io.undertow.websockets.extensions.ExtensionHandshake;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.xnio.Pool;
import org.xnio.StreamConnection;
import org.xnio.http.ExtendedHandshakeChecker;

public class WebSocket13ClientHandshake
extends WebSocketClientHandshake {
    public static final String MAGIC_NUMBER = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    private final WebSocketClientNegotiation negotiation;
    private final Set<ExtensionHandshake> extensions;

    public WebSocket13ClientHandshake(URI url, WebSocketClientNegotiation negotiation, Set<ExtensionHandshake> extensions) {
        super(url);
        this.negotiation = negotiation;
        this.extensions = extensions == null ? Collections.emptySet() : extensions;
    }

    public WebSocket13ClientHandshake(URI url) {
        this(url, null, null);
    }

    @Override
    public WebSocketChannel createChannel(StreamConnection channel, String wsUri, Pool<ByteBuffer> bufferPool) {
        if (this.negotiation != null && this.negotiation.getSelectedExtensions() != null && !this.negotiation.getSelectedExtensions().isEmpty()) {
            List<WebSocketExtension> selected = this.negotiation.getSelectedExtensions();
            ArrayList<ExtensionFunction> negotiated = new ArrayList<ExtensionFunction>();
            if (selected != null && !selected.isEmpty()) {
                for (WebSocketExtension ext : selected) {
                    for (ExtensionHandshake extHandshake : this.extensions) {
                        if (!ext.getName().equals(extHandshake.getName())) continue;
                        negotiated.add(extHandshake.create());
                    }
                }
            }
            return new WebSocket13Channel(channel, bufferPool, wsUri, this.negotiation.getSelectedSubProtocol(), true, !negotiated.isEmpty(), negotiated, new HashSet<WebSocketChannel>());
        }
        return new WebSocket13Channel(channel, bufferPool, wsUri, this.negotiation != null ? this.negotiation.getSelectedSubProtocol() : "", true, false, null, new HashSet<WebSocketChannel>());
    }

    @Override
    public Map<String, String> createHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Upgrade", "websocket");
        headers.put("Connection", "upgrade");
        String key = this.createSecKey();
        headers.put("Sec-WebSocket-Key", key);
        headers.put("Sec-WebSocket-Version", this.getVersion().toHttpHeaderValue());
        if (this.negotiation != null) {
            List<WebSocketExtension> extensions;
            List<String> subProtocols = this.negotiation.getSupportedSubProtocols();
            if (subProtocols != null && !subProtocols.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                Iterator<String> it = subProtocols.iterator();
                while (it.hasNext()) {
                    sb.append(it.next());
                    if (!it.hasNext()) continue;
                    sb.append(", ");
                }
                headers.put("Sec-WebSocket-Protocol", sb.toString());
            }
            if ((extensions = this.negotiation.getSupportedExtensions()) != null && !extensions.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                Iterator<WebSocketExtension> it = extensions.iterator();
                while (it.hasNext()) {
                    WebSocketExtension next = it.next();
                    sb.append(next.getName());
                    for (WebSocketExtension.Parameter param : next.getParameters()) {
                        sb.append("; ");
                        sb.append(param.getName());
                        if (param.getValue() == null || param.getValue().length() <= 0) continue;
                        sb.append("=");
                        sb.append(param.getValue());
                    }
                    if (!it.hasNext()) continue;
                    sb.append(", ");
                }
                headers.put("Sec-WebSocket-Extensions", sb.toString());
            }
        }
        return headers;
    }

    protected String createSecKey() {
        SecureRandom random = new SecureRandom();
        byte[] data = new byte[16];
        for (int i = 0; i < 4; ++i) {
            int val = random.nextInt();
            data[i * 4] = (byte)val;
            data[i * 4 + 1] = (byte)(val >> 8 & 0xFF);
            data[i * 4 + 2] = (byte)(val >> 16 & 0xFF);
            data[i * 4 + 3] = (byte)(val >> 24 & 0xFF);
        }
        return FlexBase64.encodeString(data, false);
    }

    @Override
    public ExtendedHandshakeChecker handshakeChecker(URI uri, Map<String, List<String>> requestHeaders) {
        final String sentKey = requestHeaders.containsKey("Sec-WebSocket-Key") ? requestHeaders.get("Sec-WebSocket-Key").get(0) : null;
        return new ExtendedHandshakeChecker(){

            public void checkHandshakeExtended(Map<String, List<String>> headers) throws IOException {
                try {
                    String upgrade;
                    if (WebSocket13ClientHandshake.this.negotiation != null) {
                        WebSocket13ClientHandshake.this.negotiation.afterRequest(headers);
                    }
                    if ((upgrade = WebSocket13ClientHandshake.this.getFirst("Upgrade", headers)) == null || !upgrade.trim().equalsIgnoreCase("websocket")) {
                        throw WebSocketMessages.MESSAGES.noWebSocketUpgradeHeader();
                    }
                    String connHeader = WebSocket13ClientHandshake.this.getFirst("Connection", headers);
                    if (connHeader == null || !connHeader.trim().equalsIgnoreCase("upgrade")) {
                        throw WebSocketMessages.MESSAGES.noWebSocketConnectionHeader();
                    }
                    String acceptKey = WebSocket13ClientHandshake.this.getFirst("Sec-WebSocket-Accept", headers);
                    String dKey = WebSocket13ClientHandshake.this.solve(sentKey);
                    if (!dKey.equals(acceptKey)) {
                        throw WebSocketMessages.MESSAGES.webSocketAcceptKeyMismatch(dKey, acceptKey);
                    }
                    if (WebSocket13ClientHandshake.this.negotiation != null) {
                        String subProto = WebSocket13ClientHandshake.this.getFirst("Sec-WebSocket-Protocol", headers);
                        if (subProto != null && !subProto.isEmpty() && !WebSocket13ClientHandshake.this.negotiation.getSupportedSubProtocols().contains(subProto)) {
                            throw WebSocketMessages.MESSAGES.unsupportedProtocol(subProto, WebSocket13ClientHandshake.this.negotiation.getSupportedSubProtocols());
                        }
                        List<WebSocketExtension> extensions = Collections.emptyList();
                        String extHeader = WebSocket13ClientHandshake.this.getFirst("Sec-WebSocket-Extensions", headers);
                        if (extHeader != null) {
                            extensions = WebSocketExtension.parse(extHeader);
                        }
                        WebSocket13ClientHandshake.this.negotiation.handshakeComplete(subProto, extensions);
                    }
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
        };
    }

    private String getFirst(String key, Map<String, List<String>> map) {
        List<String> list = map.get(key.toLowerCase(Locale.ENGLISH));
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    protected final String solve(String nonceBase64) {
        try {
            String concat = nonceBase64 + MAGIC_NUMBER;
            MessageDigest digest = MessageDigest.getInstance("SHA1");
            digest.update(concat.getBytes(WebSocketUtils.UTF_8));
            byte[] bytes = digest.digest();
            return FlexBase64.encodeString(bytes, false);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public WebSocketVersion getVersion() {
        return WebSocketVersion.V13;
    }
}

