/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.attribute.ExchangeAttributes;
import io.undertow.server.handlers.AccessControlListHandler;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.net.UnknownHostException;
import org.junit.Assert;
import org.junit.Test;

public class UserAgentAccessControlHandlerUnitTestCase {
    private static final String PATTERN_IE_ALL = "Mozilla.+\\(compatible; MSIE .+";
    private static final String PATTERN_IE_ALL_ABOVE_6 = "Mozilla.+\\(compatible; MSIE ([7-9]|1[0-9]).+";
    private static final String PATTERN_FF_ALL = "Mozilla.+\\(.+ Gecko.* Firefox.+";
    private static final String IE_6 = "Mozilla/4.0 (compatible; MSIE 6.1; Windows XP; .NET CLR 1.1.4322; .NET CLR 2.0.50727)";
    private static final String IE_10 = "Mozilla/5.0 (compatible; MSIE 10.6; Windows NT 6.1; Trident/5.0; InfoPath.2; SLCC1; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; .NET CLR 2.0.50727) 3gpp-gba UNTRUSTED/1.0";
    private static final String FF_25 = "Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:25.0) Gecko/20100101 Firefox/25.0";
    private static final String SAFARI = "Mozilla/5.0 (iPad; CPU OS 6_0 like Mac OS X) AppleWebKit/536.26 (KHTML, like Gecko) Version/6.0 Mobile/10A5355d Safari/8536.25";

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidPattern() {
        new AccessControlListHandler(ExchangeAttributes.requestHeader((HttpString)Headers.USER_AGENT)).addAllow("[bogus");
    }

    @Test
    public void testFalseDefault() {
        Assert.assertFalse((boolean)new AccessControlListHandler(ExchangeAttributes.requestHeader((HttpString)Headers.USER_AGENT)).setDefaultAllow(false).isAllowed("some useragent"));
    }

    @Test
    public void testTrueDefault() throws UnknownHostException {
        Assert.assertTrue((boolean)new AccessControlListHandler(ExchangeAttributes.requestHeader((HttpString)Headers.USER_AGENT)).setDefaultAllow(true).isAllowed("some useragent"));
    }

    @Test
    public void testNullUserAgent() {
        Assert.assertTrue((boolean)new AccessControlListHandler(ExchangeAttributes.requestHeader((HttpString)Headers.USER_AGENT)).setDefaultAllow(true).isAllowed(null));
    }

    @Test
    public void testAllowAllButOne() throws UnknownHostException {
        AccessControlListHandler handler = new AccessControlListHandler(ExchangeAttributes.requestHeader((HttpString)Headers.USER_AGENT)).setDefaultAllow(true).addDeny(PATTERN_IE_ALL);
        Assert.assertFalse((boolean)handler.isAllowed(IE_6));
        Assert.assertTrue((boolean)handler.isAllowed(FF_25));
    }

    @Test
    public void testDenyAllButOne() throws UnknownHostException {
        AccessControlListHandler handler = new AccessControlListHandler(ExchangeAttributes.requestHeader((HttpString)Headers.USER_AGENT)).setDefaultAllow(false).addAllow(PATTERN_FF_ALL);
        Assert.assertTrue((boolean)handler.isAllowed(FF_25));
        Assert.assertFalse((boolean)handler.isAllowed(IE_10));
    }

    @Test
    public void testAllowIE6AndAboveAndAllOthers() throws UnknownHostException {
        AccessControlListHandler handler = new AccessControlListHandler(ExchangeAttributes.requestHeader((HttpString)Headers.USER_AGENT)).setDefaultAllow(true).addAllow(PATTERN_IE_ALL_ABOVE_6).addDeny(PATTERN_IE_ALL);
        Assert.assertFalse((boolean)handler.isAllowed(IE_6));
        Assert.assertTrue((boolean)handler.isAllowed(IE_10));
        Assert.assertTrue((boolean)handler.isAllowed(FF_25));
        Assert.assertTrue((boolean)handler.isAllowed(SAFARI));
    }
}

