/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.error;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.error.SimpleErrorPageHandler;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import java.io.IOException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class SimpleErrorPageHandlerTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleErrorPageIsGenerated() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            SimpleErrorPageHandler handler = new SimpleErrorPageHandler();
            DefaultServer.setRootHandler((HttpHandler)handler);
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)404L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse(result);
            Assert.assertTrue((String)response, (boolean)response.contains("Not Found"));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

