/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.file;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.encoding.ContentEncodedResourceManager;
import io.undertow.server.handlers.encoding.ContentEncodingProvider;
import io.undertow.server.handlers.encoding.ContentEncodingRepository;
import io.undertow.server.handlers.encoding.DeflateEncodingProvider;
import io.undertow.server.handlers.resource.CachingResourceManager;
import io.undertow.server.handlers.resource.FileResourceManager;
import io.undertow.server.handlers.resource.ResourceHandler;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.ContentEncodingHttpClient;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class ContentEncodedResourceTestCase {
    public static final String DIR_NAME = "/contentEncodingTestCase";
    static File tmpDir;

    @BeforeClass
    public static void setup() {
        tmpDir = new File(System.getProperty("java.io.tmpdir") + DIR_NAME);
        tmpDir.mkdirs();
        tmpDir.deleteOnExit();
        FileResourceManager resourceManager = new FileResourceManager(tmpDir, 0xA00000L);
        DefaultServer.setRootHandler((HttpHandler)new ResourceHandler().setResourceManager((ResourceManager)resourceManager).setContentEncodedResourceManager(new ContentEncodedResourceManager(tmpDir, new CachingResourceManager(100, 10000L, null, (ResourceManager)resourceManager, -1), new ContentEncodingRepository().addEncodingHandler("deflate", (ContentEncodingProvider)new DeflateEncodingProvider(), 50, null), 0, 100000, null)));
    }

    @AfterClass
    public static void after() {
        for (File file : tmpDir.listFiles()) {
            file.delete();
        }
        tmpDir.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileIsCompressed() throws IOException, InterruptedException {
        ContentEncodingHttpClient client = new ContentEncodingHttpClient();
        String fileName = "hello.html";
        File f = new File(tmpDir, fileName);
        this.writeFile(f, "hello world");
        try {
            for (int i = 0; i < 3; ++i) {
                HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/" + fileName);
                HttpResponse result = client.execute((HttpUriRequest)get);
                Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
                String response = HttpClientUtils.readResponse(result);
                Assert.assertEquals((Object)"hello world", (Object)response);
                Assert.assertEquals((Object)"deflate", (Object)result.getHeaders("Content-Encoding")[0].getValue());
            }
            this.writeFile(f, "modified file");
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/" + fileName);
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse(result);
            Assert.assertEquals((Object)"hello world", (Object)response);
            Assert.assertEquals((Object)"deflate", (Object)result.getHeaders("Content-Encoding")[0].getValue());
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(File f, String contents) throws IOException {
        try (FileOutputStream out = new FileOutputStream(f);){
            out.write(contents.getBytes());
        }
    }
}

