/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.security;

import io.undertow.security.idm.DigestAlgorithm;
import io.undertow.security.impl.DigestAuthorizationToken;
import io.undertow.security.impl.DigestQop;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class ParseDigestAuthorizationTokenTestCase {
    private void doTest(String header, Map<DigestAuthorizationToken, String> expected) {
        Map parsedHeader = DigestAuthorizationToken.parseHeader((String)header);
        Assert.assertEquals(expected, (Object)parsedHeader);
    }

    @Test
    public void testChrome_22() {
        String header = "username=\"userTwo\", realm=\"Digest_Realm\", nonce=\"Yxmkh5liIOYNMTM1MTUyNjQzMTE4NJziT7YLEOEJ4QEN1py4Yog=\", uri=\"/\", algorithm=MD5, response=\"5b26e00233607e8a714cd1d910692e08\", opaque=\"00000000000000000000000000000000\", qop=auth, nc=00000001, cnonce=\"8c008c8ce43dc0a7\"";
        HashMap<DigestAuthorizationToken, String> expected = new HashMap<DigestAuthorizationToken, String>(10);
        expected.put(DigestAuthorizationToken.USERNAME, "userTwo");
        expected.put(DigestAuthorizationToken.REALM, "Digest_Realm");
        expected.put(DigestAuthorizationToken.NONCE, "Yxmkh5liIOYNMTM1MTUyNjQzMTE4NJziT7YLEOEJ4QEN1py4Yog=");
        expected.put(DigestAuthorizationToken.DIGEST_URI, "/");
        expected.put(DigestAuthorizationToken.ALGORITHM, DigestAlgorithm.MD5.getToken());
        expected.put(DigestAuthorizationToken.RESPONSE, "5b26e00233607e8a714cd1d910692e08");
        expected.put(DigestAuthorizationToken.OPAQUE, "00000000000000000000000000000000");
        expected.put(DigestAuthorizationToken.MESSAGE_QOP, DigestQop.AUTH.getToken());
        expected.put(DigestAuthorizationToken.NONCE_COUNT, "00000001");
        expected.put(DigestAuthorizationToken.CNONCE, "8c008c8ce43dc0a7");
        this.doTest("username=\"userTwo\", realm=\"Digest_Realm\", nonce=\"Yxmkh5liIOYNMTM1MTUyNjQzMTE4NJziT7YLEOEJ4QEN1py4Yog=\", uri=\"/\", algorithm=MD5, response=\"5b26e00233607e8a714cd1d910692e08\", opaque=\"00000000000000000000000000000000\", qop=auth, nc=00000001, cnonce=\"8c008c8ce43dc0a7\"", expected);
    }

    @Test
    public void testCurl_7() {
        String header = "username=\"userTwo\", realm=\"Digest_Realm\", nonce=\"5CgZ39vhie0NMTM1MTUyNDc4ODkwNMwr6sWKVSGfhXB4jBtkupY=\", uri=\"/\", cnonce=\"MTYwOTQ4\", nc=00000001, qop=\"auth\", response=\"c3c1ce9945a0c36d54860eda7846018b\", opaque=\"00000000000000000000000000000000\", algorithm=\"MD5\"";
        HashMap<DigestAuthorizationToken, String> expected = new HashMap<DigestAuthorizationToken, String>(10);
        expected.put(DigestAuthorizationToken.USERNAME, "userTwo");
        expected.put(DigestAuthorizationToken.REALM, "Digest_Realm");
        expected.put(DigestAuthorizationToken.NONCE, "5CgZ39vhie0NMTM1MTUyNDc4ODkwNMwr6sWKVSGfhXB4jBtkupY=");
        expected.put(DigestAuthorizationToken.DIGEST_URI, "/");
        expected.put(DigestAuthorizationToken.CNONCE, "MTYwOTQ4");
        expected.put(DigestAuthorizationToken.NONCE_COUNT, "00000001");
        expected.put(DigestAuthorizationToken.MESSAGE_QOP, DigestQop.AUTH.getToken());
        expected.put(DigestAuthorizationToken.RESPONSE, "c3c1ce9945a0c36d54860eda7846018b");
        expected.put(DigestAuthorizationToken.OPAQUE, "00000000000000000000000000000000");
        expected.put(DigestAuthorizationToken.ALGORITHM, DigestAlgorithm.MD5.getToken());
        this.doTest("username=\"userTwo\", realm=\"Digest_Realm\", nonce=\"5CgZ39vhie0NMTM1MTUyNDc4ODkwNMwr6sWKVSGfhXB4jBtkupY=\", uri=\"/\", cnonce=\"MTYwOTQ4\", nc=00000001, qop=\"auth\", response=\"c3c1ce9945a0c36d54860eda7846018b\", opaque=\"00000000000000000000000000000000\", algorithm=\"MD5\"", expected);
    }

    @Test
    public void testFirefox_16() {
        String header = "username=\"userOne\", realm=\"Digest_Realm\", nonce=\"nBhFxtSS6rkNMTM1MTUyNjE2MjgyNWA/xW/LOH53vhXGq/2B/yQ=\", uri=\"/\", algorithm=MD5, response=\"b0adb1025da2de0d16f44131858bad6f\", opaque=\"00000000000000000000000000000000\", qop=auth, nc=00000001, cnonce=\"8127726535363b07\"";
        HashMap<DigestAuthorizationToken, String> expected = new HashMap<DigestAuthorizationToken, String>(10);
        expected.put(DigestAuthorizationToken.USERNAME, "userOne");
        expected.put(DigestAuthorizationToken.REALM, "Digest_Realm");
        expected.put(DigestAuthorizationToken.NONCE, "nBhFxtSS6rkNMTM1MTUyNjE2MjgyNWA/xW/LOH53vhXGq/2B/yQ=");
        expected.put(DigestAuthorizationToken.DIGEST_URI, "/");
        expected.put(DigestAuthorizationToken.ALGORITHM, DigestAlgorithm.MD5.getToken());
        expected.put(DigestAuthorizationToken.RESPONSE, "b0adb1025da2de0d16f44131858bad6f");
        expected.put(DigestAuthorizationToken.OPAQUE, "00000000000000000000000000000000");
        expected.put(DigestAuthorizationToken.MESSAGE_QOP, DigestQop.AUTH.getToken());
        expected.put(DigestAuthorizationToken.NONCE_COUNT, "00000001");
        expected.put(DigestAuthorizationToken.CNONCE, "8127726535363b07");
        this.doTest("username=\"userOne\", realm=\"Digest_Realm\", nonce=\"nBhFxtSS6rkNMTM1MTUyNjE2MjgyNWA/xW/LOH53vhXGq/2B/yQ=\", uri=\"/\", algorithm=MD5, response=\"b0adb1025da2de0d16f44131858bad6f\", opaque=\"00000000000000000000000000000000\", qop=auth, nc=00000001, cnonce=\"8127726535363b07\"", expected);
    }

    @Test
    public void testOpera_12() {
        String header = "username=\"userOne\", realm=\"Digest_Realm\", uri=\"/\", algorithm=MD5, nonce=\"D2floAc+FhkNMTM1MTUyMzY2ODc4Mhbi2Zrcuv1lvdgEaPXa+bg=\", cnonce=\"v722VYJEeG28C3SoXS8BEWThGHPDOlXgUCCts70i7Fc=\", opaque=\"00000000000000000000000000000000\", qop=auth, nc=00000001, response=\"8106a5d19bc67982527cbb576658f9d6\"";
        HashMap<DigestAuthorizationToken, String> expected = new HashMap<DigestAuthorizationToken, String>(10);
        expected.put(DigestAuthorizationToken.USERNAME, "userOne");
        expected.put(DigestAuthorizationToken.REALM, "Digest_Realm");
        expected.put(DigestAuthorizationToken.DIGEST_URI, "/");
        expected.put(DigestAuthorizationToken.ALGORITHM, DigestAlgorithm.MD5.getToken());
        expected.put(DigestAuthorizationToken.NONCE, "D2floAc+FhkNMTM1MTUyMzY2ODc4Mhbi2Zrcuv1lvdgEaPXa+bg=");
        expected.put(DigestAuthorizationToken.CNONCE, "v722VYJEeG28C3SoXS8BEWThGHPDOlXgUCCts70i7Fc=");
        expected.put(DigestAuthorizationToken.OPAQUE, "00000000000000000000000000000000");
        expected.put(DigestAuthorizationToken.MESSAGE_QOP, DigestQop.AUTH.getToken());
        expected.put(DigestAuthorizationToken.NONCE_COUNT, "00000001");
        expected.put(DigestAuthorizationToken.RESPONSE, "8106a5d19bc67982527cbb576658f9d6");
        this.doTest("username=\"userOne\", realm=\"Digest_Realm\", uri=\"/\", algorithm=MD5, nonce=\"D2floAc+FhkNMTM1MTUyMzY2ODc4Mhbi2Zrcuv1lvdgEaPXa+bg=\", cnonce=\"v722VYJEeG28C3SoXS8BEWThGHPDOlXgUCCts70i7Fc=\", opaque=\"00000000000000000000000000000000\", qop=auth, nc=00000001, response=\"8106a5d19bc67982527cbb576658f9d6\"", expected);
    }
}

