/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.extensions;

import io.undertow.UndertowLogger;
import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderValues;

public class DebugExtensionsHeaderHandler
implements HttpHandler {
    private final HttpHandler next;
    private HeaderValues requestExtensions;
    private HeaderValues responseExtensions;

    public DebugExtensionsHeaderHandler(HttpHandler next) {
        this.next = next;
    }

    public HeaderValues getRequestExtensions() {
        return this.requestExtensions;
    }

    public HeaderValues getResponseExtensions() {
        return this.responseExtensions;
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        final StringBuilder sb = new StringBuilder();
        this.requestExtensions = exchange.getRequestHeaders().get("Sec-WebSocket-Extensions");
        if (this.requestExtensions != null) {
            for (String value : this.requestExtensions) {
                sb.append("\n").append("--- REQUEST ---").append("\n").append("Sec-WebSocket-Extensions").append(": ").append(value).append("\n");
            }
            exchange.addExchangeCompleteListener(new ExchangeCompletionListener(){

                public void exchangeEvent(HttpServerExchange exchange, ExchangeCompletionListener.NextListener nextListener) {
                    DebugExtensionsHeaderHandler.this.responseExtensions = exchange.getResponseHeaders().get("Sec-WebSocket-Extensions");
                    if (DebugExtensionsHeaderHandler.this.responseExtensions != null) {
                        for (String value : DebugExtensionsHeaderHandler.this.responseExtensions) {
                            sb.append("\n").append("--- RESPONSE ---").append("\n").append("Sec-WebSocket-Extensions").append(": ").append(value).append("\n");
                        }
                    }
                    nextListener.proceed();
                    UndertowLogger.REQUEST_DUMPER_LOGGER.info((Object)sb.toString());
                }
            });
        }
        this.next.handleRequest(exchange);
    }
}

