/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ByteRangeHandler;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.TestHttpClient;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class RangeRequestTestCase {
    @BeforeClass
    public static void setup() {
        DefaultServer.setRootHandler((HttpHandler)new ByteRangeHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                exchange.getResponseSender().send("0123456789");
            }
        }, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRangeRequests() throws IOException, InterruptedException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
            get.addHeader("range", "bytes=2-3");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)206L, (long)result.getStatusLine().getStatusCode());
            String response = EntityUtils.toString((HttpEntity)result.getEntity());
            Assert.assertEquals((Object)"23", (Object)response);
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
            get.addHeader("range", "bytes=0-0");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)206L, (long)result.getStatusLine().getStatusCode());
            response = EntityUtils.toString((HttpEntity)result.getEntity());
            Assert.assertEquals((Object)"0", (Object)response);
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
            get.addHeader("range", "bytes=1-");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)206L, (long)result.getStatusLine().getStatusCode());
            response = EntityUtils.toString((HttpEntity)result.getEntity());
            Assert.assertEquals((Object)"123456789", (Object)response);
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
            get.addHeader("range", "bytes=9-");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)206L, (long)result.getStatusLine().getStatusCode());
            response = EntityUtils.toString((HttpEntity)result.getEntity());
            Assert.assertEquals((Object)"9", (Object)response);
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
            get.addHeader("range", "bytes=-1");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)206L, (long)result.getStatusLine().getStatusCode());
            response = EntityUtils.toString((HttpEntity)result.getEntity());
            Assert.assertEquals((Object)"9", (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

