/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.extensions;

import io.undertow.websockets.core.AbstractReceiveListener;
import io.undertow.websockets.core.BufferedBinaryMessage;
import io.undertow.websockets.core.BufferedTextMessage;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSocketLogger;
import io.undertow.websockets.core.WebSockets;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.xnio.Pooled;

public class DebugExtensionsListener
extends AbstractReceiveListener {
    private int binMsgs = 0;
    private int txtMsgs = 0;

    protected void onFullTextMessage(WebSocketChannel channel, BufferedTextMessage message) throws IOException {
        ++this.txtMsgs;
        String data = message.getData();
        WebSocketLogger.EXTENSION_LOGGER.info((Object)("#" + this.txtMsgs + " onFullTextMessage() - Received: " + data.getBytes().length + " bytes. "));
        for (WebSocketChannel peerChannel : channel.getPeerConnections()) {
            WebSockets.sendText((String)data, (WebSocketChannel)peerChannel, null);
        }
    }

    protected void onFullBinaryMessage(WebSocketChannel channel, BufferedBinaryMessage message) throws IOException {
        ++this.binMsgs;
        ByteBuffer[] data = (ByteBuffer[])message.getData().getResource();
        int total = 0;
        for (int i = 0; i < data.length; ++i) {
            total += data[i].remaining();
        }
        StringBuilder received = new StringBuilder();
        received.append("# " + this.binMsgs + " onFullBinaryMessage() - Received: ").append(total).append(" length.").append("\n");
        WebSocketLogger.EXTENSION_LOGGER.info((Object)received.toString());
        for (WebSocketChannel peerChannel : channel.getPeerConnections()) {
            WebSockets.sendBinary((ByteBuffer[])data, (WebSocketChannel)peerChannel, null);
        }
    }

    protected void onFullPingMessage(WebSocketChannel channel, BufferedBinaryMessage message) throws IOException {
        WebSocketLogger.EXTENSION_LOGGER.info((Object)"onFullPingMessage() ");
        ByteBuffer[] data = (ByteBuffer[])message.getData().getResource();
        for (WebSocketChannel peerChannel : channel.getPeerConnections()) {
            WebSockets.sendPong((ByteBuffer[])data, (WebSocketChannel)peerChannel, null);
        }
    }

    protected void onFullPongMessage(WebSocketChannel channel, BufferedBinaryMessage message) throws IOException {
        WebSocketLogger.EXTENSION_LOGGER.info((Object)"onFullPongMessage() ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onFullCloseMessage(WebSocketChannel channel, BufferedBinaryMessage message) throws IOException {
        WebSocketLogger.EXTENSION_LOGGER.info((Object)"onFullCloseMessage() ");
        Pooled pooled = message.getData();
        try {
            ByteBuffer[] data = (ByteBuffer[])pooled.getResource();
            if (data.length == 1 || !data[0].hasRemaining()) {
                for (WebSocketChannel peerChannel : channel.getPeerConnections()) {
                    WebSockets.sendClose((int)1000, (String)"", (WebSocketChannel)peerChannel, null);
                }
            } else {
                for (WebSocketChannel peerChannel : channel.getPeerConnections()) {
                    WebSockets.sendClose((ByteBuffer[])data, (WebSocketChannel)peerChannel, null);
                }
            }
        }
        finally {
            pooled.free();
        }
    }

    protected void onError(WebSocketChannel channel, Throwable error) {
        WebSocketLogger.EXTENSION_LOGGER.info((Object)("onError(): " + error.getMessage()));
    }
}

