/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.security;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.SecurityNotification;
import io.undertow.server.security.BasicAuthenticationTestCase;
import io.undertow.server.security.SpnegoAuthenticationTestCase;
import io.undertow.testutils.DefaultServer;
import java.util.ArrayList;
import java.util.List;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class SpnegoBasicAuthenticationTestCase
extends SpnegoAuthenticationTestCase {
    @Override
    protected List<AuthenticationMechanism> getTestMechanisms() {
        ArrayList<AuthenticationMechanism> mechanisms = new ArrayList<AuthenticationMechanism>(super.getTestMechanisms());
        mechanisms.add(BasicAuthenticationTestCase.getTestMechanism());
        return mechanisms;
    }

    @Test
    public void testBasicSuccess() throws Exception {
        this.setAuthenticationChain();
        BasicAuthenticationTestCase._testBasicSuccess();
        SpnegoBasicAuthenticationTestCase.assertSingleNotificationType(SecurityNotification.EventType.AUTHENTICATED);
    }

    @Test
    public void testBadUserName() throws Exception {
        this.setAuthenticationChain();
        BasicAuthenticationTestCase._testBadUserName();
        SpnegoBasicAuthenticationTestCase.assertSingleNotificationType(SecurityNotification.EventType.FAILED_AUTHENTICATION);
    }

    @Test
    public void testBadPassword() throws Exception {
        this.setAuthenticationChain();
        BasicAuthenticationTestCase._testBadPassword();
        SpnegoBasicAuthenticationTestCase.assertSingleNotificationType(SecurityNotification.EventType.FAILED_AUTHENTICATION);
    }
}

