/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.BlockingHandler;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class RequestLimitingHandlerTestCase {
    public static final int N_THREADS = 10;
    private static volatile CountDownLatch latch = new CountDownLatch(1);
    static final AtomicInteger count = new AtomicInteger();

    @BeforeClass
    public static void setup() {
        DefaultServer.setRootHandler((HttpHandler)new BlockingHandler((HttpHandler)Handlers.requestLimitingHandler((int)2, (int)10, (HttpHandler)new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                int res = count.incrementAndGet();
                try {
                    if (!latch.await(20L, TimeUnit.SECONDS)) {
                        exchange.setStatusCode(500);
                    } else {
                        exchange.getOutputStream().write(("" + res).getBytes("US-ASCII"));
                    }
                }
                finally {
                    count.decrementAndGet();
                }
            }
        })));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRateLimitingHandler() throws ExecutionException, InterruptedException {
        latch.countDown();
        latch = new CountDownLatch(1);
        ExecutorService executor = Executors.newFixedThreadPool(10);
        try {
            ArrayList<Future<String>> futures = new ArrayList<Future<String>>();
            for (int i = 0; i < 10; ++i) {
                futures.add(executor.submit(new Callable<String>(){

                    @Override
                    public String call() {
                        TestHttpClient client = new TestHttpClient();
                        try {
                            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL());
                            HttpResponse result = client.execute((HttpUriRequest)get);
                            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
                            String string = HttpClientUtils.readResponse(result);
                            return string;
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                        finally {
                            client.getConnectionManager().shutdown();
                        }
                    }
                }));
            }
            Thread.sleep(300L);
            latch.countDown();
            for (Future future : futures) {
                String res;
                Assert.assertTrue((String)res, ((res = (String)future.get()).equals("1") || res.equals("2") ? 1 : 0) != 0);
            }
        }
        finally {
            executor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRateLimitingHandlerQueueFull() throws ExecutionException, InterruptedException {
        latch.countDown();
        latch = new CountDownLatch(1);
        ExecutorService executor = Executors.newFixedThreadPool(20);
        try {
            String res;
            ArrayList<Future<String>> futures = new ArrayList<Future<String>>();
            for (int i = 0; i < 20; ++i) {
                futures.add(executor.submit(new Callable<String>(){

                    @Override
                    public String call() {
                        TestHttpClient client = new TestHttpClient();
                        try {
                            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL());
                            HttpResponse result = client.execute((HttpUriRequest)get);
                            if (result.getStatusLine().getStatusCode() == 513) {
                                String string = "513";
                                return string;
                            }
                            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
                            String string = HttpClientUtils.readResponse(result);
                            return string;
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                        finally {
                            client.getConnectionManager().shutdown();
                        }
                    }
                }));
            }
            Thread.sleep(300L);
            latch.countDown();
            for (Future future : futures) {
                Assert.assertTrue((String)res, ((res = (String)future.get()).equals("1") || res.equals("2") || res.equals("513") ? 1 : 0) != 0);
            }
            futures.clear();
            for (int i = 0; i < 2; ++i) {
                futures.add(executor.submit(new Callable<String>(){

                    @Override
                    public String call() {
                        TestHttpClient client = new TestHttpClient();
                        try {
                            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL());
                            HttpResponse result = client.execute((HttpUriRequest)get);
                            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
                            String string = HttpClientUtils.readResponse(result);
                            return string;
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                        finally {
                            client.getConnectionManager().shutdown();
                        }
                    }
                }));
            }
            for (Future future : futures) {
                Assert.assertTrue((String)res, ((res = (String)future.get()).equals("1") || res.equals("2") ? 1 : 0) != 0);
            }
        }
        finally {
            executor.shutdown();
        }
    }
}

