/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.extensions;

import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CompressionUtilsTest {
    private static Inflater decompress;
    private static Deflater compress;
    private static byte[] buf;

    @Before
    public void setup() throws Exception {
        compress = new Deflater(1, true);
        decompress = new Inflater(true);
    }

    @After
    public void finish() throws Exception {
        compress.end();
        decompress.end();
    }

    @Test
    public void testBasicCompressDecompress() throws Exception {
        String raw = "Hello";
        compress.setInput(raw.getBytes());
        compress.finish();
        int read = compress.deflate(buf, 0, buf.length, 2);
        decompress.setInput(buf, 0, read);
        read = decompress.inflate(buf);
        Assert.assertEquals((Object)"Hello", (Object)new String(buf, 0, read, "UTF-8"));
        compress.reset();
        decompress.reset();
        raw = "Hello, World!";
        compress.setInput(raw.getBytes());
        compress.finish();
        read = compress.deflate(buf, 0, buf.length, 2);
        decompress.setInput(buf, 0, read);
        read = decompress.inflate(buf);
        Assert.assertEquals((Object)"Hello, World!", (Object)new String(buf, 0, read, "UTF-8"));
    }

    @Test
    public void testCompressDecompressByFrames() throws Exception {
        String raw = "Hello, World! This is a long input example data with a lot of content for testing";
        int position1 = 0;
        int position2 = 512;
        int chunkLength = 10;
        compress.setInput(raw.getBytes(), position1, chunkLength);
        int compressed = compress.deflate(buf, 0, 512, 2);
        decompress.setInput(buf, 0, compressed);
        int decompressed = decompress.inflate(buf, position2, buf.length - position2);
        position2 += decompressed;
        compress.setInput(raw.getBytes(), position1 += chunkLength, chunkLength);
        compressed = compress.deflate(buf, 0, 512, 0);
        decompress.setInput(buf, 0, compressed);
        decompress.finished();
        decompressed = decompress.inflate(buf, position2, buf.length - position2);
        position2 += decompressed;
        compress.setInput(raw.getBytes(), position1 += chunkLength, raw.getBytes().length - position1);
        compress.finish();
        compressed = compress.deflate(buf, 0, 512, 0);
        decompress.setInput(buf, 0, compressed);
        decompressed = decompress.inflate(buf, position2, buf.length - position2);
        Assert.assertEquals((Object)raw, (Object)new String(buf, 512, position2 + decompressed - 512, "UTF-8"));
    }

    @Test
    public void testCompressByFramesDecompressWhole() throws Exception {
        String raw = "Hello, World! This is a long input example data with a lot of content for testing";
        byte[] compressed = new byte[raw.length() + 64];
        byte[] decompressed = new byte[raw.length()];
        int n = 0;
        int total = 0;
        compress.setInput(raw.getBytes(), 0, 10);
        n = compress.deflate(compressed, 0, compressed.length, 2);
        total += n;
        compress.setInput(raw.getBytes(), 10, 10);
        n = compress.deflate(compressed, total, compressed.length - total, 2);
        total += n;
        compress.setInput(raw.getBytes(), 20, raw.getBytes().length - 20);
        n = compress.deflate(compressed, total, compressed.length - total, 2);
        decompress.setInput(compressed, 0, total += n);
        n = decompress.inflate(decompressed, 0, decompressed.length);
        Assert.assertEquals((Object)raw, (Object)new String(decompressed, 0, n, "UTF-8"));
    }

    @Test
    public void testLongMessage() throws Exception {
        int LONG_MSG = 16384;
        StringBuilder longMsg = new StringBuilder(LONG_MSG);
        byte[] longbuf = new byte[LONG_MSG + 64];
        byte[] output = new byte[LONG_MSG];
        for (int i = 0; i < LONG_MSG; ++i) {
            longMsg.append(new Integer(i).toString().charAt(0));
        }
        String msg = longMsg.toString();
        byte[] input = msg.getBytes();
        byte[] compressBuf = new byte[LONG_MSG + 64];
        byte[] decompressBuf = new byte[LONG_MSG];
        compress.setInput(input);
        compress.finish();
        int read = compress.deflate(compressBuf, 0, compressBuf.length, 2);
        decompress.setInput(compressBuf, 0, read);
        read = decompress.inflate(decompressBuf);
        Assert.assertEquals((Object)msg, (Object)new String(decompressBuf, 0, read, "UTF-8"));
    }

    @Test
    public void testCompressByFramesDecompressWholeLongMessage() throws Exception {
        int LONG_MSG = 76800;
        StringBuilder longMsg = new StringBuilder(LONG_MSG);
        byte[] longbuf = new byte[LONG_MSG + 64];
        byte[] output = new byte[LONG_MSG];
        for (int i = 0; i < LONG_MSG; ++i) {
            longMsg.append(new Integer(i).toString().charAt(0));
        }
        String msg = longMsg.toString();
        byte[] input = msg.getBytes();
        boolean finished = false;
        int start = 0;
        int total = 0;
        while (!finished) {
            int end = start + 1024 < input.length ? 1024 : input.length - start;
            compress.setInput(input, start, end);
            boolean bl = finished = (start += 1024) >= input.length;
            if (finished) {
                compress.finish();
            }
            int compressed = compress.deflate(longbuf, total, longbuf.length - total, 2);
            total += compressed;
        }
        int decompressed = 0;
        decompress.setInput(longbuf, 0, total);
        decompress.finished();
        decompressed = decompress.inflate(output, 0, output.length);
        Assert.assertEquals((Object)longMsg.toString(), (Object)new String(output, 0, decompressed, "UTF-8"));
    }

    @Test
    public void testEmptyFrames() throws Exception {
        decompress.reset();
        byte[] compressedFrame1 = new byte[]{-14, 72, -51};
        byte[] compressedFrame2 = new byte[]{-55, -55, 7, 0};
        byte[] compressedFrame3 = new byte[]{0, 0, -1, -1};
        byte[] output = new byte[1024];
        int decompressed = 0;
        decompress.setInput(compressedFrame1);
        decompressed = decompress.inflate(output, 0, output.length);
        Assert.assertEquals((long)2L, (long)decompressed);
        Assert.assertEquals((Object)"He", (Object)new String(output, 0, decompressed, "UTF-8"));
        decompress.setInput(compressedFrame2);
        decompressed = decompress.inflate(output, 0, output.length);
        Assert.assertEquals((long)3L, (long)decompressed);
        Assert.assertEquals((Object)"llo", (Object)new String(output, 0, decompressed, "UTF-8"));
        decompress.setInput(compressedFrame3);
        decompressed = decompress.inflate(output, 0, output.length);
        Assert.assertEquals((long)0L, (long)decompressed);
        decompress.setInput(compressedFrame1);
        decompressed = decompress.inflate(output, 0, output.length);
        Assert.assertEquals((long)2L, (long)decompressed);
        Assert.assertEquals((Object)"He", (Object)new String(output, 0, decompressed, "UTF-8"));
        decompress.setInput(compressedFrame2);
        decompressed = decompress.inflate(output, 0, output.length);
        Assert.assertEquals((long)3L, (long)decompressed);
        Assert.assertEquals((Object)"llo", (Object)new String(output, 0, decompressed, "UTF-8"));
    }

    @Test
    public void testPadding() throws Exception {
        String original = "This is a long message - This is a long message - This is a long message";
        byte[] compressed = new byte[1024];
        compress.setInput(original.getBytes());
        int nCompressed = compress.deflate(compressed, 0, compressed.length, 2);
        byte[] padding = new byte[]{0, 0, 0, -1, -1, 0, 0, 0, -1, -1, 0, 0, 0, -1, -1};
        int nPadding = padding.length;
        for (int i = 0; i < padding.length; ++i) {
            compressed[nCompressed + i] = padding[i];
        }
        byte[] uncompressed = new byte[1024];
        decompress.setInput(compressed, 0, nCompressed + nPadding);
        int nUncompressed = decompress.inflate(uncompressed);
        Assert.assertEquals((Object)original, (Object)new String(uncompressed, 0, nUncompressed, "UTF-8"));
    }

    static {
        buf = new byte[1024];
    }
}

