/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ConnectHandler;
import io.undertow.server.handlers.SetHeaderHandler;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.ProxyIgnore;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.Socket;
import org.apache.http.HttpHost;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.impl.client.ProxyClient;
import org.apache.http.protocol.HTTP;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
@ProxyIgnore
public class HttpTunnelingViaConnectTestCase {
    private static Undertow server;

    @BeforeClass
    public static void setup() {
        DefaultServer.setRootHandler((HttpHandler)new SetHeaderHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                exchange.getResponseSender().send("hi all");
            }
        }, "MyHeader", "MyValue"));
        server = Undertow.builder().addHttpListener(DefaultServer.getHostPort("default") + 1, DefaultServer.getHostAddress("default")).setHandler((HttpHandler)new ConnectHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                exchange.setStatusCode(500);
            }
        })).build();
        server.start();
    }

    @AfterClass
    public static void stop() {
        server.stop();
        server = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnectViaProxy() throws Exception {
        HttpHost proxy = new HttpHost(DefaultServer.getHostAddress("default"), DefaultServer.getHostPort("default") + 1, "http");
        HttpHost target = new HttpHost(DefaultServer.getHostAddress("default"), DefaultServer.getHostPort("default"), "http");
        ProxyClient proxyClient = new ProxyClient();
        try (Socket socket = proxyClient.tunnel(proxy, target, (Credentials)new UsernamePasswordCredentials("a", "b"));){
            OutputStreamWriter out = new OutputStreamWriter(socket.getOutputStream(), HTTP.DEF_CONTENT_CHARSET);
            out.write("GET / HTTP/1.1\r\n");
            out.write("Host: " + target.toHostString() + "\r\n");
            out.write("Connection: close\r\n");
            out.write("\r\n");
            ((Writer)out).flush();
            BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream(), HTTP.DEF_CONTENT_CHARSET));
            String line = null;
            boolean found = false;
            while ((line = in.readLine()) != null) {
                System.out.println(line);
                if (!line.equals("MyHeader: MyValue")) continue;
                found = true;
            }
            Assert.assertTrue((boolean)found);
        }
    }
}

