/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.proxy;

import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.client.UndertowClient;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.proxy.AbstractLoadBalancingProxyTestCase;
import io.undertow.server.handlers.proxy.LoadBalancingProxyClient;
import io.undertow.server.handlers.proxy.ProxyClient;
import io.undertow.server.handlers.proxy.ProxyHandler;
import io.undertow.server.session.InMemorySessionManager;
import io.undertow.server.session.SessionAttachmentHandler;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionCookieConfig;
import io.undertow.server.session.SessionManager;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.xnio.Options;

@RunWith(value=DefaultServer.class)
public class LoadBalancingProxyWithCustomHostSelectorTestCase {
    protected static Undertow server1;
    protected static Undertow server2;

    @BeforeClass
    public static void setup() throws URISyntaxException {
        SessionCookieConfig sessionConfig = new SessionCookieConfig();
        int port = DefaultServer.getHostPort("default");
        server1 = Undertow.builder().addHttpListener(port + 1, DefaultServer.getHostAddress("default")).setSocketOption(Options.REUSE_ADDRESSES, (Object)true).setHandler((HttpHandler)Handlers.jvmRoute((String)"JSESSIONID", (String)"s1", (HttpHandler)Handlers.path().addPrefixPath("/session", (HttpHandler)new SessionAttachmentHandler((HttpHandler)new AbstractLoadBalancingProxyTestCase.SessionTestHandler(sessionConfig), (SessionManager)new InMemorySessionManager(""), (SessionConfig)sessionConfig)).addPrefixPath("/name", (HttpHandler)new AbstractLoadBalancingProxyTestCase.StringSendHandler("server1")))).build();
        server2 = Undertow.builder().addHttpListener(port + 2, DefaultServer.getHostAddress("default")).setSocketOption(Options.REUSE_ADDRESSES, (Object)true).setHandler((HttpHandler)Handlers.jvmRoute((String)"JSESSIONID", (String)"s2", (HttpHandler)Handlers.path().addPrefixPath("/session", (HttpHandler)new SessionAttachmentHandler((HttpHandler)new AbstractLoadBalancingProxyTestCase.SessionTestHandler(sessionConfig), (SessionManager)new InMemorySessionManager(""), (SessionConfig)sessionConfig)).addPrefixPath("/name", (HttpHandler)new AbstractLoadBalancingProxyTestCase.StringSendHandler("server2")))).build();
        server1.start();
        server2.start();
        LoadBalancingProxyClient.HostSelector hostSelector = new LoadBalancingProxyClient.HostSelector(){

            public int selectHost(LoadBalancingProxyClient.Host[] availableHosts) {
                return 0;
            }
        };
        DefaultServer.setRootHandler((HttpHandler)new ProxyHandler((ProxyClient)new LoadBalancingProxyClient(UndertowClient.getInstance(), null, hostSelector).setConnectionsPerThread(1).addHost(new URI("http", null, DefaultServer.getHostAddress("default"), port + 1, null, null, null), "s1").addHost(new URI("http", null, DefaultServer.getHostAddress("default"), port + 2, null, null, null), "s2"), 10000, (HttpHandler)ResponseCodeHandler.HANDLE_404));
    }

    @AfterClass
    public static void teardown() {
        server1.stop();
        server2.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDistributeLoadToGivenHost() throws Throwable {
        StringBuilder resultString = new StringBuilder();
        for (int i = 0; i < 6; ++i) {
            TestHttpClient client = new TestHttpClient();
            try {
                HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/name");
                HttpResponse result = client.execute((HttpUriRequest)get);
                Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
                resultString.append(HttpClientUtils.readResponse(result));
                resultString.append(' ');
                continue;
            }
            finally {
                client.getConnectionManager().shutdown();
            }
        }
        Assert.assertTrue((boolean)resultString.toString().contains("server1"));
        Assert.assertFalse((boolean)resultString.toString().contains("server2"));
    }
}

