/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.sse;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.sse.ServerSentEventConnection;
import io.undertow.server.handlers.sse.ServerSentEventConnectionCallback;
import io.undertow.server.handlers.sse.ServerSentEventHandler;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.xnio.IoUtils;

@RunWith(value=DefaultServer.class)
public class ServerSentEventTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSSE() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            DefaultServer.setRootHandler((HttpHandler)new ServerSentEventHandler(new ServerSentEventConnectionCallback(){

                public void connected(ServerSentEventConnection connection, String lastEventId) {
                    connection.send("msg 1", new ServerSentEventConnection.EventCallback(){

                        public void done(ServerSentEventConnection connection, String data, String event, String id) {
                            connection.send("msg 2", new ServerSentEventConnection.EventCallback(){

                                public void done(ServerSentEventConnection connection, String data, String event, String id) {
                                    IoUtils.safeClose((Closeable)connection);
                                }

                                public void failed(ServerSentEventConnection connection, String data, String event, String id, IOException e) {
                                    e.printStackTrace();
                                    IoUtils.safeClose((Closeable)connection);
                                }
                            });
                        }

                        public void failed(ServerSentEventConnection connection, String data, String event, String id, IOException e) {
                            e.printStackTrace();
                            IoUtils.safeClose((Closeable)connection);
                        }
                    });
                }
            }));
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse(result);
            Assert.assertEquals((Object)"data:msg 1\n\ndata:msg 2\n\n", (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLargeMessage() throws IOException {
        TestHttpClient client = new TestHttpClient();
        final StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 10000; ++i) {
            sb.append("hello world ");
        }
        try {
            DefaultServer.setRootHandler((HttpHandler)new ServerSentEventHandler(new ServerSentEventConnectionCallback(){

                public void connected(ServerSentEventConnection connection, String lastEventId) {
                    connection.send(sb.toString(), new ServerSentEventConnection.EventCallback(){

                        public void done(ServerSentEventConnection connection, String data, String event, String id) {
                            IoUtils.safeClose((Closeable)connection);
                        }

                        public void failed(ServerSentEventConnection connection, String data, String event, String id, IOException e) {
                            e.printStackTrace();
                            IoUtils.safeClose((Closeable)connection);
                        }
                    });
                }
            }));
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse(result);
            Assert.assertEquals((Object)("data:" + sb.toString() + "\n\n"), (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    @Test
    public void testConnectionFail() throws IOException, InterruptedException {
        Socket socket = new Socket(DefaultServer.getHostAddress("default"), DefaultServer.getHostPort("default"));
        final CountDownLatch latch = new CountDownLatch(1);
        DefaultServer.setRootHandler((HttpHandler)new ServerSentEventHandler(new ServerSentEventConnectionCallback(){

            public void connected(ServerSentEventConnection connection, String lastEventId) {
                while (connection.isOpen()) {
                    connection.send("hello", new ServerSentEventConnection.EventCallback(){

                        public void done(ServerSentEventConnection connection, String data, String event, String id) {
                        }

                        public void failed(ServerSentEventConnection connection, String data, String event, String id, IOException e) {
                            latch.countDown();
                        }
                    });
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }));
        InputStream in = socket.getInputStream();
        OutputStream out = socket.getOutputStream();
        out.write("GET / HTTP/1.1\r\n\r\n".getBytes());
        out.flush();
        out.close();
        in.close();
        if (!latch.await(10L, TimeUnit.SECONDS)) {
            Assert.fail();
        }
    }
}

