/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.protocol.http;

import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.BlockingHandler;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.HttpOneOnly;
import io.undertow.testutils.ProxyIgnore;
import io.undertow.testutils.TestHttpClient;
import java.nio.charset.StandardCharsets;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
@ProxyIgnore
@HttpOneOnly
public class ContentOverrunTestCase {
    @BeforeClass
    public static void setup() {
        HttpHandler overlyLong = new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                exchange.setResponseContentLength(10L);
                exchange.getOutputStream().write("Overly long content".getBytes(StandardCharsets.UTF_8));
            }
        };
        HttpHandler responseNotAllowed = new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                exchange.setStatusCode(204);
                exchange.getOutputStream().write("Overly long content".getBytes(StandardCharsets.UTF_8));
            }
        };
        DefaultServer.setRootHandler((HttpHandler)Handlers.path().addPrefixPath("/204", (HttpHandler)new BlockingHandler(responseNotAllowed)).addPrefixPath("/long", (HttpHandler)new BlockingHandler(overlyLong)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testContentOn204() throws Exception {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/204");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)204L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse(result);
            Assert.assertEquals((Object)"", (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testContentPastContentLength() throws Exception {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/long");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse(result);
            Assert.assertEquals((Object)"Overly lon", (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

