/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.proxy;

import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.InMemorySessionManager;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionAttachmentHandler;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionCookieConfig;
import io.undertow.server.session.SessionManager;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import java.io.IOException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public abstract class AbstractLoadBalancingProxyTestCase {
    private static final String COUNT = "count";
    protected static Undertow server1;
    protected static Undertow server2;

    @AfterClass
    public static void teardown() {
        server1.stop();
        server2.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoadShared() throws IOException {
        StringBuilder resultString = new StringBuilder();
        for (int i = 0; i < 6; ++i) {
            TestHttpClient client = new TestHttpClient();
            try {
                HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/name");
                HttpResponse result = client.execute((HttpUriRequest)get);
                Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
                resultString.append(HttpClientUtils.readResponse(result));
                resultString.append(' ');
                continue;
            }
            finally {
                client.getConnectionManager().shutdown();
            }
        }
        Assert.assertTrue((boolean)resultString.toString().contains("server1"));
        Assert.assertTrue((boolean)resultString.toString().contains("server2"));
    }

    @Test
    public void testLoadSharedWithServerShutdown() throws Exception {
        StringBuilder resultString = new StringBuilder();
        for (int i = 0; i < 6; ++i) {
            TestHttpClient client = new TestHttpClient();
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/name");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((String)("Test failed with i=" + i), (long)200L, (long)result.getStatusLine().getStatusCode());
            resultString.append(HttpClientUtils.readResponse(result));
            resultString.append(' ');
            server1.stop();
            Thread.sleep(600L);
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/name");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((String)("Test failed with i=" + i), (long)200L, (long)result.getStatusLine().getStatusCode());
            resultString.append(HttpClientUtils.readResponse(result));
            resultString.append(' ');
            server1.start();
            server2.stop();
            Thread.sleep(600L);
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/name");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((String)("Test failed with i=" + i), (long)200L, (long)result.getStatusLine().getStatusCode());
            resultString.append(HttpClientUtils.readResponse(result));
            resultString.append(' ');
            server2.start();
        }
        Assert.assertTrue((boolean)resultString.toString().contains("server1"));
        Assert.assertTrue((boolean)resultString.toString().contains("server2"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStickySessions() throws IOException {
        int expected = 0;
        TestHttpClient client = new TestHttpClient();
        try {
            for (int i = 0; i < 6; ++i) {
                try {
                    HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/session");
                    get.addHeader("Connection", "close");
                    HttpResponse result = client.execute((HttpUriRequest)get);
                    Assert.assertEquals((String)("Test failed with i=" + i), (long)200L, (long)result.getStatusLine().getStatusCode());
                    int count = Integer.parseInt(HttpClientUtils.readResponse(result));
                    Assert.assertEquals((long)expected++, (long)count);
                    continue;
                }
                catch (AssertionError e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new AssertionError("Test failed with i=" + i, e);
                }
            }
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDuplicateHeaders() throws IOException {
        int expected = 0;
        TestHttpClient client = new TestHttpClient();
        try {
            for (int i = 0; i < 6; ++i) {
                try {
                    HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/session");
                    get.addHeader("a", "b");
                    get.addHeader("a", "b");
                    get.addHeader("a", "b");
                    get.addHeader("a", "b");
                    get.addHeader("a", "b");
                    get.addHeader("a", "b");
                    get.addHeader("a", "b");
                    get.addHeader("a", "b");
                    get.addHeader("Connection", "close");
                    HttpResponse result = client.execute((HttpUriRequest)get);
                    Assert.assertEquals((String)("Test failed with i=" + i), (long)200L, (long)result.getStatusLine().getStatusCode());
                    int count = Integer.parseInt(HttpClientUtils.readResponse(result));
                    Assert.assertEquals((String)("Test failed with i=" + i), (long)expected++, (long)count);
                    continue;
                }
                catch (AssertionError e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new AssertionError("Test failed with i=" + i, e);
                }
            }
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    protected static HttpHandler getRootHandler(String s1, String server1) {
        SessionCookieConfig sessionConfig = new SessionCookieConfig();
        return Handlers.jvmRoute((String)"JSESSIONID", (String)s1, (HttpHandler)Handlers.path().addPrefixPath("/session", (HttpHandler)new SessionAttachmentHandler((HttpHandler)new SessionTestHandler(sessionConfig), (SessionManager)new InMemorySessionManager(""), (SessionConfig)sessionConfig)).addPrefixPath("/name", (HttpHandler)new StringSendHandler(server1)).addPrefixPath("/path", new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                exchange.getResponseSender().send(exchange.getRequestURI());
            }
        }));
    }

    protected static final class StringSendHandler
    implements HttpHandler {
        private final String serverName;

        protected StringSendHandler(String serverName) {
            this.serverName = serverName;
        }

        public void handleRequest(HttpServerExchange exchange) throws Exception {
            exchange.getResponseSender().send(this.serverName);
        }
    }

    protected static final class SessionTestHandler
    implements HttpHandler {
        private final SessionCookieConfig sessionConfig;

        protected SessionTestHandler(SessionCookieConfig sessionConfig) {
            this.sessionConfig = sessionConfig;
        }

        public void handleRequest(HttpServerExchange exchange) throws Exception {
            SessionManager manager = (SessionManager)exchange.getAttachment(SessionManager.ATTACHMENT_KEY);
            Session session = manager.getSession(exchange, (SessionConfig)this.sessionConfig);
            if (session == null) {
                session = manager.createSession(exchange, (SessionConfig)this.sessionConfig);
                session.setAttribute(AbstractLoadBalancingProxyTestCase.COUNT, (Object)0);
            }
            Integer count = (Integer)session.getAttribute(AbstractLoadBalancingProxyTestCase.COUNT);
            session.setAttribute(AbstractLoadBalancingProxyTestCase.COUNT, (Object)(count + 1));
            exchange.getResponseSender().send("" + count);
        }
    }
}

