/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.proxy.mod_cluster;

import io.undertow.client.UndertowClient;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.proxy.ProxyHandler;
import io.undertow.server.handlers.proxy.mod_cluster.MCMPAdvertiseTask;
import io.undertow.server.handlers.proxy.mod_cluster.MCMPConfig;
import io.undertow.server.handlers.proxy.mod_cluster.ModClusterContainer;
import io.undertow.server.handlers.proxy.mod_cluster.ModClusterController;
import io.undertow.server.handlers.proxy.mod_cluster.NodeHealthChecker;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.xnio.OptionMap;
import org.xnio.XnioWorker;
import org.xnio.ssl.XnioSsl;

public class ModCluster {
    private static final HttpHandler NEXT_HANDLER = ResponseCodeHandler.HANDLE_404;
    private final long healthCheckInterval;
    private final long removeBrokenNodes;
    private final NodeHealthChecker healthChecker;
    private final int maxConnections;
    private final int cacheConnections;
    private final int requestQueueSize;
    private final boolean queueNewRequests;
    private final int maxRequestTime;
    private final long ttl;
    private final boolean useAlias;
    private final XnioWorker xnioWorker;
    private final ModClusterContainer container;
    private final boolean deterministicFailover;
    private final String serverID = UUID.randomUUID().toString();

    ModCluster(Builder builder) {
        this.xnioWorker = builder.xnioWorker;
        this.maxConnections = builder.maxConnections;
        this.cacheConnections = builder.cacheConnections;
        this.requestQueueSize = builder.requestQueueSize;
        this.queueNewRequests = builder.queueNewRequests;
        this.healthCheckInterval = builder.healthCheckInterval;
        this.removeBrokenNodes = builder.removeBrokenNodes;
        this.deterministicFailover = builder.deterministicFailover;
        this.healthChecker = builder.healthChecker;
        this.maxRequestTime = builder.maxRequestTime;
        this.ttl = builder.ttl;
        this.useAlias = builder.useAlias;
        this.container = new ModClusterContainer(this, builder.xnioSsl, builder.client, builder.clientOptions);
    }

    protected String getServerID() {
        return this.serverID;
    }

    protected ModClusterContainer getContainer() {
        return this.container;
    }

    public ModClusterController getController() {
        return this.container;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public int getCacheConnections() {
        return this.cacheConnections;
    }

    public int getRequestQueueSize() {
        return this.requestQueueSize;
    }

    public boolean isQueueNewRequests() {
        return this.queueNewRequests;
    }

    public long getHealthCheckInterval() {
        return this.healthCheckInterval;
    }

    public long getRemoveBrokenNodes() {
        return this.removeBrokenNodes;
    }

    public NodeHealthChecker getHealthChecker() {
        return this.healthChecker;
    }

    public long getTtl() {
        return this.ttl;
    }

    public boolean isUseAlias() {
        return this.useAlias;
    }

    public boolean isDeterministicFailover() {
        return this.deterministicFailover;
    }

    @Deprecated
    public HttpHandler getProxyHandler() {
        return this.createProxyHandler();
    }

    public HttpHandler createProxyHandler() {
        return new ProxyHandler(this.container.getProxyClient(), this.maxRequestTime, NEXT_HANDLER);
    }

    public HttpHandler createProxyHandler(HttpHandler next) {
        return new ProxyHandler(this.container.getProxyClient(), this.maxRequestTime, next);
    }

    public synchronized void start() {
    }

    public synchronized void advertise(MCMPConfig config) throws IOException {
        MCMPConfig.AdvertiseConfig advertiseConfig = config.getAdvertiseConfig();
        if (advertiseConfig == null) {
            throw new IllegalArgumentException("advertise not enabled");
        }
        MCMPAdvertiseTask.advertise(this.container, advertiseConfig, this.xnioWorker);
    }

    public synchronized void stop() {
    }

    public static Builder builder(XnioWorker worker) {
        return ModCluster.builder(worker, UndertowClient.getInstance(), null);
    }

    public static Builder builder(XnioWorker worker, UndertowClient client) {
        return ModCluster.builder(worker, client, null);
    }

    public static Builder builder(XnioWorker worker, UndertowClient client, XnioSsl xnioSsl) {
        return new Builder(worker, client, xnioSsl);
    }

    public static class Builder {
        private final XnioSsl xnioSsl;
        private final UndertowClient client;
        private final XnioWorker xnioWorker;
        private int maxConnections = 16;
        private int cacheConnections = 8;
        private int requestQueueSize = 0;
        private boolean queueNewRequests = false;
        private int maxRequestTime = -1;
        private long ttl;
        private boolean useAlias = false;
        private NodeHealthChecker healthChecker = NodeHealthChecker.NO_CHECK;
        private long healthCheckInterval = TimeUnit.SECONDS.toMillis(10L);
        private long removeBrokenNodes = TimeUnit.MINUTES.toMillis(1L);
        private OptionMap clientOptions = OptionMap.EMPTY;
        private boolean deterministicFailover = false;

        private Builder(XnioWorker xnioWorker, UndertowClient client, XnioSsl xnioSsl) {
            this.xnioSsl = xnioSsl;
            this.client = client;
            this.xnioWorker = xnioWorker;
        }

        public ModCluster build() {
            return new ModCluster(this);
        }

        public Builder setMaxRequestTime(int maxRequestTime) {
            this.maxRequestTime = maxRequestTime;
            return this;
        }

        public Builder setHealthCheckInterval(long healthCheckInterval) {
            this.healthCheckInterval = healthCheckInterval;
            return this;
        }

        public Builder setRemoveBrokenNodes(long removeBrokenNodes) {
            this.removeBrokenNodes = removeBrokenNodes;
            return this;
        }

        public Builder setMaxConnections(int maxConnections) {
            this.maxConnections = maxConnections;
            return this;
        }

        public Builder setCacheConnections(int cacheConnections) {
            this.cacheConnections = cacheConnections;
            return this;
        }

        public Builder setRequestQueueSize(int requestQueueSize) {
            this.requestQueueSize = requestQueueSize;
            return this;
        }

        public Builder setQueueNewRequests(boolean queueNewRequests) {
            this.queueNewRequests = queueNewRequests;
            return this;
        }

        public Builder setHealthChecker(NodeHealthChecker healthChecker) {
            this.healthChecker = healthChecker;
            return this;
        }

        public Builder setUseAlias(boolean useAlias) {
            this.useAlias = useAlias;
            return this;
        }

        public long getTtl() {
            return this.ttl;
        }

        public Builder setDeterministicFailover(boolean deterministicFailover) {
            this.deterministicFailover = deterministicFailover;
            return this;
        }

        public Builder setTtl(long ttl) {
            this.ttl = ttl;
            return this;
        }

        public Builder setClientOptions(OptionMap clientOptions) {
            this.clientOptions = clientOptions;
            return this;
        }
    }
}

