/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.util.URLUtils;
import java.nio.charset.Charset;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class URLUtilsTestCase {
    @Parameterized.Parameter
    public String spaceCode = "%2f";

    @Parameterized.Parameters
    public static Object[] spaceCodes() {
        return new Object[]{"%2f", "%2F"};
    }

    @Test
    public void testDecodingWithEncodedAndDecodedSlashAndSlashDecodingDisabled() throws Exception {
        String url = "http://localhost:3001/by-path/wild%20card/wild%28west%29/wild" + this.spaceCode + "wolf";
        String result = URLUtils.decode((String)url, (String)Charset.defaultCharset().name(), (boolean)false, (StringBuilder)new StringBuilder());
        Assert.assertEquals((Object)("http://localhost:3001/by-path/wild card/wild(west)/wild" + this.spaceCode + "wolf"), (Object)result);
    }

    @Test
    public void testDecodingURLMustNotMutateSpaceSymbolsCaseIfSpaceDecodingDisabled() throws Exception {
        String url = "http://localhost:3001/wild" + this.spaceCode + "west";
        String result = URLUtils.decode((String)url, (String)Charset.defaultCharset().name(), (boolean)false, (StringBuilder)new StringBuilder());
        Assert.assertEquals((Object)url, (Object)result);
    }
}

