/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.io.IoCallback;
import io.undertow.io.Receiver;
import io.undertow.io.Sender;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.PathHandler;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Deque;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class ReceiverTestCase {
    public static final String HELLO_WORLD = "Hello World";

    @BeforeClass
    public static void setup() {
        HttpHandler testFullString = new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                exchange.getRequestReceiver().receiveFullString(new Receiver.FullStringCallback(){

                    public void handle(HttpServerExchange exchange, String message) {
                        exchange.getResponseSender().send(message);
                    }
                });
            }
        };
        HttpHandler testPartialString = new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                final StringBuilder sb = new StringBuilder();
                exchange.getRequestReceiver().receivePartialString(new Receiver.PartialStringCallback(){

                    public void handle(HttpServerExchange exchange, String message, boolean last) {
                        sb.append(message);
                        if (last) {
                            exchange.getResponseSender().send(sb.toString());
                        }
                    }
                });
            }
        };
        HttpHandler testFullBytes = new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                exchange.getRequestReceiver().receiveFullBytes(new Receiver.FullBytesCallback(){

                    public void handle(HttpServerExchange exchange, byte[] message) {
                        exchange.getResponseSender().send(ByteBuffer.wrap(message));
                    }
                });
            }
        };
        HttpHandler testPartialBytes = new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                class CB
                implements Receiver.PartialBytesCallback,
                IoCallback {
                    final Receiver receiver;
                    final Sender sender;

                    CB(Receiver receiver, Sender sender) {
                        this.receiver = receiver;
                        this.sender = sender;
                    }

                    public void onComplete(HttpServerExchange exchange, Sender sender) {
                        this.receiver.resume();
                    }

                    public void onException(HttpServerExchange exchange, Sender sender, IOException exception) {
                        exception.printStackTrace();
                        exchange.setStatusCode(500);
                        exchange.endExchange();
                    }

                    public void handle(HttpServerExchange exchange, byte[] message, boolean last) {
                        this.receiver.pause();
                        this.sender.send(ByteBuffer.wrap(message), (IoCallback)(last ? IoCallback.END_EXCHANGE : this));
                    }
                }
                CB callback = new CB(exchange.getRequestReceiver(), exchange.getResponseSender());
                exchange.getRequestReceiver().receivePartialBytes((Receiver.PartialBytesCallback)callback);
            }
        };
        final PathHandler handler = new PathHandler().addPrefixPath("/fullstring", testFullString).addPrefixPath("/partialstring", testPartialString).addPrefixPath("/fullbytes", testFullBytes).addPrefixPath("/partialbytes", testPartialBytes);
        DefaultServer.setRootHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                Deque block = (Deque)exchange.getQueryParameters().get("blocking");
                if (block != null) {
                    exchange.startBlocking();
                    exchange.dispatch((HttpHandler)handler);
                    return;
                }
                handler.handleRequest(exchange);
            }
        });
    }

    @Test
    public void testAsyncReceiveWholeString() {
        this.doTest("/fullstring");
    }

    @Test
    public void testAsyncReceivePartialString() {
        this.doTest("/partialstring");
    }

    @Test
    public void testAsyncReceiveWholeBytes() {
        this.doTest("/fullbytes");
    }

    @Test
    public void testAsyncReceivePartialBytes() {
        this.doTest("/partialbytes");
    }

    @Test
    public void testBlockingReceiveWholeString() {
        this.doTest("/fullstring?blocking");
    }

    @Test
    public void testBlockingReceivePartialString() {
        this.doTest("/partialstring?blocking");
    }

    @Test
    public void testBlockingReceiveWholeBytes() {
        this.doTest("/fullbytes?blocking");
    }

    @Test
    public void testBlockingReceivePartialBytes() {
        this.doTest("/partialbytes?blocking");
    }

    public void doTest(String path) {
        StringBuilder builder = new StringBuilder(1000 * HELLO_WORLD.length());
        for (int i = 0; i < 10; ++i) {
            try {
                for (int j = 0; j < 1000; ++j) {
                    builder.append(HELLO_WORLD);
                }
                String message = builder.toString();
                this.runTest(message, path);
                continue;
            }
            catch (Throwable e) {
                throw new RuntimeException("test failed with i equal to " + i, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTest(String message, String url) throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            String uri = DefaultServer.getDefaultServerURL() + url;
            HttpPost post = new HttpPost(uri);
            post.setEntity((HttpEntity)new StringEntity(message));
            HttpResponse result = client.execute((HttpUriRequest)post);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse(result);
            Assert.assertEquals((long)message.length(), (long)response.length());
            Assert.assertEquals((Object)message, (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

