/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.accesslog;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.accesslog.AccessLogHandler;
import io.undertow.server.handlers.accesslog.AccessLogReceiver;
import io.undertow.server.handlers.accesslog.DefaultAccessLogReceiver;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import io.undertow.util.CompletionLatchHandler;
import io.undertow.util.FileUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class AccessLogFileTestCase {
    private static final Path logDirectory = Paths.get(System.getProperty("java.io.tmpdir"), "logs");
    private static final int NUM_THREADS = 10;
    private static final int NUM_REQUESTS = 12;
    private static final HttpHandler HELLO_HANDLER = new HttpHandler(){

        public void handleRequest(HttpServerExchange exchange) throws Exception {
            exchange.getResponseSender().send("Hello");
        }
    };

    @Before
    public void before() throws IOException {
        Files.createDirectories(logDirectory, new FileAttribute[0]);
    }

    @After
    public void after() throws IOException {
        FileUtils.deleteRecursive((Path)logDirectory);
    }

    @Test
    public void testSingleLogMessageToFile() throws IOException, InterruptedException {
        Path directory = logDirectory;
        Path logFileName = directory.resolve("server1.log");
        DefaultAccessLogReceiver logReceiver = new DefaultAccessLogReceiver((Executor)DefaultServer.getWorker(), directory, "server1.");
        this.verifySingleLogMessageToFile(logFileName, logReceiver);
    }

    @Test
    public void testSingleLogMessageToFileWithSuffix() throws IOException, InterruptedException {
        Path directory = logDirectory;
        Path logFileName = directory.resolve("server1.logsuffix");
        DefaultAccessLogReceiver logReceiver = new DefaultAccessLogReceiver((Executor)DefaultServer.getWorker(), directory, "server1.", "logsuffix");
        this.verifySingleLogMessageToFile(logFileName, logReceiver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifySingleLogMessageToFile(Path logFileName, DefaultAccessLogReceiver logReceiver) throws IOException, InterruptedException {
        CompletionLatchHandler latchHandler = new CompletionLatchHandler((HttpHandler)new AccessLogHandler(HELLO_HANDLER, (AccessLogReceiver)logReceiver, "Remote address %a Code %s test-header %{i,test-header} %{i,non-existent}", AccessLogFileTestCase.class.getClassLoader()));
        DefaultServer.setRootHandler(latchHandler);
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
            get.addHeader("test-header", "single-val");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)"Hello", (Object)HttpClientUtils.readResponse(result));
            latchHandler.await();
            logReceiver.awaitWrittenForTest();
            Assert.assertEquals((Object)("Remote address " + DefaultServer.getDefaultServerAddress().getAddress().getHostAddress() + " Code 200 test-header single-val -\n"), (Object)new String(Files.readAllBytes(logFileName)));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLogLotsOfThreads() throws IOException, InterruptedException, ExecutionException {
        Path directory = logDirectory;
        Path logFileName = directory.resolve("server2.log");
        DefaultAccessLogReceiver logReceiver = new DefaultAccessLogReceiver((Executor)DefaultServer.getWorker(), directory, "server2.");
        CompletionLatchHandler latchHandler = new CompletionLatchHandler(120, (HttpHandler)new AccessLogHandler(HELLO_HANDLER, (AccessLogReceiver)logReceiver, "REQ %{i,test-header}", AccessLogFileTestCase.class.getClassLoader()));
        DefaultServer.setRootHandler(latchHandler);
        ExecutorService executor = Executors.newFixedThreadPool(10);
        try {
            ArrayList futures = new ArrayList();
            int i = 0;
            while (i < 10) {
                final int n = i++;
                futures.add(executor.submit(new Runnable(){

                    @Override
                    public void run() {
                        TestHttpClient client = new TestHttpClient();
                        try {
                            for (int i = 0; i < 12; ++i) {
                                HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
                                get.addHeader("test-header", "thread-" + n + "-request-" + i);
                                HttpResponse result = client.execute((HttpUriRequest)get);
                                Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
                                String response = HttpClientUtils.readResponse(result);
                                Assert.assertEquals((Object)"Hello", (Object)response);
                            }
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                        finally {
                            client.getConnectionManager().shutdown();
                        }
                    }
                }));
            }
            for (Future future : futures) {
                future.get();
            }
        }
        finally {
            executor.shutdown();
        }
        latchHandler.await();
        logReceiver.awaitWrittenForTest();
        String completeLog = new String(Files.readAllBytes(logFileName));
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 12; ++j) {
                Assert.assertTrue((boolean)completeLog.contains("REQ thread-" + i + "-request-" + j));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testForcedLogRotation() throws IOException, InterruptedException {
        Path logFileName = logDirectory.resolve("server.log");
        DefaultAccessLogReceiver logReceiver = new DefaultAccessLogReceiver((Executor)DefaultServer.getWorker(), logDirectory, "server.");
        CompletionLatchHandler latchHandler = new CompletionLatchHandler((HttpHandler)new AccessLogHandler(HELLO_HANDLER, (AccessLogReceiver)logReceiver, "Remote address %a Code %s test-header %{i,test-header}", AccessLogFileTestCase.class.getClassLoader()));
        DefaultServer.setRootHandler(latchHandler);
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
            get.addHeader("test-header", "v1");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)"Hello", (Object)HttpClientUtils.readResponse(result));
            latchHandler.await();
            latchHandler.reset();
            logReceiver.awaitWrittenForTest();
            Assert.assertEquals((Object)("Remote address " + DefaultServer.getDefaultServerAddress().getAddress().getHostAddress() + " Code 200 test-header v1\n"), (Object)new String(Files.readAllBytes(logFileName)));
            logReceiver.rotate();
            logReceiver.awaitWrittenForTest();
            Assert.assertFalse((boolean)Files.exists(logFileName, new LinkOption[0]));
            Path firstLogRotate = logDirectory.resolve("server." + new SimpleDateFormat("yyyy-MM-dd").format(new Date()) + ".log");
            Assert.assertEquals((Object)("Remote address " + DefaultServer.getDefaultServerAddress().getAddress().getHostAddress() + " Code 200 test-header v1\n"), (Object)new String(Files.readAllBytes(firstLogRotate)));
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
            get.addHeader("test-header", "v2");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)"Hello", (Object)HttpClientUtils.readResponse(result));
            latchHandler.await();
            latchHandler.reset();
            logReceiver.awaitWrittenForTest();
            Assert.assertEquals((Object)("Remote address " + DefaultServer.getDefaultServerAddress().getAddress().getHostAddress() + " Code 200 test-header v2\n"), (Object)new String(Files.readAllBytes(logFileName)));
            logReceiver.rotate();
            logReceiver.awaitWrittenForTest();
            Assert.assertFalse((boolean)Files.exists(logFileName, new LinkOption[0]));
            Path secondLogRotate = logDirectory.resolve("server." + new SimpleDateFormat("yyyy-MM-dd").format(new Date()) + "-1.log");
            Assert.assertEquals((Object)("Remote address " + DefaultServer.getDefaultServerAddress().getAddress().getHostAddress() + " Code 200 test-header v2\n"), (Object)new String(Files.readAllBytes(secondLogRotate)));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

