/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.util.DateUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class DateUtilsTestCase {
    @Test
    public void testParseFirefoxDate() {
        String firefoxHeader = "Mon, 31 Mar 2014 09:24:49 GMT";
        Date firefoxDate = DateUtils.parseDate((String)firefoxHeader);
        Assert.assertNotNull((Object)firefoxDate);
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        calendar.set(2014, 2, 31, 9, 24, 49);
        calendar.set(14, 0);
        Assert.assertEquals((Object)calendar.getTime(), (Object)firefoxDate);
    }

    @Test
    public void testParseChromeDate() {
        String chromeHeader = "Mon, 31 Mar 2014 09:44:00 GMT";
        Date chromeDate = DateUtils.parseDate((String)chromeHeader);
        Assert.assertNotNull((Object)chromeDate);
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        calendar.set(2014, 2, 31, 9, 44, 0);
        calendar.set(14, 0);
        Assert.assertEquals((Object)calendar.getTime(), (Object)chromeDate);
    }

    @Test
    public void testParseIE9Date() {
        String ie9Header = "Wed, 12 Feb 2014 04:43:29 GMT; length=142951";
        Date ie9Date = DateUtils.parseDate((String)ie9Header);
        Assert.assertNotNull((Object)ie9Date);
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        calendar.set(2014, 1, 12, 4, 43, 29);
        calendar.set(14, 0);
        Assert.assertEquals((Object)calendar.getTime(), (Object)ie9Date);
    }

    @Test
    @Ignore(value="This test can fail if the machine pauses/swaps at the wrong time")
    public void testPerformance() {
        String ie9Header = "Wed, 12 Feb 2014 04:43:29 GMT; length=142951";
        long timestamp = System.currentTimeMillis();
        for (int i = 0; i < 1000; ++i) {
            ie9Header.replaceAll(";.*$", "");
        }
        long ts1 = System.currentTimeMillis() - timestamp;
        timestamp = System.currentTimeMillis();
        for (int i = 0; i < 1000; ++i) {
            int index = ie9Header.indexOf(59);
            String string = index >= 0 ? ie9Header.substring(0, index) : ie9Header;
        }
        long ts2 = System.currentTimeMillis() - timestamp;
        Assert.assertTrue((ts2 < ts1 ? 1 : 0) != 0);
    }
}

