/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.extensions;

import io.undertow.Handlers;
import io.undertow.connector.ByteBufferPool;
import io.undertow.server.HttpHandler;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpOneOnly;
import io.undertow.util.StringWriteChannelListener;
import io.undertow.websockets.WebSocketConnectionCallback;
import io.undertow.websockets.WebSocketExtension;
import io.undertow.websockets.WebSocketProtocolHandshakeHandler;
import io.undertow.websockets.client.WebSocketClient;
import io.undertow.websockets.client.WebSocketClientNegotiation;
import io.undertow.websockets.core.AbstractReceiveListener;
import io.undertow.websockets.core.BufferedBinaryMessage;
import io.undertow.websockets.core.BufferedTextMessage;
import io.undertow.websockets.core.StreamSinkFrameChannel;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSocketFrameType;
import io.undertow.websockets.core.WebSocketLogger;
import io.undertow.websockets.core.WebSocketVersion;
import io.undertow.websockets.core.WebSockets;
import io.undertow.websockets.extensions.DebugExtensionsHeaderHandler;
import io.undertow.websockets.extensions.DebugExtensionsListener;
import io.undertow.websockets.extensions.ExtensionHandshake;
import io.undertow.websockets.extensions.PerMessageDeflateHandshake;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.xnio.ChannelListener;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Xnio;
import org.xnio.XnioWorker;
import org.xnio.channels.StreamSinkChannel;

@HttpOneOnly
@RunWith(value=DefaultServer.class)
public class WebSocketExtensionBasicTestCase {
    public static WebSocketProtocolHandshakeHandler webSocketDebugHandler() {
        return new WebSocketProtocolHandshakeHandler(new WebSocketConnectionCallback(){

            public void onConnect(WebSocketHttpExchange exchange, WebSocketChannel channel) {
                WebSocketLogger.EXTENSION_LOGGER.info((Object)"onConnect() ");
                channel.getReceiveSetter().set((ChannelListener)new DebugExtensionsListener());
                channel.resumeReceives();
            }
        });
    }

    @Test
    public void testLongTextMessage() throws Exception {
        Xnio xnio = Xnio.getInstance((ClassLoader)WebSocketExtensionBasicTestCase.class.getClassLoader());
        XnioWorker client = xnio.createWorker(OptionMap.builder().set(Options.WORKER_IO_THREADS, 2).set(Options.CONNECTION_HIGH_WATER, 1000000).set(Options.CONNECTION_LOW_WATER, 1000000).set(Options.WORKER_TASK_CORE_THREADS, 30).set(Options.WORKER_TASK_MAX_THREADS, 30).set(Options.TCP_NODELAY, true).set(Options.CORK, true).getMap());
        WebSocketProtocolHandshakeHandler handler = WebSocketExtensionBasicTestCase.webSocketDebugHandler().addExtension((ExtensionHandshake)new PerMessageDeflateHandshake());
        DebugExtensionsHeaderHandler debug = new DebugExtensionsHeaderHandler((HttpHandler)handler);
        DefaultServer.setRootHandler((HttpHandler)Handlers.path().addPrefixPath("/", (HttpHandler)debug));
        String SEC_WEBSOCKET_EXTENSIONS = "permessage-deflate; client_no_context_takeover; client_max_window_bits";
        List extensionsList = WebSocketExtension.parse((String)"permessage-deflate; client_no_context_takeover; client_max_window_bits");
        WebSocketClientNegotiation negotiation = new WebSocketClientNegotiation(null, extensionsList);
        HashSet<PerMessageDeflateHandshake> extensionHandshakes = new HashSet<PerMessageDeflateHandshake>();
        extensionHandshakes.add(new PerMessageDeflateHandshake(true));
        WebSocketChannel clientChannel = (WebSocketChannel)WebSocketClient.connect((XnioWorker)client, null, (ByteBufferPool)DefaultServer.getBufferPool(), (OptionMap)OptionMap.EMPTY, (URI)new URI(DefaultServer.getDefaultServerURL()), (WebSocketVersion)WebSocketVersion.V13, (WebSocketClientNegotiation)negotiation, extensionHandshakes).get();
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference result = new AtomicReference();
        clientChannel.getReceiveSetter().set((ChannelListener)new AbstractReceiveListener(){

            protected void onFullTextMessage(WebSocketChannel channel, BufferedTextMessage message) throws IOException {
                String data = message.getData();
                WebSocketLogger.ROOT_LOGGER.info((Object)("onFullTextMessage() - Client - Received: " + data.getBytes().length + " bytes."));
                result.set(data);
                latch.countDown();
            }

            protected void onFullCloseMessage(WebSocketChannel channel, BufferedBinaryMessage message) throws IOException {
                message.getData().close();
                WebSocketLogger.ROOT_LOGGER.info((Object)"onFullCloseMessage");
            }

            protected void onError(WebSocketChannel channel, Throwable error) {
                WebSocketLogger.ROOT_LOGGER.info((Object)"onError");
                super.onError(channel, error);
                error.printStackTrace();
                latch.countDown();
            }
        });
        clientChannel.resumeReceives();
        int LONG_MSG = 128000;
        StringBuilder longMsg = new StringBuilder(LONG_MSG);
        for (int i = 0; i < LONG_MSG; ++i) {
            longMsg.append(Integer.toString(i).charAt(0));
        }
        WebSockets.sendTextBlocking((String)longMsg.toString(), (WebSocketChannel)clientChannel);
        latch.await(300L, TimeUnit.SECONDS);
        Assert.assertEquals((Object)longMsg.toString(), result.get());
        clientChannel.sendClose();
        client.shutdown();
    }

    @Test
    @Ignore
    public void testLongMessageWithoutExtensions() throws Exception {
        Xnio xnio = Xnio.getInstance((ClassLoader)WebSocketExtensionBasicTestCase.class.getClassLoader());
        XnioWorker client = xnio.createWorker(OptionMap.builder().set(Options.WORKER_IO_THREADS, 2).set(Options.CONNECTION_HIGH_WATER, 1000000).set(Options.CONNECTION_LOW_WATER, 1000000).set(Options.WORKER_TASK_CORE_THREADS, 30).set(Options.WORKER_TASK_MAX_THREADS, 30).set(Options.TCP_NODELAY, true).set(Options.CORK, true).getMap());
        WebSocketProtocolHandshakeHandler handler = WebSocketExtensionBasicTestCase.webSocketDebugHandler().addExtension((ExtensionHandshake)new PerMessageDeflateHandshake());
        DebugExtensionsHeaderHandler debug = new DebugExtensionsHeaderHandler((HttpHandler)handler);
        DefaultServer.setRootHandler((HttpHandler)Handlers.path().addPrefixPath("/", (HttpHandler)debug));
        WebSocketClientNegotiation negotiation = null;
        WebSocketChannel clientChannel = (WebSocketChannel)WebSocketClient.connect((XnioWorker)client, (ByteBufferPool)DefaultServer.getBufferPool(), (OptionMap)OptionMap.EMPTY, (URI)new URI("http://localhost:8080"), (WebSocketVersion)WebSocketVersion.V13, negotiation).get();
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference result = new AtomicReference();
        clientChannel.getReceiveSetter().set((ChannelListener)new AbstractReceiveListener(){

            protected void onFullTextMessage(WebSocketChannel channel, BufferedTextMessage message) throws IOException {
                String data = message.getData();
                WebSocketLogger.ROOT_LOGGER.info((Object)("onFullTextMessage() - Client - Received: " + data.getBytes().length + " bytes"));
                result.set(data);
                latch.countDown();
            }

            protected void onFullCloseMessage(WebSocketChannel channel, BufferedBinaryMessage message) throws IOException {
                message.getData().close();
                WebSocketLogger.ROOT_LOGGER.info((Object)"onFullCloseMessage");
            }

            protected void onError(WebSocketChannel channel, Throwable error) {
                WebSocketLogger.ROOT_LOGGER.info((Object)"onError");
                super.onError(channel, error);
                error.printStackTrace();
                latch.countDown();
            }
        });
        clientChannel.resumeReceives();
        int LONG_MSG = 76800;
        StringBuilder longMsg = new StringBuilder(LONG_MSG);
        for (int i = 0; i < LONG_MSG; ++i) {
            longMsg.append(new Integer(i).toString().charAt(0));
        }
        StreamSinkFrameChannel sendChannel = clientChannel.send(WebSocketFrameType.TEXT);
        new StringWriteChannelListener(longMsg.toString()).setup((StreamSinkChannel)sendChannel);
        latch.await(10L, TimeUnit.SECONDS);
        Assert.assertEquals((Object)longMsg.toString(), result.get());
        clientChannel.sendClose();
        client.shutdown();
    }

    @Test
    public void testExtensionsHeaders() throws Exception {
        Xnio xnio = Xnio.getInstance((ClassLoader)WebSocketExtensionBasicTestCase.class.getClassLoader());
        XnioWorker client = xnio.createWorker(OptionMap.builder().set(Options.WORKER_IO_THREADS, 2).set(Options.CONNECTION_HIGH_WATER, 1000000).set(Options.CONNECTION_LOW_WATER, 1000000).set(Options.WORKER_TASK_CORE_THREADS, 30).set(Options.WORKER_TASK_MAX_THREADS, 30).set(Options.TCP_NODELAY, true).set(Options.CORK, true).getMap());
        WebSocketProtocolHandshakeHandler handler = WebSocketExtensionBasicTestCase.webSocketDebugHandler().addExtension((ExtensionHandshake)new PerMessageDeflateHandshake());
        DebugExtensionsHeaderHandler debug = new DebugExtensionsHeaderHandler((HttpHandler)handler);
        DefaultServer.setRootHandler((HttpHandler)Handlers.path().addPrefixPath("/", (HttpHandler)debug));
        String SEC_WEBSOCKET_EXTENSIONS = "permessage-deflate; client_no_context_takeover; client_max_window_bits";
        String SEC_WEBSOCKET_EXTENSIONS_EXPECTED = "[permessage-deflate; client_no_context_takeover]";
        List extensions = WebSocketExtension.parse((String)"permessage-deflate; client_no_context_takeover; client_max_window_bits");
        WebSocketClientNegotiation negotiation = new WebSocketClientNegotiation(null, extensions);
        HashSet<PerMessageDeflateHandshake> extensionHandshakes = new HashSet<PerMessageDeflateHandshake>();
        extensionHandshakes.add(new PerMessageDeflateHandshake(true));
        WebSocketChannel clientChannel = (WebSocketChannel)WebSocketClient.connect((XnioWorker)client, null, (ByteBufferPool)DefaultServer.getBufferPool(), (OptionMap)OptionMap.EMPTY, (URI)new URI(DefaultServer.getDefaultServerURL()), (WebSocketVersion)WebSocketVersion.V13, (WebSocketClientNegotiation)negotiation, extensionHandshakes).get();
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference result = new AtomicReference();
        clientChannel.getReceiveSetter().set((ChannelListener)new AbstractReceiveListener(){

            protected void onFullTextMessage(WebSocketChannel channel, BufferedTextMessage message) throws IOException {
                String data = message.getData();
                WebSocketLogger.ROOT_LOGGER.info((Object)("onFullTextMessage - Client - Received: " + data.getBytes().length + " bytes . Data: " + data));
                result.set(data);
                latch.countDown();
            }

            protected void onFullCloseMessage(WebSocketChannel channel, BufferedBinaryMessage message) throws IOException {
                message.getData().close();
                WebSocketLogger.ROOT_LOGGER.info((Object)"onFullCloseMessage");
            }

            protected void onError(WebSocketChannel channel, Throwable error) {
                WebSocketLogger.ROOT_LOGGER.info((Object)"onError");
                super.onError(channel, error);
                error.printStackTrace();
                latch.countDown();
            }
        });
        clientChannel.resumeReceives();
        StreamSinkFrameChannel sendChannel = clientChannel.send(WebSocketFrameType.TEXT);
        new StringWriteChannelListener("Hello, World!").setup((StreamSinkChannel)sendChannel);
        latch.await(10L, TimeUnit.SECONDS);
        Assert.assertEquals((Object)"Hello, World!", result.get());
        clientChannel.sendClose();
        client.shutdown();
        Assert.assertEquals((Object)"[permessage-deflate; client_no_context_takeover]", (Object)debug.getResponseExtensions().toString());
    }
}

