/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.http2;

import io.undertow.protocols.http2.Hpack;
import io.undertow.protocols.http2.HpackDecoder;
import io.undertow.protocols.http2.HpackException;
import io.undertow.util.HeaderMap;
import io.undertow.util.HttpString;
import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Test;

public class HpackSpecExamplesUnitTestCase {
    @Test
    public void testExample_D_2_1() throws HpackException {
        byte[] data = new byte[]{64, 10, 99, 117, 115, 116, 111, 109, 45, 107, 101, 121, 13, 99, 117, 115, 116, 111, 109, 45, 104, 101, 97, 100, 101, 114};
        HpackDecoder decoder = new HpackDecoder(4096);
        HeaderMapEmitter emitter = new HeaderMapEmitter();
        decoder.setHeaderEmitter((HpackDecoder.HeaderEmitter)emitter);
        decoder.decode(ByteBuffer.wrap(data), false);
        Assert.assertEquals((long)1L, (long)emitter.map.size());
        Assert.assertEquals((Object)"custom-header", (Object)emitter.map.getFirst(new HttpString("custom-key")));
        Assert.assertEquals((long)1L, (long)decoder.getFilledTableSlots());
        Assert.assertEquals((long)55L, (long)decoder.getCurrentMemorySize());
        HpackSpecExamplesUnitTestCase.assertTableState(decoder, 1, "custom-key", "custom-header");
    }

    @Test
    public void testExample_D_2_2() throws HpackException {
        byte[] data = new byte[]{4, 12, 47, 115, 97, 109, 112, 108, 101, 47, 112, 97, 116, 104};
        HpackDecoder decoder = new HpackDecoder(4096);
        HeaderMapEmitter emitter = new HeaderMapEmitter();
        decoder.setHeaderEmitter((HpackDecoder.HeaderEmitter)emitter);
        decoder.decode(ByteBuffer.wrap(data), false);
        Assert.assertEquals((long)1L, (long)emitter.map.size());
        Assert.assertEquals((Object)"/sample/path", (Object)emitter.map.getFirst(new HttpString(":path")));
        Assert.assertEquals((long)0L, (long)decoder.getFilledTableSlots());
        Assert.assertEquals((long)0L, (long)decoder.getCurrentMemorySize());
    }

    @Test
    public void testExample_D_2_3() throws HpackException {
        byte[] data = new byte[]{16, 8, 112, 97, 115, 115, 119, 111, 114, 100, 6, 115, 101, 99, 114, 101, 116};
        HpackDecoder decoder = new HpackDecoder(4096);
        HeaderMapEmitter emitter = new HeaderMapEmitter();
        decoder.setHeaderEmitter((HpackDecoder.HeaderEmitter)emitter);
        decoder.decode(ByteBuffer.wrap(data), false);
        Assert.assertEquals((long)1L, (long)emitter.map.size());
        Assert.assertEquals((Object)"secret", (Object)emitter.map.getFirst(new HttpString("password")));
        Assert.assertEquals((long)0L, (long)decoder.getFilledTableSlots());
        Assert.assertEquals((long)0L, (long)decoder.getCurrentMemorySize());
    }

    @Test
    public void testExample_D_2_4() throws HpackException {
        byte[] data = new byte[]{-126};
        HpackDecoder decoder = new HpackDecoder(4096);
        HeaderMapEmitter emitter = new HeaderMapEmitter();
        decoder.setHeaderEmitter((HpackDecoder.HeaderEmitter)emitter);
        decoder.decode(ByteBuffer.wrap(data), false);
        Assert.assertEquals((long)1L, (long)emitter.map.size());
        Assert.assertEquals((Object)"GET", (Object)emitter.map.getFirst(new HttpString(":method")));
        Assert.assertEquals((long)0L, (long)decoder.getFilledTableSlots());
        Assert.assertEquals((long)0L, (long)decoder.getCurrentMemorySize());
    }

    @Test
    public void testExample_D_3() throws HpackException {
        byte[] data = new byte[]{-126, -122, -124, 65, 15, 119, 119, 119, 46, 101, 120, 97, 109, 112, 108, 101, 46, 99, 111, 109};
        HpackDecoder decoder = new HpackDecoder(4096);
        HeaderMapEmitter emitter = new HeaderMapEmitter();
        decoder.setHeaderEmitter((HpackDecoder.HeaderEmitter)emitter);
        decoder.decode(ByteBuffer.wrap(data), false);
        Assert.assertEquals((long)4L, (long)emitter.map.size());
        Assert.assertEquals((Object)"GET", (Object)emitter.map.getFirst(new HttpString(":method")));
        Assert.assertEquals((Object)"http", (Object)emitter.map.getFirst(new HttpString(":scheme")));
        Assert.assertEquals((Object)"/", (Object)emitter.map.getFirst(new HttpString(":path")));
        Assert.assertEquals((Object)"www.example.com", (Object)emitter.map.getFirst(new HttpString(":authority")));
        Assert.assertEquals((long)1L, (long)decoder.getFilledTableSlots());
        Assert.assertEquals((long)57L, (long)decoder.getCurrentMemorySize());
        HpackSpecExamplesUnitTestCase.assertTableState(decoder, 1, ":authority", "www.example.com");
        data = new byte[]{-126, -122, -124, -66, 88, 8, 110, 111, 45, 99, 97, 99, 104, 101};
        emitter = new HeaderMapEmitter();
        decoder.setHeaderEmitter((HpackDecoder.HeaderEmitter)emitter);
        decoder.decode(ByteBuffer.wrap(data), false);
        Assert.assertEquals((long)5L, (long)emitter.map.size());
        Assert.assertEquals((Object)"GET", (Object)emitter.map.getFirst(new HttpString(":method")));
        Assert.assertEquals((Object)"http", (Object)emitter.map.getFirst(new HttpString(":scheme")));
        Assert.assertEquals((Object)"/", (Object)emitter.map.getFirst(new HttpString(":path")));
        Assert.assertEquals((Object)"www.example.com", (Object)emitter.map.getFirst(new HttpString(":authority")));
        Assert.assertEquals((Object)"no-cache", (Object)emitter.map.getFirst(new HttpString("cache-control")));
        Assert.assertEquals((long)2L, (long)decoder.getFilledTableSlots());
        Assert.assertEquals((long)110L, (long)decoder.getCurrentMemorySize());
        HpackSpecExamplesUnitTestCase.assertTableState(decoder, 1, "cache-control", "no-cache");
        HpackSpecExamplesUnitTestCase.assertTableState(decoder, 2, ":authority", "www.example.com");
        data = new byte[]{-126, -121, -123, -65, 64, 10, 99, 117, 115, 116, 111, 109, 45, 107, 101, 121, 12, 99, 117, 115, 116, 111, 109, 45, 118, 97, 108, 117, 101};
        emitter = new HeaderMapEmitter();
        decoder.setHeaderEmitter((HpackDecoder.HeaderEmitter)emitter);
        decoder.decode(ByteBuffer.wrap(data), false);
        Assert.assertEquals((long)5L, (long)emitter.map.size());
        Assert.assertEquals((Object)"GET", (Object)emitter.map.getFirst(new HttpString(":method")));
        Assert.assertEquals((Object)"https", (Object)emitter.map.getFirst(new HttpString(":scheme")));
        Assert.assertEquals((Object)"/index.html", (Object)emitter.map.getFirst(new HttpString(":path")));
        Assert.assertEquals((Object)"www.example.com", (Object)emitter.map.getFirst(new HttpString(":authority")));
        Assert.assertEquals((Object)"custom-value", (Object)emitter.map.getFirst(new HttpString("custom-key")));
        Assert.assertEquals((long)3L, (long)decoder.getFilledTableSlots());
        Assert.assertEquals((long)164L, (long)decoder.getCurrentMemorySize());
        HpackSpecExamplesUnitTestCase.assertTableState(decoder, 1, "custom-key", "custom-value");
        HpackSpecExamplesUnitTestCase.assertTableState(decoder, 2, "cache-control", "no-cache");
        HpackSpecExamplesUnitTestCase.assertTableState(decoder, 3, ":authority", "www.example.com");
    }

    @Test
    public void testExample_D_4() throws HpackException {
        byte[] data = new byte[]{-126, -122, -124, 65, -116, -15, -29, -62, -27, -14, 58, 107, -96, -85, -112, -12, -1};
        HpackDecoder decoder = new HpackDecoder(4096);
        HeaderMapEmitter emitter = new HeaderMapEmitter();
        decoder.setHeaderEmitter((HpackDecoder.HeaderEmitter)emitter);
        decoder.decode(ByteBuffer.wrap(data), false);
        Assert.assertEquals((long)4L, (long)emitter.map.size());
        Assert.assertEquals((Object)"GET", (Object)emitter.map.getFirst(new HttpString(":method")));
        Assert.assertEquals((Object)"http", (Object)emitter.map.getFirst(new HttpString(":scheme")));
        Assert.assertEquals((Object)"/", (Object)emitter.map.getFirst(new HttpString(":path")));
        Assert.assertEquals((Object)"www.example.com", (Object)emitter.map.getFirst(new HttpString(":authority")));
        Assert.assertEquals((long)1L, (long)decoder.getFilledTableSlots());
        Assert.assertEquals((long)57L, (long)decoder.getCurrentMemorySize());
        HpackSpecExamplesUnitTestCase.assertTableState(decoder, 1, ":authority", "www.example.com");
        data = new byte[]{-126, -122, -124, -66, 88, -122, -88, -21, 16, 100, -100, -65};
        emitter = new HeaderMapEmitter();
        decoder.setHeaderEmitter((HpackDecoder.HeaderEmitter)emitter);
        decoder.decode(ByteBuffer.wrap(data), false);
        Assert.assertEquals((long)5L, (long)emitter.map.size());
        Assert.assertEquals((Object)"GET", (Object)emitter.map.getFirst(new HttpString(":method")));
        Assert.assertEquals((Object)"http", (Object)emitter.map.getFirst(new HttpString(":scheme")));
        Assert.assertEquals((Object)"/", (Object)emitter.map.getFirst(new HttpString(":path")));
        Assert.assertEquals((Object)"www.example.com", (Object)emitter.map.getFirst(new HttpString(":authority")));
        Assert.assertEquals((Object)"no-cache", (Object)emitter.map.getFirst(new HttpString("cache-control")));
        Assert.assertEquals((long)2L, (long)decoder.getFilledTableSlots());
        Assert.assertEquals((long)110L, (long)decoder.getCurrentMemorySize());
        HpackSpecExamplesUnitTestCase.assertTableState(decoder, 1, "cache-control", "no-cache");
        HpackSpecExamplesUnitTestCase.assertTableState(decoder, 2, ":authority", "www.example.com");
        data = new byte[]{-126, -121, -123, -65, 64, -120, 37, -88, 73, -23, 91, -87, 125, 127, -119, 37, -88, 73, -23, 91, -72, -24, -76, -65};
        emitter = new HeaderMapEmitter();
        decoder.setHeaderEmitter((HpackDecoder.HeaderEmitter)emitter);
        decoder.decode(ByteBuffer.wrap(data), false);
        Assert.assertEquals((long)5L, (long)emitter.map.size());
        Assert.assertEquals((Object)"GET", (Object)emitter.map.getFirst(new HttpString(":method")));
        Assert.assertEquals((Object)"https", (Object)emitter.map.getFirst(new HttpString(":scheme")));
        Assert.assertEquals((Object)"/index.html", (Object)emitter.map.getFirst(new HttpString(":path")));
        Assert.assertEquals((Object)"www.example.com", (Object)emitter.map.getFirst(new HttpString(":authority")));
        Assert.assertEquals((Object)"custom-value", (Object)emitter.map.getFirst(new HttpString("custom-key")));
        Assert.assertEquals((long)3L, (long)decoder.getFilledTableSlots());
        Assert.assertEquals((long)164L, (long)decoder.getCurrentMemorySize());
        HpackSpecExamplesUnitTestCase.assertTableState(decoder, 1, "custom-key", "custom-value");
        HpackSpecExamplesUnitTestCase.assertTableState(decoder, 2, "cache-control", "no-cache");
        HpackSpecExamplesUnitTestCase.assertTableState(decoder, 3, ":authority", "www.example.com");
    }

    @Test
    public void testExample_D_5() throws HpackException {
        byte[] data = new byte[]{72, 3, 51, 48, 50, 88, 7, 112, 114, 105, 118, 97, 116, 101, 97, 29, 77, 111, 110, 44, 32, 50, 49, 32, 79, 99, 116, 32, 50, 48, 49, 51, 32, 50, 48, 58, 49, 51, 58, 50, 49, 32, 71, 77, 84, 110, 23, 104, 116, 116, 112, 115, 58, 47, 47, 119, 119, 119, 46, 101, 120, 97, 109, 112, 108, 101, 46, 99, 111, 109};
        HpackDecoder decoder = new HpackDecoder(256);
        HeaderMapEmitter emitter = new HeaderMapEmitter();
        decoder.setHeaderEmitter((HpackDecoder.HeaderEmitter)emitter);
        decoder.decode(ByteBuffer.wrap(data), false);
        Assert.assertEquals((long)4L, (long)emitter.map.size());
        Assert.assertEquals((Object)"302", (Object)emitter.map.getFirst(new HttpString(":status")));
        Assert.assertEquals((Object)"private", (Object)emitter.map.getFirst(new HttpString("cache-control")));
        Assert.assertEquals((Object)"Mon, 21 Oct 2013 20:13:21 GMT", (Object)emitter.map.getFirst(new HttpString("date")));
        Assert.assertEquals((Object)"https://www.example.com", (Object)emitter.map.getFirst(new HttpString("location")));
        Assert.assertEquals((long)4L, (long)decoder.getFilledTableSlots());
        Assert.assertEquals((long)222L, (long)decoder.getCurrentMemorySize());
        HpackSpecExamplesUnitTestCase.assertTableState(decoder, 1, "location", "https://www.example.com");
        HpackSpecExamplesUnitTestCase.assertTableState(decoder, 2, "date", "Mon, 21 Oct 2013 20:13:21 GMT");
        HpackSpecExamplesUnitTestCase.assertTableState(decoder, 3, "cache-control", "private");
        HpackSpecExamplesUnitTestCase.assertTableState(decoder, 4, ":status", "302");
        data = new byte[]{72, 3, 51, 48, 55, -63, -64, -65};
        emitter = new HeaderMapEmitter();
        decoder.setHeaderEmitter((HpackDecoder.HeaderEmitter)emitter);
        decoder.decode(ByteBuffer.wrap(data), false);
        Assert.assertEquals((long)4L, (long)emitter.map.size());
        Assert.assertEquals((Object)"307", (Object)emitter.map.getFirst(new HttpString(":status")));
        Assert.assertEquals((Object)"private", (Object)emitter.map.getFirst(new HttpString("cache-control")));
        Assert.assertEquals((Object)"Mon, 21 Oct 2013 20:13:21 GMT", (Object)emitter.map.getFirst(new HttpString("date")));
        Assert.assertEquals((Object)"https://www.example.com", (Object)emitter.map.getFirst(new HttpString("location")));
        Assert.assertEquals((long)4L, (long)decoder.getFilledTableSlots());
        Assert.assertEquals((long)222L, (long)decoder.getCurrentMemorySize());
        HpackSpecExamplesUnitTestCase.assertTableState(decoder, 1, ":status", "307");
        HpackSpecExamplesUnitTestCase.assertTableState(decoder, 2, "location", "https://www.example.com");
        HpackSpecExamplesUnitTestCase.assertTableState(decoder, 3, "date", "Mon, 21 Oct 2013 20:13:21 GMT");
        HpackSpecExamplesUnitTestCase.assertTableState(decoder, 4, "cache-control", "private");
        data = new byte[]{-120, -63, 97, 29, 77, 111, 110, 44, 32, 50, 49, 32, 79, 99, 116, 32, 50, 48, 49, 51, 32, 50, 48, 58, 49, 51, 58, 50, 50, 32, 71, 77, 84, -64, 90, 4, 103, 122, 105, 112, 119, 56, 102, 111, 111, 61, 65, 83, 68, 74, 75, 72, 81, 75, 66, 90, 88, 79, 81, 87, 69, 79, 80, 73, 85, 65, 88, 81, 87, 69, 79, 73, 85, 59, 32, 109, 97, 120, 45, 97, 103, 101, 61, 51, 54, 48, 48, 59, 32, 118, 101, 114, 115, 105, 111, 110, 61, 49};
        emitter = new HeaderMapEmitter();
        decoder.setHeaderEmitter((HpackDecoder.HeaderEmitter)emitter);
        decoder.decode(ByteBuffer.wrap(data), false);
        Assert.assertEquals((long)6L, (long)emitter.map.size());
        Assert.assertEquals((Object)"200", (Object)emitter.map.getFirst(new HttpString(":status")));
        Assert.assertEquals((Object)"private", (Object)emitter.map.getFirst(new HttpString("cache-control")));
        Assert.assertEquals((Object)"Mon, 21 Oct 2013 20:13:22 GMT", (Object)emitter.map.getFirst(new HttpString("date")));
        Assert.assertEquals((Object)"https://www.example.com", (Object)emitter.map.getFirst(new HttpString("location")));
        Assert.assertEquals((Object)"foo=ASDJKHQKBZXOQWEOPIUAXQWEOIU; max-age=3600; version=1", (Object)emitter.map.getFirst(new HttpString("set-cookie")));
        Assert.assertEquals((Object)"gzip", (Object)emitter.map.getFirst(new HttpString("content-encoding")));
        Assert.assertEquals((long)3L, (long)decoder.getFilledTableSlots());
        Assert.assertEquals((long)215L, (long)decoder.getCurrentMemorySize());
        HpackSpecExamplesUnitTestCase.assertTableState(decoder, 1, "set-cookie", "foo=ASDJKHQKBZXOQWEOPIUAXQWEOIU; max-age=3600; version=1");
        HpackSpecExamplesUnitTestCase.assertTableState(decoder, 2, "content-encoding", "gzip");
        HpackSpecExamplesUnitTestCase.assertTableState(decoder, 3, "date", "Mon, 21 Oct 2013 20:13:22 GMT");
    }

    @Test
    public void testExample_D_6() throws HpackException {
        byte[] data = new byte[]{72, -126, 100, 2, 88, -123, -82, -61, 119, 26, 75, 97, -106, -48, 122, -66, -108, 16, 84, -44, 68, -88, 32, 5, -107, 4, 11, -127, 102, -32, -126, -90, 45, 27, -1, 110, -111, -99, 41, -83, 23, 24, 99, -57, -113, 11, -105, -56, -23, -82, -126, -82, 67, -45};
        HpackDecoder decoder = new HpackDecoder(256);
        HeaderMapEmitter emitter = new HeaderMapEmitter();
        decoder.setHeaderEmitter((HpackDecoder.HeaderEmitter)emitter);
        decoder.decode(ByteBuffer.wrap(data), false);
        Assert.assertEquals((long)4L, (long)emitter.map.size());
        Assert.assertEquals((Object)"302", (Object)emitter.map.getFirst(new HttpString(":status")));
        Assert.assertEquals((Object)"private", (Object)emitter.map.getFirst(new HttpString("cache-control")));
        Assert.assertEquals((Object)"Mon, 21 Oct 2013 20:13:21 GMT", (Object)emitter.map.getFirst(new HttpString("date")));
        Assert.assertEquals((Object)"https://www.example.com", (Object)emitter.map.getFirst(new HttpString("location")));
        Assert.assertEquals((long)4L, (long)decoder.getFilledTableSlots());
        Assert.assertEquals((long)222L, (long)decoder.getCurrentMemorySize());
        HpackSpecExamplesUnitTestCase.assertTableState(decoder, 1, "location", "https://www.example.com");
        HpackSpecExamplesUnitTestCase.assertTableState(decoder, 2, "date", "Mon, 21 Oct 2013 20:13:21 GMT");
        HpackSpecExamplesUnitTestCase.assertTableState(decoder, 3, "cache-control", "private");
        HpackSpecExamplesUnitTestCase.assertTableState(decoder, 4, ":status", "302");
        data = new byte[]{72, -125, 100, 14, -1, -63, -64, -65};
        emitter = new HeaderMapEmitter();
        decoder.setHeaderEmitter((HpackDecoder.HeaderEmitter)emitter);
        decoder.decode(ByteBuffer.wrap(data), false);
        Assert.assertEquals((long)4L, (long)emitter.map.size());
        Assert.assertEquals((Object)"307", (Object)emitter.map.getFirst(new HttpString(":status")));
        Assert.assertEquals((Object)"private", (Object)emitter.map.getFirst(new HttpString("cache-control")));
        Assert.assertEquals((Object)"Mon, 21 Oct 2013 20:13:21 GMT", (Object)emitter.map.getFirst(new HttpString("date")));
        Assert.assertEquals((Object)"https://www.example.com", (Object)emitter.map.getFirst(new HttpString("location")));
        Assert.assertEquals((long)4L, (long)decoder.getFilledTableSlots());
        Assert.assertEquals((long)222L, (long)decoder.getCurrentMemorySize());
        HpackSpecExamplesUnitTestCase.assertTableState(decoder, 1, ":status", "307");
        HpackSpecExamplesUnitTestCase.assertTableState(decoder, 2, "location", "https://www.example.com");
        HpackSpecExamplesUnitTestCase.assertTableState(decoder, 3, "date", "Mon, 21 Oct 2013 20:13:21 GMT");
        HpackSpecExamplesUnitTestCase.assertTableState(decoder, 4, "cache-control", "private");
        data = new byte[]{-120, -63, 97, -106, -48, 122, -66, -108, 16, 84, -44, 68, -88, 32, 5, -107, 4, 11, -127, 102, -32, -124, -90, 45, 27, -1, -64, 90, -125, -101, -39, -85, 119, -83, -108, -25, -126, 29, -41, -14, -26, -57, -77, 53, -33, -33, -51, 91, 57, 96, -43, -81, 39, 8, 127, 54, 114, -63, -85, 39, 15, -75, 41, 31, -107, -121, 49, 96, 101, -64, 3, -19, 78, -27, -79, 6, 61, 80, 7};
        emitter = new HeaderMapEmitter();
        decoder.setHeaderEmitter((HpackDecoder.HeaderEmitter)emitter);
        decoder.decode(ByteBuffer.wrap(data), false);
        Assert.assertEquals((long)6L, (long)emitter.map.size());
        Assert.assertEquals((Object)"200", (Object)emitter.map.getFirst(new HttpString(":status")));
        Assert.assertEquals((Object)"private", (Object)emitter.map.getFirst(new HttpString("cache-control")));
        Assert.assertEquals((Object)"Mon, 21 Oct 2013 20:13:22 GMT", (Object)emitter.map.getFirst(new HttpString("date")));
        Assert.assertEquals((Object)"https://www.example.com", (Object)emitter.map.getFirst(new HttpString("location")));
        Assert.assertEquals((Object)"foo=ASDJKHQKBZXOQWEOPIUAXQWEOIU; max-age=3600; version=1", (Object)emitter.map.getFirst(new HttpString("set-cookie")));
        Assert.assertEquals((Object)"gzip", (Object)emitter.map.getFirst(new HttpString("content-encoding")));
        Assert.assertEquals((long)3L, (long)decoder.getFilledTableSlots());
        Assert.assertEquals((long)215L, (long)decoder.getCurrentMemorySize());
        HpackSpecExamplesUnitTestCase.assertTableState(decoder, 1, "set-cookie", "foo=ASDJKHQKBZXOQWEOPIUAXQWEOIU; max-age=3600; version=1");
        HpackSpecExamplesUnitTestCase.assertTableState(decoder, 2, "content-encoding", "gzip");
        HpackSpecExamplesUnitTestCase.assertTableState(decoder, 3, "date", "Mon, 21 Oct 2013 20:13:22 GMT");
    }

    @Test
    public void testExample_D_2_110() throws HpackException {
        byte[] data = new byte[]{0};
        HpackDecoder decoder = new HpackDecoder(4096);
        HeaderMapEmitter emitter = new HeaderMapEmitter();
        decoder.setHeaderEmitter((HpackDecoder.HeaderEmitter)emitter);
        try {
            decoder.decode(ByteBuffer.wrap(data), false);
        }
        catch (HpackException e) {
            return;
        }
        Assert.fail((String)"Didn't get expected HPackException!");
    }

    @Test
    public void testExample_D_2_111() throws HpackException {
        byte[] data = new byte[]{96, 1, 120, 1};
        HpackDecoder decoder = new HpackDecoder(4096);
        HeaderMapEmitter emitter = new HeaderMapEmitter();
        decoder.setHeaderEmitter((HpackDecoder.HeaderEmitter)emitter);
        try {
            decoder.decode(ByteBuffer.wrap(data), false);
        }
        catch (HpackException e) {
            return;
        }
        Assert.fail((String)"Didn't get expected HPackException!");
    }

    @Test
    public void testExample_D_2_112() throws HpackException {
        byte[] data = new byte[]{96, 2, 120};
        HpackDecoder decoder = new HpackDecoder(4096);
        HeaderMapEmitter emitter = new HeaderMapEmitter();
        decoder.setHeaderEmitter((HpackDecoder.HeaderEmitter)emitter);
        try {
            decoder.decode(ByteBuffer.wrap(data), false);
        }
        catch (HpackException e) {
            return;
        }
        Assert.fail((String)"Didn't get expected HPackException!");
    }

    private static void assertTableState(HpackDecoder decoder, int index, String name, String value) {
        int idx = decoder.getRealIndex(index);
        Hpack.HeaderField val = decoder.getHeaderTable()[idx];
        Assert.assertEquals((Object)name, (Object)val.name.toString());
        Assert.assertEquals((Object)value, (Object)val.value);
    }

    private static class HeaderMapEmitter
    implements HpackDecoder.HeaderEmitter {
        HeaderMap map = new HeaderMap();

        private HeaderMapEmitter() {
        }

        public void emitHeader(HttpString name, String value, boolean neverIndex) {
            this.map.add(name, value);
        }
    }
}

