/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ByteRangeHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.cache.DirectBufferCache;
import io.undertow.server.handlers.resource.CachingResourceManager;
import io.undertow.server.handlers.resource.PathResourceManager;
import io.undertow.server.handlers.resource.ResourceHandler;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.TestHttpClient;
import io.undertow.util.DateUtils;
import io.undertow.util.Headers;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class RangeRequestTestCase {
    @BeforeClass
    public static void setup() throws URISyntaxException {
        Path rootPath = Paths.get(RangeRequestTestCase.class.getResource("range.txt").toURI()).getParent();
        PathHandler path = Handlers.path();
        path.addPrefixPath("/path", (HttpHandler)new ByteRangeHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                exchange.getResponseHeaders().put(Headers.LAST_MODIFIED, DateUtils.toDateString((Date)new Date(10000L)));
                exchange.getResponseHeaders().put(Headers.ETAG, "\"someetag\"");
                exchange.getResponseSender().send("0123456789");
            }
        }, true));
        path.addPrefixPath("/resource", (HttpHandler)new ResourceHandler((ResourceManager)new PathResourceManager(rootPath, 0xA00000L)).setDirectoryListingEnabled(true));
        path.addPrefixPath("/cachedresource", (HttpHandler)new ResourceHandler((ResourceManager)new CachingResourceManager(1000, 1000000L, new DirectBufferCache(1000, 10, 10000), (ResourceManager)new PathResourceManager(rootPath, 0xA00000L), -1)).setDirectoryListingEnabled(true));
        DefaultServer.setRootHandler((HttpHandler)path);
    }

    @Test
    public void testGenericRangeHandler() throws IOException, InterruptedException {
        this.runTest("/path", true);
    }

    @Test
    public void testResourceHandler() throws IOException, InterruptedException {
        this.runTest("/resource/range.txt", false);
    }

    @Test
    public void testCachedResourceHandler() throws IOException, InterruptedException {
        this.runTest("/cachedresource/range.txt", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTest(String path, boolean etag) throws IOException, InterruptedException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + path);
            get.addHeader("Range", "bytes=2-3");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)206L, (long)result.getStatusLine().getStatusCode());
            String response = EntityUtils.toString((HttpEntity)result.getEntity());
            Assert.assertEquals((Object)"23", (Object)response);
            Assert.assertEquals((Object)"bytes 2-3/10", (Object)result.getFirstHeader("Content-Range").getValue());
            get = new HttpGet(DefaultServer.getDefaultServerURL() + path);
            get.addHeader("Range", "bytes=0-0");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)206L, (long)result.getStatusLine().getStatusCode());
            response = EntityUtils.toString((HttpEntity)result.getEntity());
            Assert.assertEquals((Object)"0", (Object)response);
            Assert.assertEquals((Object)"bytes 0-0/10", (Object)result.getFirstHeader("Content-Range").getValue());
            get = new HttpGet(DefaultServer.getDefaultServerURL() + path);
            get.addHeader("Range", "bytes=1-");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)206L, (long)result.getStatusLine().getStatusCode());
            response = EntityUtils.toString((HttpEntity)result.getEntity());
            Assert.assertEquals((Object)"123456789", (Object)response);
            Assert.assertEquals((Object)"bytes 1-9/10", (Object)result.getFirstHeader("Content-Range").getValue());
            get = new HttpGet(DefaultServer.getDefaultServerURL() + path);
            get.addHeader("Range", "bytes=0-");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)206L, (long)result.getStatusLine().getStatusCode());
            response = EntityUtils.toString((HttpEntity)result.getEntity());
            Assert.assertEquals((Object)"0123456789", (Object)response);
            Assert.assertEquals((Object)"bytes 0-9/10", (Object)result.getFirstHeader("Content-Range").getValue());
            get = new HttpGet(DefaultServer.getDefaultServerURL() + path);
            get.addHeader("Range", "bytes=9-");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)206L, (long)result.getStatusLine().getStatusCode());
            response = EntityUtils.toString((HttpEntity)result.getEntity());
            Assert.assertEquals((Object)"9", (Object)response);
            Assert.assertEquals((Object)"bytes 9-9/10", (Object)result.getFirstHeader("Content-Range").getValue());
            get = new HttpGet(DefaultServer.getDefaultServerURL() + path);
            get.addHeader("Range", "bytes=-1");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)206L, (long)result.getStatusLine().getStatusCode());
            response = EntityUtils.toString((HttpEntity)result.getEntity());
            Assert.assertEquals((Object)"9", (Object)response);
            Assert.assertEquals((Object)"bytes 9-9/10", (Object)result.getFirstHeader("Content-Range").getValue());
            get = new HttpGet(DefaultServer.getDefaultServerURL() + path);
            get.addHeader("Range", "bytes=99-100");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)416L, (long)result.getStatusLine().getStatusCode());
            response = EntityUtils.toString((HttpEntity)result.getEntity());
            Assert.assertEquals((Object)"", (Object)response);
            Assert.assertEquals((Object)"bytes */10", (Object)result.getFirstHeader("Content-Range").getValue());
            get = new HttpGet(DefaultServer.getDefaultServerURL() + path);
            get = new HttpGet(DefaultServer.getDefaultServerURL() + path);
            get.addHeader("Range", "bytes=2-1");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)416L, (long)result.getStatusLine().getStatusCode());
            response = EntityUtils.toString((HttpEntity)result.getEntity());
            Assert.assertEquals((Object)"", (Object)response);
            Assert.assertEquals((Object)"bytes */10", (Object)result.getFirstHeader("Content-Range").getValue());
            get = new HttpGet(DefaultServer.getDefaultServerURL() + path);
            get.addHeader("Range", "bytes=2-3");
            get.addHeader("If-Range", DateUtils.toDateString((Date)new Date(System.currentTimeMillis() + 1000L)));
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)206L, (long)result.getStatusLine().getStatusCode());
            response = EntityUtils.toString((HttpEntity)result.getEntity());
            Assert.assertEquals((Object)"23", (Object)response);
            Assert.assertEquals((Object)"bytes 2-3/10", (Object)result.getFirstHeader("Content-Range").getValue());
            get = new HttpGet(DefaultServer.getDefaultServerURL() + path);
            get.addHeader("Range", "bytes=2-3");
            get.addHeader("If-Range", DateUtils.toDateString((Date)new Date(0L)));
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = EntityUtils.toString((HttpEntity)result.getEntity());
            Assert.assertEquals((Object)"0123456789", (Object)response);
            Assert.assertNull((Object)result.getFirstHeader("Content-Range"));
            if (etag) {
                get = new HttpGet(DefaultServer.getDefaultServerURL() + path);
                get.addHeader("Range", "bytes=2-3");
                get.addHeader("If-Range", "\"someetag\"");
                result = client.execute((HttpUriRequest)get);
                Assert.assertEquals((long)206L, (long)result.getStatusLine().getStatusCode());
                response = EntityUtils.toString((HttpEntity)result.getEntity());
                Assert.assertEquals((Object)"23", (Object)response);
                Assert.assertEquals((Object)"bytes 2-3/10", (Object)result.getFirstHeader("Content-Range").getValue());
                get = new HttpGet(DefaultServer.getDefaultServerURL() + path);
                get.addHeader("Range", "bytes=2-3");
                get.addHeader("If-Range", "\"otheretag\"");
                result = client.execute((HttpUriRequest)get);
                Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
                response = EntityUtils.toString((HttpEntity)result.getEntity());
                Assert.assertEquals((Object)"0123456789", (Object)response);
                Assert.assertNull((Object)result.getFirstHeader("Content-Range"));
            }
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

