/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.security;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.AuthenticationMode;
import io.undertow.security.api.NotificationReceiver;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.api.SecurityNotification;
import io.undertow.security.handlers.AuthenticationCallHandler;
import io.undertow.security.handlers.AuthenticationConstraintHandler;
import io.undertow.security.handlers.AuthenticationMechanismsHandler;
import io.undertow.security.handlers.NotificationReceiverHandler;
import io.undertow.security.handlers.SecurityInitialHandler;
import io.undertow.security.idm.Account;
import io.undertow.security.idm.Credential;
import io.undertow.security.idm.DigestCredential;
import io.undertow.security.idm.GSSContextCredential;
import io.undertow.security.idm.IdentityManager;
import io.undertow.security.idm.PasswordCredential;
import io.undertow.security.idm.X509CertificateCredential;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.TestHttpClient;
import io.undertow.util.HeaderMap;
import io.undertow.util.HexConverter;
import io.undertow.util.HttpString;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.ietf.jgss.GSSException;
import org.junit.Assert;
import org.junit.Test;

public abstract class AuthenticationTestBase {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    protected static final IdentityManager identityManager;
    protected static final AuditReceiver auditReceiver;

    protected void setAuthenticationChain() {
        ResponseHandler current = new ResponseHandler();
        current = new AuthenticationCallHandler((HttpHandler)current);
        current = new AuthenticationConstraintHandler((HttpHandler)current);
        current = new AuthenticationMechanismsHandler((HttpHandler)current, this.getTestMechanisms());
        auditReceiver.takeNotifications();
        current = new NotificationReceiverHandler((HttpHandler)current, Collections.singleton(auditReceiver));
        current = new SecurityInitialHandler(AuthenticationMode.PRO_ACTIVE, identityManager, (HttpHandler)current);
        DefaultServer.setRootHandler(current);
    }

    protected abstract List<AuthenticationMechanism> getTestMechanisms();

    @Test
    public void testNoMechanisms() throws Exception {
        DefaultServer.setRootHandler(new ResponseHandler());
        TestHttpClient client = new TestHttpClient();
        HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL());
        HttpResponse result = client.execute((HttpUriRequest)get);
        Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
        Header[] values = result.getHeaders("ProcessedBy");
        Assert.assertEquals((long)1L, (long)values.length);
        Assert.assertEquals((Object)"ResponseHandler", (Object)values[0].getValue());
    }

    protected static void assertSingleNotificationType(SecurityNotification.EventType eventType) {
        List<SecurityNotification> notifications = auditReceiver.takeNotifications();
        Assert.assertEquals((String)"A single notification is expected.", (long)1L, (long)notifications.size());
        Assert.assertEquals((String)"Expected EventType not matched.", (Object)eventType, (Object)notifications.get(0).getEventType());
    }

    protected static void assertNotifiactions(SecurityNotification.EventType ... eventTypes) {
        List<SecurityNotification> notifications = auditReceiver.takeNotifications();
        Assert.assertEquals((String)"A single notification is expected.", (long)eventTypes.length, (long)notifications.size());
        ArrayList<SecurityNotification.EventType> types = new ArrayList<SecurityNotification.EventType>();
        for (SecurityNotification i : notifications) {
            types.add(i.getEventType());
        }
        Assert.assertEquals((String)"Expected EventType not matched.", Arrays.asList(eventTypes), types);
    }

    protected static String getAuthenticatedUser(HttpServerExchange exchange) {
        Account account;
        SecurityContext context = exchange.getSecurityContext();
        if (context != null && (account = context.getAuthenticatedAccount()) != null) {
            return account.getPrincipal().getName();
        }
        return null;
    }

    protected static String getAuthHeader(HttpString prefix, Header[] values) {
        for (Header current : values) {
            String currentValue = current.getValue();
            if (!currentValue.startsWith(prefix.toString())) continue;
            return currentValue;
        }
        Assert.fail((String)"Expected header not found.");
        return null;
    }

    static {
        auditReceiver = new AuditReceiver();
        final HashSet<String> certUsers = new HashSet<String>();
        certUsers.add("CN=Test Client,OU=OU,O=Org,L=City,ST=State,C=GB");
        final HashSet<String> gssApiUsers = new HashSet<String>();
        gssApiUsers.add("jduke@UNDERTOW.IO");
        final HashMap<String, char[]> passwordUsers = new HashMap<String, char[]>(2);
        passwordUsers.put("userOne", "passwordOne".toCharArray());
        passwordUsers.put("userTwo", "passwordTwo".toCharArray());
        passwordUsers.put("encodingUser", "password-\u00fc".toCharArray());
        identityManager = new IdentityManager(){

            public Account verify(Account account) {
                return account;
            }

            public Account verify(String id, Credential credential) {
                Account account = this.getAccount(id);
                if (account != null && this.verifyCredential(account, credential)) {
                    return account;
                }
                return null;
            }

            public Account verify(Credential credential) {
                if (credential instanceof X509CertificateCredential) {
                    final X500Principal p = ((X509CertificateCredential)credential).getCertificate().getSubjectX500Principal();
                    if (certUsers.contains(p.getName())) {
                        return new Account(){

                            public Principal getPrincipal() {
                                return p;
                            }

                            public Set<String> getRoles() {
                                return Collections.emptySet();
                            }
                        };
                    }
                } else if (credential instanceof GSSContextCredential) {
                    try {
                        GSSContextCredential gssCredential = (GSSContextCredential)credential;
                        final String name = gssCredential.getGssContext().getSrcName().toString();
                        if (gssApiUsers.contains(name)) {
                            return new Account(){
                                private final Principal principal = new Principal(){

                                    @Override
                                    public String getName() {
                                        return name;
                                    }
                                };

                                public Principal getPrincipal() {
                                    return this.principal;
                                }

                                public Set<String> getRoles() {
                                    return Collections.emptySet();
                                }
                            };
                        }
                    }
                    catch (GSSException e) {
                        throw new RuntimeException(e);
                    }
                }
                return null;
            }

            private boolean verifyCredential(Account account, Credential credential) {
                if (credential instanceof PasswordCredential) {
                    char[] password = ((PasswordCredential)credential).getPassword();
                    char[] expectedPassword = (char[])passwordUsers.get(account.getPrincipal().getName());
                    return Arrays.equals(password, expectedPassword);
                }
                if (credential instanceof DigestCredential) {
                    DigestCredential digCred = (DigestCredential)credential;
                    MessageDigest digest = null;
                    try {
                        digest = digCred.getAlgorithm().getMessageDigest();
                        digest.update(account.getPrincipal().getName().getBytes(UTF_8));
                        digest.update((byte)58);
                        digest.update(digCred.getRealm().getBytes(UTF_8));
                        digest.update((byte)58);
                        char[] expectedPassword = (char[])passwordUsers.get(account.getPrincipal().getName());
                        digest.update(new String(expectedPassword).getBytes(UTF_8));
                        boolean bl = digCred.verifyHA1(HexConverter.convertToHexBytes((byte[])digest.digest()));
                        return bl;
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new IllegalStateException("Unsupported Algorithm", e);
                    }
                    finally {
                        digest.reset();
                    }
                }
                throw new IllegalArgumentException("Invalid Credential Type " + credential.getClass().getName());
            }

            private Account getAccount(final String id) {
                if (passwordUsers.containsKey(id)) {
                    return new Account(){
                        private final Principal principal = new Principal(){

                            @Override
                            public String getName() {
                                return id;
                            }
                        };

                        public Principal getPrincipal() {
                            return this.principal;
                        }

                        public Set<String> getRoles() {
                            return Collections.emptySet();
                        }
                    };
                }
                return null;
            }
        };
    }

    protected static class AuditReceiver
    implements NotificationReceiver {
        private final List<SecurityNotification> receivedNotifications = new ArrayList<SecurityNotification>();

        protected AuditReceiver() {
        }

        public void handleNotification(SecurityNotification notification) {
            this.receivedNotifications.add(notification);
        }

        public List<SecurityNotification> takeNotifications() {
            try {
                ArrayList<SecurityNotification> arrayList = new ArrayList<SecurityNotification>(this.receivedNotifications);
                return arrayList;
            }
            finally {
                this.receivedNotifications.clear();
            }
        }
    }

    protected static class ResponseHandler
    implements HttpHandler {
        static final HttpString PROCESSED_BY = new HttpString("ProcessedBy");
        static final HttpString AUTHENTICATED_USER = new HttpString("AuthenticatedUser");

        protected ResponseHandler() {
        }

        public void handleRequest(HttpServerExchange exchange) throws Exception {
            HeaderMap responseHeader = exchange.getResponseHeaders();
            responseHeader.add(PROCESSED_BY, "ResponseHandler");
            String user = AuthenticationTestBase.getAuthenticatedUser(exchange);
            if (user != null) {
                responseHeader.add(AUTHENTICATED_USER, user);
            }
            if (exchange.getQueryParameters().get("logout") != null) {
                exchange.getSecurityContext().logout();
            }
            exchange.endExchange();
        }
    }
}

