/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.core;

import io.undertow.UndertowMessages;
import io.undertow.websockets.core.StreamSinkFrameChannel;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import org.xnio.channels.Channels;
import org.xnio.channels.SuspendableWriteChannel;

public final class BinaryOutputStream
extends OutputStream {
    private final StreamSinkFrameChannel sender;
    private boolean closed;

    public BinaryOutputStream(StreamSinkFrameChannel sender) {
        this.sender = sender;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.checkClosed();
        Channels.writeBlocking((WritableByteChannel)((Object)this.sender), (ByteBuffer)ByteBuffer.wrap(b, off, len));
    }

    @Override
    public void write(int b) throws IOException {
        this.checkClosed();
        Channels.writeBlocking((WritableByteChannel)((Object)this.sender), (ByteBuffer)ByteBuffer.wrap(new byte[]{(byte)b}));
    }

    @Override
    public void flush() throws IOException {
        this.checkClosed();
        this.sender.flush();
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.sender.shutdownWrites();
            Channels.flushBlocking((SuspendableWriteChannel)this.sender);
        }
    }

    private void checkClosed() throws IOException {
        if (this.closed) {
            throw UndertowMessages.MESSAGES.streamIsClosed();
        }
    }
}

