/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.UndertowOptions;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.BlockingHandler;
import io.undertow.testutils.AjpIgnore;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.TestHttpClient;
import io.undertow.util.HttpString;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Deque;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.xnio.Option;
import org.xnio.OptionMap;

@RunWith(value=DefaultServer.class)
@AjpIgnore(apacheOnly=true)
public class LotsOfQueryParametersTestCase {
    private static final String QUERY = "QUERY";
    private static final String MESSAGE = "Hello Query";
    private static final int DEFAULT_MAX_PARAMETERS = 1000;
    private static final int TEST_MAX_PARAMETERS = 10;

    @BeforeClass
    public static void setup() {
        BlockingHandler blockingHandler = new BlockingHandler();
        DefaultServer.setRootHandler((HttpHandler)blockingHandler);
        blockingHandler.setRootHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) {
                for (Map.Entry entry : exchange.getQueryParameters().entrySet()) {
                    exchange.getResponseHeaders().put(HttpString.tryFromString((String)((String)entry.getKey())), (String)((Deque)entry.getValue()).getFirst());
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @AjpIgnore
    public void testLotsOfQueryParameters_Default_Ok() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            StringBuilder qs = new StringBuilder();
            for (int i = 0; i < 1000; ++i) {
                qs.append(QUERY + i);
                qs.append("=");
                qs.append(URLEncoder.encode(MESSAGE + i, "UTF-8"));
                qs.append("&");
            }
            qs.deleteCharAt(qs.length() - 1);
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path?" + qs.toString());
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            for (int i = 0; i < 1000; ++i) {
                Header[] header = result.getHeaders(QUERY + i);
                Assert.assertEquals((Object)(MESSAGE + i), (Object)header[0].getValue());
            }
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLotsOfQueryParameters_Default_BadRequest() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            StringBuilder qs = new StringBuilder();
            for (int i = 0; i < 1001; ++i) {
                qs.append(QUERY + i);
                qs.append("=");
                qs.append(URLEncoder.encode(MESSAGE + i, "UTF-8"));
                qs.append("&");
            }
            qs.deleteCharAt(qs.length() - 1);
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path?" + qs.toString());
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)400L, (long)result.getStatusLine().getStatusCode());
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @AjpIgnore
    public void testLotsOfQueryParameters_MaxParameters_Ok() throws IOException {
        OptionMap existing = DefaultServer.getUndertowOptions();
        TestHttpClient client = new TestHttpClient();
        try {
            StringBuilder qs = new StringBuilder();
            for (int i = 0; i < 10; ++i) {
                qs.append(QUERY + i);
                qs.append("=");
                qs.append(URLEncoder.encode(MESSAGE + i, "UTF-8"));
                qs.append("&");
            }
            qs.deleteCharAt(qs.length() - 1);
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path?" + qs.toString());
            DefaultServer.setUndertowOptions(OptionMap.create((Option)UndertowOptions.MAX_PARAMETERS, (Object)10));
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            for (int i = 0; i < 10; ++i) {
                Header[] header = result.getHeaders(QUERY + i);
                Assert.assertEquals((Object)(MESSAGE + i), (Object)header[0].getValue());
            }
        }
        finally {
            DefaultServer.setUndertowOptions(existing);
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @AjpIgnore
    public void testLotsOfQueryParameters_MaxParameters_BadRequest() throws IOException {
        OptionMap existing = DefaultServer.getUndertowOptions();
        TestHttpClient client = new TestHttpClient();
        try {
            StringBuilder qs = new StringBuilder();
            for (int i = 0; i < 11; ++i) {
                qs.append(QUERY + i);
                qs.append("=");
                qs.append(URLEncoder.encode(MESSAGE + i, "UTF-8"));
                qs.append("&");
            }
            qs.deleteCharAt(qs.length() - 1);
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path?" + qs.toString());
            DefaultServer.setUndertowOptions(OptionMap.create((Option)UndertowOptions.MAX_PARAMETERS, (Object)10));
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)400L, (long)result.getStatusLine().getStatusCode());
        }
        finally {
            DefaultServer.setUndertowOptions(existing);
            client.getConnectionManager().shutdown();
        }
    }
}

