/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.file;

import io.undertow.server.handlers.resource.PathResourceManager;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.testutils.category.UnitTest;
import io.undertow.util.ETag;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={UnitTest.class})
public class PathResourceManagerTestCase {
    @Test
    public void testGetResource() throws Exception {
        Path rootPath = Paths.get(this.getClass().getResource("page.html").toURI()).getParent();
        PathResourceManager resourceManager = new PathResourceManager(rootPath, 0x100000L);
        Assert.assertNotNull((Object)resourceManager.getResource("page.html"));
        Assert.assertNotNull((Object)resourceManager.getResource("./page.html"));
        Assert.assertNotNull((Object)resourceManager.getResource("../file/page.html"));
    }

    @Test
    public void testCantEscapeRoot() throws Exception {
        Path rootPath = Paths.get(this.getClass().getResource("page.html").toURI()).getParent().resolve("subdir");
        PathResourceManager resourceManager = new PathResourceManager(rootPath, 0x100000L);
        Assert.assertNotNull((Object)resourceManager.getResource("a.txt"));
        Assert.assertNull((Object)resourceManager.getResource("../page.html"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBaseDirInSymlink() throws Exception {
        Assume.assumeFalse((boolean)System.getProperty("os.name").toLowerCase().contains("windows"));
        Path filePath = Paths.get(this.getClass().getResource("page.html").toURI());
        Path rootPath = filePath.getParent();
        Path newDir = rootPath.resolve("newDir");
        Path innerPage = newDir.resolve("page.html");
        Path newSymlink = rootPath.resolve("newSymlink");
        try {
            Files.createDirectories(newDir, new FileAttribute[0]);
            Files.copy(filePath, innerPage, new CopyOption[0]);
            Files.createSymbolicLink(newSymlink, newDir, new FileAttribute[0]);
            Assert.assertTrue((String)"Ensure that newSymlink is still a symlink as expected", (boolean)Files.isSymbolicLink(newSymlink));
            PathResourceManager resourceManager = new PathResourceManager(newSymlink, 0x100000L);
            Assert.assertNotNull((Object)resourceManager.getResource("page.html"));
            Assert.assertNull((Object)resourceManager.getResource("Page.html"));
            Assert.assertNotNull((Object)resourceManager.getResource("./page.html"));
        }
        finally {
            Files.deleteIfExists(newSymlink);
            Files.deleteIfExists(innerPage);
            Files.deleteIfExists(newDir);
            Files.deleteIfExists(newDir);
        }
    }

    @Test
    public void testETagFunction() throws Exception {
        String fileName = "page.html";
        Path rootPath = Paths.get(this.getClass().getResource("page.html").toURI()).getParent();
        ResourceManager resourceManager = PathResourceManager.builder().setBase(rootPath).setETagFunction(new PathResourceManager.ETagFunction(){

            public ETag generate(Path path) {
                return new ETag(true, path.getFileName().toString());
            }
        }).build();
        ETag expected = new ETag(true, "page.html");
        ETag actual = resourceManager.getResource("page.html").getETag();
        Assert.assertEquals((Object)expected, (Object)actual);
    }
}

