/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.proxy;

import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.proxy.ProxyClient;
import io.undertow.server.handlers.proxy.ProxyHandler;
import io.undertow.server.handlers.proxy.SimpleProxyClientProvider;
import io.undertow.testutils.TestHttpClient;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.URI;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class ProxyPathHandlingTest {
    private final TargetServer targetServer = new TargetServer();
    private final ProxyServer proxyServer;

    public ProxyPathHandlingTest() {
        this.proxyServer = new ProxyServer(this.targetServer.uri);
    }

    @After
    public void cleanup() {
        this.targetServer.stop();
        this.proxyServer.stop();
    }

    @Test
    public void prefixRootToRoot() throws Exception {
        this.proxyServer.proxyPrefixPath("/", "/");
        this.isProxied("", "/");
        this.isProxied("/", "/");
        this.isProxied("/foo", "/foo");
    }

    @Test
    public void prefixRootToPath() throws Exception {
        this.proxyServer.proxyPrefixPath("/", "/path");
        this.isProxied("", "/path/");
        this.isProxied("/", "/path/");
        this.isProxied("/foo", "/path/foo");
    }

    @Test
    public void prefixPathToPath() throws Exception {
        this.proxyServer.proxyPrefixPath("/path", "/path");
        this.isProxied("/path", "/path");
        this.isProxied("/path/", "/path/");
        this.isProxied("/path/foo", "/path/foo");
        this.isNotProxied("");
        this.isNotProxied("/");
        this.isNotProxied("/foo");
    }

    @Test
    public void prefixPathToRoot() throws Exception {
        this.proxyServer.proxyPrefixPath("/path", "/");
        this.isProxied("/path", "/");
        this.isProxied("/path/", "/");
        this.isNotProxied("");
        this.isNotProxied("/");
        this.isNotProxied("/foo");
    }

    @Test
    public void prefixPathSlashToRoot() throws Exception {
        this.proxyServer.proxyPrefixPath("/path/", "/");
        this.isProxied("/path", "/");
        this.isProxied("/path/", "/");
        this.isNotProxied("");
        this.isNotProxied("/");
        this.isNotProxied("/foo");
    }

    @Test
    public void exactRootToRoot() throws Exception {
        this.proxyServer.proxyExactPath("/", "/");
        this.isProxied("", "/");
        this.isProxied("/", "/");
        this.isNotProxied("/foo");
    }

    @Test
    public void exactRootToPath() throws Exception {
        this.proxyServer.proxyExactPath("/", "/path");
        this.isProxied("", "/path");
        this.isProxied("/", "/path");
        this.isNotProxied("/foo");
    }

    @Test
    public void exactRootToPathSlash() throws Exception {
        this.proxyServer.proxyExactPath("/", "/path/");
        this.isProxied("", "/path/");
        this.isProxied("/", "/path/");
        this.isNotProxied("/foo");
    }

    @Test
    public void exactPathToRoot() throws Exception {
        this.proxyServer.proxyExactPath("/path", "/");
        this.isProxied("/path", "/");
        this.isProxied("/path/", "/");
        this.isNotProxied("");
        this.isNotProxied("/");
        this.isNotProxied("/foo");
        this.isNotProxied("/path/foo");
    }

    @Test
    public void exactPathSlashToRoot() throws Exception {
        this.proxyServer.proxyExactPath("/path/", "/");
        this.isProxied("/path", "/");
        this.isProxied("/path/", "/");
        this.isNotProxied("");
        this.isNotProxied("/");
        this.isNotProxied("/foo");
        this.isNotProxied("/path/foo");
    }

    @Test
    public void exactPathToPath() throws Exception {
        this.proxyServer.proxyExactPath("/path", "/path");
        this.isProxied("/path", "/path");
        this.isProxied("/path/", "/path");
        this.isNotProxied("");
        this.isNotProxied("/");
        this.isNotProxied("/foo");
        this.isNotProxied("/path/foo");
    }

    @Test
    public void exactPathToPathSlash() throws Exception {
        this.proxyServer.proxyExactPath("/path", "/path/");
        this.isProxied("/path", "/path/");
        this.isProxied("/path/", "/path/");
        this.isNotProxied("");
        this.isNotProxied("/");
        this.isNotProxied("/foo");
        this.isNotProxied("/path/foo");
    }

    private void isProxied(String requestPath, String expectedTargetPath) throws IOException {
        Assert.assertEquals((long)200L, (long)this.httpGet(requestPath));
        Assert.assertEquals((Object)expectedTargetPath, (Object)this.targetServer.gotRequest(true));
    }

    private void isNotProxied(String requestPath) throws IOException {
        Assert.assertEquals((long)404L, (long)this.httpGet(requestPath));
        Assert.assertNull((Object)this.targetServer.gotRequest(false));
    }

    private int httpGet(String path) throws IOException {
        TestHttpClient http = new TestHttpClient();
        HttpResponse response = http.execute((HttpUriRequest)new HttpGet(this.proxyServer.uri + path));
        return response.getStatusLine().getStatusCode();
    }

    private static class FreePort {
        private FreePort() {
        }

        static int find() {
            int port = 0;
            while (port == 0) {
                ServerSocket socket = null;
                try {
                    socket = new ServerSocket(0);
                    port = socket.getLocalPort();
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed finding free port", e);
                }
                finally {
                    try {
                        if (socket == null) continue;
                        socket.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return port;
        }
    }

    private static class TargetServer {
        private final int port = FreePort.find();
        private final Undertow server;
        final String uri = "http://localhost:" + this.port;
        private final LinkedBlockingQueue<String> gotRequestQueue = new LinkedBlockingQueue();

        TargetServer() {
            this.server = Undertow.builder().addHttpListener(this.port, "0.0.0.0").setHandler(new HttpHandler(){

                public void handleRequest(HttpServerExchange exchange) throws Exception {
                    TargetServer.this.gotRequestQueue.add(URI.create(exchange.getRequestURL()).getPath());
                }
            }).build();
            this.server.start();
        }

        void stop() {
            this.server.stop();
        }

        String gotRequest(boolean wait) {
            String url = null;
            try {
                url = this.gotRequestQueue.poll(wait ? 10000L : 10L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            return url;
        }
    }

    private static class ProxyServer {
        private final int port = FreePort.find();
        private final Undertow server;
        private final PathHandler pathHandler = Handlers.path();
        final String uri = "http://localhost:" + this.port;
        private final String targetUri;

        ProxyServer(String targetUri) {
            this.targetUri = targetUri;
            this.server = Undertow.builder().addHttpListener(this.port, "0.0.0.0").setHandler((HttpHandler)this.pathHandler).build();
            this.server.start();
        }

        void proxyPrefixPath(String proxyPath, String targetPath) {
            this.pathHandler.addPrefixPath(proxyPath, this.proxyHandler(targetPath));
        }

        void proxyExactPath(String proxyPath, String targetPath) {
            this.pathHandler.addExactPath(proxyPath, this.proxyHandler(targetPath));
        }

        void stop() {
            this.server.stop();
        }

        private HttpHandler proxyHandler(String targetPath) {
            return ProxyHandler.builder().setProxyClient((ProxyClient)new SimpleProxyClientProvider(URI.create(this.targetUri + targetPath))).build();
        }
    }
}

