/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.core.protocol;

import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.undertow.server.HttpHandler;
import io.undertow.testutils.DefaultServer;
import io.undertow.util.NetworkUtils;
import io.undertow.websockets.WebSocketConnectionCallback;
import io.undertow.websockets.WebSocketProtocolHandshakeHandler;
import io.undertow.websockets.core.AbstractReceiveListener;
import io.undertow.websockets.core.BufferedBinaryMessage;
import io.undertow.websockets.core.WebSocketCallback;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSockets;
import io.undertow.websockets.core.protocol.AbstractWebSocketServerTest;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import io.undertow.websockets.utils.FrameChecker;
import io.undertow.websockets.utils.WebSocketTestClient;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Test;
import org.xnio.ChannelListener;
import org.xnio.FutureResult;
import org.xnio.Pooled;

public class WebSocket07ServerTest
extends AbstractWebSocketServerTest {
    @Override
    protected WebSocketVersion getVersion() {
        return WebSocketVersion.V07;
    }

    @Test
    public void testPing() throws Exception {
        final AtomicBoolean connected = new AtomicBoolean(false);
        DefaultServer.setRootHandler((HttpHandler)new WebSocketProtocolHandshakeHandler(new WebSocketConnectionCallback(){

            public void onConnect(WebSocketHttpExchange exchange, WebSocketChannel channel) {
                connected.set(true);
                channel.getReceiveSetter().set((ChannelListener)new AbstractReceiveListener(){

                    protected void onFullPingMessage(WebSocketChannel channel, BufferedBinaryMessage message) throws IOException {
                        final Pooled data = message.getData();
                        WebSockets.sendPong((ByteBuffer[])((ByteBuffer[])data.getResource()), (WebSocketChannel)channel, (WebSocketCallback)new WebSocketCallback<Void>(){

                            public void complete(WebSocketChannel channel, Void context) {
                                data.close();
                            }

                            public void onError(WebSocketChannel channel, Void context, Throwable throwable) {
                                data.close();
                            }
                        });
                    }
                });
                channel.resumeReceives();
            }
        }));
        FutureResult latch = new FutureResult();
        byte[] payload = "payload".getBytes();
        WebSocketTestClient client = new WebSocketTestClient(this.getVersion(), new URI("ws://" + NetworkUtils.formatPossibleIpv6Address((String)DefaultServer.getHostAddress("default")) + ':' + DefaultServer.getHostPort("default") + '/'));
        client.connect();
        client.send((WebSocketFrame)new PingWebSocketFrame(Unpooled.wrappedBuffer((byte[])payload)), new FrameChecker(PongWebSocketFrame.class, payload, latch));
        latch.getIoFuture().get();
        client.destroy();
    }
}

