/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.proxy;

import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientExchange;
import io.undertow.client.ClientRequest;
import io.undertow.client.UndertowClient;
import io.undertow.connector.ByteBufferPool;
import io.undertow.protocols.ssl.UndertowXnioSsl;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.proxy.AbstractLoadBalancingProxyTestCase;
import io.undertow.server.handlers.proxy.LoadBalancingProxyClient;
import io.undertow.server.handlers.proxy.ProxyClient;
import io.undertow.server.handlers.proxy.ProxyHandler;
import io.undertow.server.protocol.http2.Http2ServerConnection;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import io.undertow.util.Protocols;
import io.undertow.util.StringReadChannelListener;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayDeque;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.xnio.FutureResult;
import org.xnio.IoFuture;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.ssl.XnioSsl;

@RunWith(value=DefaultServer.class)
public class LoadBalancingProxyHTTP2TestCase
extends AbstractLoadBalancingProxyTestCase {
    @BeforeClass
    public static void setup() throws URISyntaxException {
        int port = DefaultServer.getHostPort("default");
        final HttpHandler handler1 = LoadBalancingProxyHTTP2TestCase.getRootHandler("s1", "server1");
        server1 = Undertow.builder().addHttpsListener(port + 1, DefaultServer.getHostAddress("default"), DefaultServer.getServerSslContext()).setServerOption(UndertowOptions.ENABLE_HTTP2, (Object)true).setServerOption(UndertowOptions.NO_REQUEST_TIMEOUT, (Object)1000).setSocketOption(Options.REUSE_ADDRESSES, (Object)true).setHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                if (!(exchange.getConnection() instanceof Http2ServerConnection)) {
                    throw new RuntimeException("Not HTTP2");
                }
                exchange.getResponseHeaders().add(new HttpString("X-Custom-Header"), "foo");
                handler1.handleRequest(exchange);
            }
        }).build();
        final HttpHandler handler2 = LoadBalancingProxyHTTP2TestCase.getRootHandler("s2", "server2");
        server2 = Undertow.builder().addHttpsListener(port + 2, DefaultServer.getHostAddress("default"), DefaultServer.getServerSslContext()).setServerOption(UndertowOptions.ENABLE_HTTP2, (Object)true).setSocketOption(Options.REUSE_ADDRESSES, (Object)true).setServerOption(UndertowOptions.NO_REQUEST_TIMEOUT, (Object)1000).setHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                if (!(exchange.getConnection() instanceof Http2ServerConnection)) {
                    throw new RuntimeException("Not HTTP2");
                }
                exchange.getResponseHeaders().add(new HttpString("X-Custom-Header"), "foo");
                handler2.handleRequest(exchange);
            }
        }).build();
        server1.start();
        server2.start();
        UndertowXnioSsl ssl = new UndertowXnioSsl(DefaultServer.getWorker().getXnio(), OptionMap.EMPTY, (ByteBufferPool)DefaultServer.SSL_BUFFER_POOL, DefaultServer.createClientSslContext());
        DefaultServer.setRootHandler((HttpHandler)ProxyHandler.builder().setProxyClient((ProxyClient)new LoadBalancingProxyClient().setConnectionsPerThread(4).addHost(new URI("https", null, DefaultServer.getHostAddress("default"), port + 1, null, null, null), "s1", (XnioSsl)ssl, OptionMap.create((Option)UndertowOptions.ENABLE_HTTP2, (Object)true)).addHost(new URI("https", null, DefaultServer.getHostAddress("default"), port + 2, null, null, null), "s2", (XnioSsl)ssl, OptionMap.create((Option)UndertowOptions.ENABLE_HTTP2, (Object)true))).setMaxRequestTime(10000).setMaxConnectionRetries(2).build());
    }

    @Before
    public void requireAlpn() {
        DefaultServer.assumeAlpnEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHeadersAreLowercase() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/name");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse(result);
            Header header = result.getFirstHeader("x-custom-header");
            Assert.assertEquals((Object)"x-custom-header", (Object)header.getName());
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHttp2ClientMultipleStreamsThreadSafety() throws IOException, URISyntaxException, ExecutionException, InterruptedException, TimeoutException {
        UndertowXnioSsl ssl = new UndertowXnioSsl(DefaultServer.getWorker().getXnio(), OptionMap.EMPTY, (ByteBufferPool)DefaultServer.SSL_BUFFER_POOL, DefaultServer.createClientSslContext());
        UndertowClient client = UndertowClient.getInstance();
        final ClientConnection connection = (ClientConnection)client.connect(new URI("https", null, DefaultServer.getHostAddress(), DefaultServer.getHostPort() + 1, "/", null, null), DefaultServer.getWorker(), (XnioSsl)ssl, DefaultServer.getBufferPool(), OptionMap.create((Option)UndertowOptions.ENABLE_HTTP2, (Object)true)).get();
        ExecutorService service = Executors.newFixedThreadPool(10);
        try {
            ArrayDeque<FutureResult> futures = new ArrayDeque<FutureResult>();
            for (int i = 0; i < 100; ++i) {
                final FutureResult future = new FutureResult();
                futures.add(future);
                service.submit(new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        ClientRequest cr = new ClientRequest().setMethod(Methods.GET).setPath("/path").setProtocol(Protocols.HTTP_1_1);
                        connection.sendRequest(cr, (ClientCallback)new ClientCallback<ClientExchange>(){

                            public void completed(ClientExchange result) {
                                result.setResponseListener((ClientCallback)new ClientCallback<ClientExchange>(){

                                    public void completed(ClientExchange result) {
                                        new StringReadChannelListener(DefaultServer.getBufferPool()){

                                            protected void stringDone(String string) {
                                                future.setResult((Object)string);
                                            }

                                            protected void error(IOException e) {
                                                future.setException(e);
                                            }
                                        }.setup(result.getResponseChannel());
                                    }

                                    public void failed(IOException e) {
                                        future.setException(e);
                                    }
                                });
                            }

                            public void failed(IOException e) {
                                future.setException(e);
                            }
                        });
                        return null;
                    }
                });
            }
            while (!futures.isEmpty()) {
                FutureResult future = (FutureResult)futures.poll();
                Assert.assertNotEquals((Object)IoFuture.Status.WAITING, (Object)future.getIoFuture().awaitInterruptibly(10L, TimeUnit.SECONDS));
                Assert.assertEquals((Object)"/path", (Object)future.getIoFuture().get());
            }
        }
        finally {
            service.shutdownNow();
        }
    }
}

