/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.extensions;

import io.undertow.connector.ByteBufferPool;
import io.undertow.server.DefaultByteBufferPool;
import io.undertow.server.HttpHandler;
import io.undertow.server.protocol.http.HttpOpenListener;
import io.undertow.util.Transfer;
import io.undertow.websockets.WebSocketConnectionCallback;
import io.undertow.websockets.WebSocketProtocolHandshakeHandler;
import io.undertow.websockets.core.StreamSinkFrameChannel;
import io.undertow.websockets.core.StreamSourceFrameChannel;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSocketFrameType;
import io.undertow.websockets.extensions.ExtensionHandshake;
import io.undertow.websockets.extensions.PerMessageDeflateHandshake;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.log4j.BasicConfigurator;
import org.xnio.ChannelExceptionHandler;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.StreamConnection;
import org.xnio.Xnio;
import org.xnio.XnioWorker;
import org.xnio.channels.AcceptingChannel;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;

public class AutobahnExtensionCustomReceiverServer {
    private HttpOpenListener openListener;
    private XnioWorker worker;
    private AcceptingChannel<StreamConnection> server;
    private Xnio xnio;
    private final int port;
    public static WebSocketChannel current;
    private static final ChannelExceptionHandler<StreamSinkFrameChannel> W_H;
    private static final ChannelExceptionHandler<StreamSourceFrameChannel> R_H;

    public AutobahnExtensionCustomReceiverServer(int port) {
        this.port = port;
    }

    public void run() {
        this.xnio = Xnio.getInstance();
        try {
            this.worker = this.xnio.createWorker(OptionMap.builder().set(Options.WORKER_WRITE_THREADS, 4).set(Options.WORKER_READ_THREADS, 4).set(Options.CONNECTION_HIGH_WATER, 1000000).set(Options.CONNECTION_LOW_WATER, 1000000).set(Options.WORKER_TASK_CORE_THREADS, 10).set(Options.WORKER_TASK_MAX_THREADS, 12).set(Options.TCP_NODELAY, true).set(Options.CORK, true).getMap());
            OptionMap serverOptions = OptionMap.builder().set(Options.WORKER_ACCEPT_THREADS, 4).set(Options.TCP_NODELAY, true).set(Options.REUSE_ADDRESSES, true).getMap();
            this.openListener = new HttpOpenListener((ByteBufferPool)new DefaultByteBufferPool(false, 8192));
            ChannelListener acceptListener = ChannelListeners.openListenerAdapter((ChannelListener)this.openListener);
            this.server = this.worker.createStreamConnectionServer((SocketAddress)new InetSocketAddress(this.port), acceptListener, serverOptions);
            this.setRootHandler((HttpHandler)AutobahnExtensionCustomReceiverServer.getRootHandler().addExtension((ExtensionHandshake)new PerMessageDeflateHandshake()));
            this.server.resumeAccepts();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static WebSocketProtocolHandshakeHandler getRootHandler() {
        return new WebSocketProtocolHandshakeHandler(new WebSocketConnectionCallback(){

            public void onConnect(WebSocketHttpExchange exchange, WebSocketChannel channel) {
                current = channel;
                channel.getReceiveSetter().set((ChannelListener)new Receiver());
                channel.resumeReceives();
            }
        });
    }

    private void setRootHandler(HttpHandler rootHandler) {
        this.openListener.setRootHandler(rootHandler);
    }

    public static void main(String[] args) {
        if (args.length == 1 && args[0].equals("--debug")) {
            BasicConfigurator.configure();
        }
        new AutobahnExtensionCustomReceiverServer(7777).run();
    }

    static {
        W_H = new ChannelExceptionHandler<StreamSinkFrameChannel>(){

            public void handleException(StreamSinkFrameChannel channel, IOException exception) {
                exception.printStackTrace();
            }
        };
        R_H = new ChannelExceptionHandler<StreamSourceFrameChannel>(){

            public void handleException(StreamSourceFrameChannel channel, IOException exception) {
                exception.printStackTrace();
            }
        };
    }

    private static final class Receiver
    implements ChannelListener<WebSocketChannel> {
        private Receiver() {
        }

        public void handleEvent(final WebSocketChannel channel) {
            try {
                StreamSourceFrameChannel ws = (StreamSourceFrameChannel)channel.receive();
                if (ws != null) {
                    StreamSinkFrameChannel target;
                    if (ws.getType() == WebSocketFrameType.PING || ws.getType() == WebSocketFrameType.CLOSE) {
                        target = channel.send(ws.getType() == WebSocketFrameType.PING ? WebSocketFrameType.PONG : WebSocketFrameType.CLOSE);
                    } else {
                        if (ws.getType() == WebSocketFrameType.PONG) {
                            ws.getReadSetter().set(ChannelListeners.drainListener((long)Long.MAX_VALUE, null, null));
                            ws.wakeupReads();
                            return;
                        }
                        target = channel.send(ws.getType());
                    }
                    Transfer.initiateTransfer((StreamSourceChannel)ws, (StreamSinkChannel)target, null, (ChannelListener)ChannelListeners.writeShutdownChannelListener((ChannelListener)new ChannelListener<StreamSinkFrameChannel>(){

                        public void handleEvent(StreamSinkFrameChannel c) {
                            channel.resumeReceives();
                        }
                    }, (ChannelExceptionHandler)W_H), (ChannelExceptionHandler)R_H, (ChannelExceptionHandler)W_H, (ByteBufferPool)channel.getBufferPool());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

