/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.NameVirtualHostHandler;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.SetHeaderHandler;
import io.undertow.server.handlers.builder.PredicatedHandlersParser;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import io.undertow.util.NetworkUtils;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class PredicatedHandlersProxyTestCase {
    private static Undertow server1;
    private static Undertow server2;

    @BeforeClass
    public static void setup() throws URISyntaxException {
        int port = DefaultServer.getHostPort("default") + 1;
        NameVirtualHostHandler handler = new NameVirtualHostHandler().addHost("original-host", (HttpHandler)new SetHeaderHandler((HttpHandler)ResponseCodeHandler.HANDLE_200, "myHost", "original-host")).setDefaultHandler((HttpHandler)new SetHeaderHandler((HttpHandler)ResponseCodeHandler.HANDLE_200, "myHost", "upstream-host"));
        server1 = Undertow.builder().addHttpListener(port, DefaultServer.getHostAddress("default")).setHandler((HttpHandler)handler).build();
        server1.start();
    }

    @Test
    public void testProxy() throws Exception {
        TestHttpClient client = new TestHttpClient();
        int port = DefaultServer.getHostPort("default");
        String upstreamUrl = "http://" + NetworkUtils.formatPossibleIpv6Address((String)DefaultServer.getHostAddress("default")) + ":" + (port + 1);
        DefaultServer.setRootHandler((HttpHandler)Handlers.predicates((List)PredicatedHandlersParser.parse((String)String.format("path-suffix['.html'] -> reverse-proxy[hosts={'%1$s'}, rewrite-host-header=true]\npath-suffix['.jsp'] -> reverse-proxy[hosts={'%1$s'}]", upstreamUrl), (ClassLoader)this.getClass().getClassLoader()), (HttpHandler)ResponseCodeHandler.HANDLE_404));
        HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/foo.html");
        get.addHeader("Host", "original-host");
        CloseableHttpResponse result = client.execute((HttpUriRequest)get);
        Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
        Header[] header = result.getHeaders("myHost");
        Assert.assertEquals((Object)"upstream-host", (Object)header[0].getValue());
        HttpClientUtils.readResponse((HttpResponse)result);
        get = new HttpGet(DefaultServer.getDefaultServerURL() + "/foo.jsp");
        get.addHeader("Host", "original-host");
        result = client.execute((HttpUriRequest)get);
        Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
        header = result.getHeaders("myHost");
        Assert.assertEquals((Object)"original-host", (Object)header[0].getValue());
        HttpClientUtils.readResponse((HttpResponse)result);
    }

    @AfterClass
    public static void teardown() {
        server1.stop();
    }
}

