/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.testutils.category.UnitTest;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={UnitTest.class})
public class HeaderOrderTestCase {
    @Test
    public void testHeadersOrder() throws Exception {
        Field orderIntField = HttpString.class.getDeclaredField("orderInt");
        orderIntField.setAccessible(true);
        Field[] fields = Headers.class.getDeclaredFields();
        ArrayList<HttpString> headers = new ArrayList<HttpString>();
        for (Field field : fields) {
            HttpString header;
            Object value;
            if (Modifier.isTransient(field.getModifiers()) || !Modifier.isPublic(field.getModifiers()) || !((value = field.get(null)) instanceof HttpString) || (Integer)orderIntField.get(header = (HttpString)value) == 0) continue;
            headers.add(header);
        }
        Collections.sort(headers, new Comparator<HttpString>(){

            @Override
            public int compare(HttpString o1, HttpString o2) {
                return o1.toString().compareToIgnoreCase(o2.toString());
            }
        });
        int val = 1;
        for (HttpString header : headers) {
            Assert.assertEquals((Object)val++, (Object)orderIntField.get(header));
        }
    }
}

