/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.client.http;

import io.undertow.Undertow;
import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientExchange;
import io.undertow.client.ClientRequest;
import io.undertow.client.ClientResponse;
import io.undertow.client.UndertowClient;
import io.undertow.io.Receiver;
import io.undertow.io.Sender;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.PathHandler;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpOneOnly;
import io.undertow.util.AttachmentKey;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import io.undertow.util.StringReadChannelListener;
import io.undertow.util.StringWriteChannelListener;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.xnio.ChannelListeners;
import org.xnio.FutureResult;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Xnio;
import org.xnio.XnioWorker;

@RunWith(value=DefaultServer.class)
@HttpOneOnly
public class AjpClientTestCase {
    private static final String message = "Hello World!";
    public static final String MESSAGE = "/message";
    public static final String POST = "/post";
    private static final int AJP_PORT = DefaultServer.getHostPort() + 10;
    private static XnioWorker worker;
    private static Undertow undertow;
    private static final OptionMap DEFAULT_OPTIONS;
    private static final URI ADDRESS;
    private static final AttachmentKey<String> RESPONSE_BODY;

    static void sendMessage(HttpServerExchange exchange) {
        exchange.setStatusCode(200);
        exchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, message.length() + "");
        Sender sender = exchange.getResponseSender();
        sender.send(message);
    }

    @BeforeClass
    public static void beforeClass() throws IOException {
        XnioWorker xnioWorker;
        Xnio xnio = Xnio.getInstance();
        worker = xnioWorker = xnio.createWorker(null, DEFAULT_OPTIONS);
        undertow = Undertow.builder().addListener(new Undertow.ListenerBuilder().setType(Undertow.ListenerType.AJP).setPort(AJP_PORT)).setHandler((HttpHandler)new PathHandler().addExactPath(MESSAGE, new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                AjpClientTestCase.sendMessage(exchange);
            }
        }).addExactPath(POST, new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                exchange.getRequestReceiver().receiveFullString(new Receiver.FullStringCallback(){

                    public void handle(HttpServerExchange exchange, String message) {
                        exchange.getResponseSender().send(message);
                    }
                });
            }
        })).build();
        undertow.start();
    }

    @AfterClass
    public static void afterClass() {
        worker.shutdown();
        undertow.stop();
    }

    static UndertowClient createClient() {
        return AjpClientTestCase.createClient(OptionMap.EMPTY);
    }

    static UndertowClient createClient(OptionMap options) {
        return UndertowClient.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleBasic() throws Exception {
        UndertowClient client = AjpClientTestCase.createClient();
        final CopyOnWriteArrayList responses = new CopyOnWriteArrayList();
        final CountDownLatch latch = new CountDownLatch(10);
        final ClientConnection connection = (ClientConnection)client.connect(ADDRESS, worker, DefaultServer.getBufferPool(), OptionMap.EMPTY).get();
        try {
            connection.getIoThread().execute(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < 10; ++i) {
                        ClientRequest request = new ClientRequest().setMethod(Methods.GET).setPath(AjpClientTestCase.MESSAGE);
                        request.getRequestHeaders().put(Headers.HOST, DefaultServer.getHostAddress());
                        connection.sendRequest(request, AjpClientTestCase.this.createClientCallback(responses, latch));
                    }
                }
            });
            latch.await(10L, TimeUnit.SECONDS);
            Assert.assertEquals((long)10L, (long)responses.size());
            for (ClientResponse response : responses) {
                Assert.assertEquals((Object)message, (Object)response.getAttachment(RESPONSE_BODY));
            }
        }
        finally {
            IoUtils.safeClose((Closeable)connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSendPing() throws Exception {
        UndertowClient client = AjpClientTestCase.createClient();
        final CopyOnWriteArrayList responses = new CopyOnWriteArrayList();
        final FutureResult result = new FutureResult();
        final CountDownLatch latch = new CountDownLatch(3);
        final ClientConnection connection = (ClientConnection)client.connect(ADDRESS, worker, DefaultServer.getBufferPool(), OptionMap.EMPTY).get();
        Assert.assertTrue((boolean)connection.isPingSupported());
        try {
            connection.getIoThread().execute(new Runnable(){

                @Override
                public void run() {
                    ClientRequest request = new ClientRequest().setMethod(Methods.GET).setPath(AjpClientTestCase.MESSAGE);
                    request.getRequestHeaders().put(Headers.HOST, DefaultServer.getHostAddress());
                    connection.sendRequest(request, AjpClientTestCase.this.createClientCallback(responses, latch));
                    connection.sendPing(new ClientConnection.PingListener(){

                        public void acknowledged() {
                            result.setResult((Object)true);
                            latch.countDown();
                        }

                        public void failed(IOException e) {
                            result.setException(e);
                            latch.countDown();
                        }
                    }, 5L, TimeUnit.SECONDS);
                    connection.sendRequest(request, AjpClientTestCase.this.createClientCallback(responses, latch));
                }
            });
            latch.await(10L, TimeUnit.SECONDS);
            Assert.assertEquals((long)2L, (long)responses.size());
            Assert.assertTrue((boolean)((Boolean)result.getIoFuture().get()));
            for (ClientResponse response : responses) {
                Assert.assertEquals((Object)message, (Object)response.getAttachment(RESPONSE_BODY));
            }
            try {
                undertow.stop();
                final FutureResult failResult = new FutureResult();
                connection.getIoThread().execute(new Runnable(){

                    @Override
                    public void run() {
                        connection.sendPing(new ClientConnection.PingListener(){

                            public void acknowledged() {
                                failResult.setResult((Object)true);
                            }

                            public void failed(IOException e) {
                                failResult.setException(e);
                            }
                        }, 4L, TimeUnit.SECONDS);
                    }
                });
                try {
                    failResult.getIoFuture().get();
                    Assert.fail((String)"ping should have failed");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            finally {
                undertow.start();
            }
        }
        finally {
            IoUtils.safeClose((Closeable)connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPostRequest() throws Exception {
        UndertowClient client = AjpClientTestCase.createClient();
        String postMessage = "This is a post request";
        final CopyOnWriteArrayList responses = new CopyOnWriteArrayList();
        final CountDownLatch latch = new CountDownLatch(10);
        final ClientConnection connection = (ClientConnection)client.connect(ADDRESS, worker, DefaultServer.getBufferPool(), OptionMap.EMPTY).get();
        try {
            connection.getIoThread().execute(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < 10; ++i) {
                        ClientRequest request = new ClientRequest().setMethod(Methods.POST).setPath(AjpClientTestCase.POST);
                        request.getRequestHeaders().put(Headers.HOST, DefaultServer.getHostAddress());
                        request.getRequestHeaders().put(Headers.TRANSFER_ENCODING, "chunked");
                        connection.sendRequest(request, (ClientCallback)new ClientCallback<ClientExchange>(){

                            public void completed(ClientExchange result) {
                                new StringWriteChannelListener("This is a post request").setup(result.getRequestChannel());
                                result.setResponseListener((ClientCallback)new ClientCallback<ClientExchange>(){

                                    public void completed(ClientExchange result) {
                                        new StringReadChannelListener(DefaultServer.getBufferPool()){

                                            protected void stringDone(String string) {
                                                responses.add(string);
                                                latch.countDown();
                                            }

                                            protected void error(IOException e) {
                                                e.printStackTrace();
                                                latch.countDown();
                                            }
                                        }.setup(result.getResponseChannel());
                                    }

                                    public void failed(IOException e) {
                                        e.printStackTrace();
                                        latch.countDown();
                                    }
                                });
                            }

                            public void failed(IOException e) {
                                e.printStackTrace();
                                latch.countDown();
                            }
                        });
                    }
                }
            });
            latch.await(10L, TimeUnit.SECONDS);
            Assert.assertEquals((long)10L, (long)responses.size());
            for (String response : responses) {
                Assert.assertEquals((Object)"This is a post request", (Object)response);
            }
        }
        finally {
            IoUtils.safeClose((Closeable)connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnectionClose() throws Exception {
        UndertowClient client = AjpClientTestCase.createClient();
        CountDownLatch latch = new CountDownLatch(1);
        ClientConnection connection = (ClientConnection)client.connect(ADDRESS, worker, DefaultServer.getBufferPool(), OptionMap.EMPTY).get();
        try {
            ClientRequest request = new ClientRequest().setPath(MESSAGE).setMethod(Methods.GET);
            request.getRequestHeaders().put(Headers.HOST, DefaultServer.getHostAddress());
            CopyOnWriteArrayList<ClientResponse> responses = new CopyOnWriteArrayList<ClientResponse>();
            request.getRequestHeaders().add(Headers.CONNECTION, Headers.CLOSE.toString());
            connection.sendRequest(request, this.createClientCallback(responses, latch));
            latch.await();
            ClientResponse response = (ClientResponse)responses.iterator().next();
            Assert.assertEquals((Object)message, (Object)response.getAttachment(RESPONSE_BODY));
            Assert.assertEquals((Object)false, (Object)connection.isOpen());
        }
        finally {
            IoUtils.safeClose((Closeable)connection);
        }
    }

    private ClientCallback<ClientExchange> createClientCallback(final List<ClientResponse> responses, final CountDownLatch latch) {
        return new ClientCallback<ClientExchange>(){

            public void completed(ClientExchange result) {
                result.setResponseListener((ClientCallback)new ClientCallback<ClientExchange>(){

                    public void completed(final ClientExchange result) {
                        responses.add(result.getResponse());
                        new StringReadChannelListener(result.getConnection().getBufferPool()){

                            protected void stringDone(String string) {
                                result.getResponse().putAttachment(RESPONSE_BODY, (Object)string);
                                latch.countDown();
                            }

                            protected void error(IOException e) {
                                e.printStackTrace();
                                latch.countDown();
                            }
                        }.setup(result.getResponseChannel());
                    }

                    public void failed(IOException e) {
                        e.printStackTrace();
                        latch.countDown();
                    }
                });
                try {
                    result.getRequestChannel().shutdownWrites();
                    if (!result.getRequestChannel().flush()) {
                        result.getRequestChannel().getWriteSetter().set(ChannelListeners.flushingChannelListener(null, null));
                        result.getRequestChannel().resumeWrites();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    latch.countDown();
                }
            }

            public void failed(IOException e) {
                e.printStackTrace();
                latch.countDown();
            }
        };
    }

    static {
        RESPONSE_BODY = AttachmentKey.create(String.class);
        OptionMap.Builder builder = OptionMap.builder().set(Options.WORKER_IO_THREADS, 8).set(Options.TCP_NODELAY, true).set(Options.KEEP_ALIVE, true).set(Options.WORKER_NAME, (Object)"Client");
        DEFAULT_OPTIONS = builder.getMap();
        try {
            ADDRESS = new URI("ajp://" + DefaultServer.getHostAddress() + ":" + AJP_PORT);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

