/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.security;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.NonceManager;
import io.undertow.security.api.SecurityNotification;
import io.undertow.security.idm.DigestAlgorithm;
import io.undertow.security.impl.AuthenticationInfoToken;
import io.undertow.security.impl.DigestAuthenticationMechanism;
import io.undertow.security.impl.DigestAuthorizationToken;
import io.undertow.security.impl.DigestWWWAuthenticateToken;
import io.undertow.security.impl.SimpleNonceManager;
import io.undertow.server.security.AuthenticationTestBase;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.TestHttpClient;
import io.undertow.util.Headers;
import io.undertow.util.HexConverter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class DigestAuthentication2069TestCase
extends AuthenticationTestBase {
    private static final Charset UTF_8 = StandardCharsets.UTF_8;
    private static final String REALM_NAME = "Digest_Realm";

    @Override
    protected List<AuthenticationMechanism> getTestMechanisms() {
        List qopList = Collections.emptyList();
        DigestAuthenticationMechanism mechanism = new DigestAuthenticationMechanism(Collections.singletonList(DigestAlgorithm.MD5), qopList, REALM_NAME, "/", (NonceManager)new SimpleNonceManager());
        return Collections.singletonList(mechanism);
    }

    private String createResponse(String userName, String realm, String password, String method, String uri, String nonce) throws Exception {
        MessageDigest digest = MessageDigest.getInstance("MD5");
        digest.update(userName.getBytes(UTF_8));
        digest.update((byte)58);
        digest.update(realm.getBytes(UTF_8));
        digest.update((byte)58);
        digest.update(password.getBytes(UTF_8));
        byte[] ha1 = HexConverter.convertToHexBytes((byte[])digest.digest());
        digest.update(method.getBytes(UTF_8));
        digest.update((byte)58);
        digest.update(uri.getBytes(UTF_8));
        byte[] ha2 = HexConverter.convertToHexBytes((byte[])digest.digest());
        digest.update(ha1);
        digest.update((byte)58);
        digest.update(nonce.getBytes(UTF_8));
        digest.update((byte)58);
        digest.update(ha2);
        return HexConverter.convertToHexString((byte[])digest.digest());
    }

    @Test
    public void testDigestSuccess() throws Exception {
        TestHttpClient client = new TestHttpClient();
        HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL());
        HttpResponse result = client.execute((HttpUriRequest)get);
        Assert.assertEquals((long)401L, (long)result.getStatusLine().getStatusCode());
        Header[] values = result.getHeaders(Headers.WWW_AUTHENTICATE.toString());
        Assert.assertEquals((long)1L, (long)values.length);
        String value = values[0].getValue();
        Assert.assertTrue((boolean)value.startsWith(Headers.DIGEST.toString()));
        Map parsedHeader = DigestWWWAuthenticateToken.parseHeader((String)value.substring(7));
        Assert.assertEquals((Object)REALM_NAME, parsedHeader.get(DigestWWWAuthenticateToken.REALM));
        Assert.assertEquals((Object)DigestAlgorithm.MD5.getToken(), parsedHeader.get(DigestWWWAuthenticateToken.ALGORITHM));
        Assert.assertFalse((boolean)parsedHeader.containsKey(DigestWWWAuthenticateToken.MESSAGE_QOP));
        String nonce = (String)parsedHeader.get(DigestWWWAuthenticateToken.NONCE);
        String response = this.createResponse("userOne", REALM_NAME, "passwordOne", "GET", "/", nonce);
        client = new TestHttpClient();
        get = new HttpGet(DefaultServer.getDefaultServerURL());
        StringBuilder sb = new StringBuilder(Headers.DIGEST.toString());
        sb.append(" ");
        sb.append(DigestAuthorizationToken.USERNAME.getName()).append("=").append("\"userOne\"").append(",");
        sb.append(DigestAuthorizationToken.REALM.getName()).append("=\"").append(REALM_NAME).append("\",");
        sb.append(DigestAuthorizationToken.NONCE.getName()).append("=\"").append(nonce).append("\",");
        sb.append(DigestAuthorizationToken.DIGEST_URI.getName()).append("=\"/\",");
        sb.append(DigestAuthorizationToken.RESPONSE.getName()).append("=\"").append(response).append("\"");
        get.addHeader(Headers.AUTHORIZATION.toString(), sb.toString());
        result = client.execute((HttpUriRequest)get);
        Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
        values = result.getHeaders("ProcessedBy");
        Assert.assertEquals((long)1L, (long)values.length);
        Assert.assertEquals((Object)"ResponseHandler", (Object)values[0].getValue());
        values = result.getHeaders("Authentication-Info");
        Assert.assertEquals((long)1L, (long)values.length);
        Map parsedAuthInfo = AuthenticationInfoToken.parseHeader((String)values[0].getValue());
        nonce = (String)parsedAuthInfo.get(AuthenticationInfoToken.NEXT_NONCE);
        response = this.createResponse("userOne", REALM_NAME, "passwordOne", "GET", "/", nonce);
        DigestAuthentication2069TestCase.assertSingleNotificationType(SecurityNotification.EventType.AUTHENTICATED);
        client = new TestHttpClient();
        get = new HttpGet(DefaultServer.getDefaultServerURL());
        sb = new StringBuilder(Headers.DIGEST.toString());
        sb.append(" ");
        sb.append(DigestAuthorizationToken.USERNAME.getName()).append("=").append("\"userOne\"").append(",");
        sb.append(DigestAuthorizationToken.REALM.getName()).append("=\"").append(REALM_NAME).append("\",");
        sb.append(DigestAuthorizationToken.NONCE.getName()).append("=\"").append(nonce).append("\",");
        sb.append(DigestAuthorizationToken.DIGEST_URI.getName()).append("=\"/\",");
        sb.append(DigestAuthorizationToken.RESPONSE.getName()).append("=\"").append(response).append("\"");
        get.addHeader(Headers.AUTHORIZATION.toString(), sb.toString());
        result = client.execute((HttpUriRequest)get);
        Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
        values = result.getHeaders("ProcessedBy");
        Assert.assertEquals((long)1L, (long)values.length);
        Assert.assertEquals((Object)"ResponseHandler", (Object)values[0].getValue());
        DigestAuthentication2069TestCase.assertSingleNotificationType(SecurityNotification.EventType.AUTHENTICATED);
    }

    @Test
    public void testBadUserName() throws Exception {
        TestHttpClient client = new TestHttpClient();
        HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL());
        HttpResponse result = client.execute((HttpUriRequest)get);
        Assert.assertEquals((long)401L, (long)result.getStatusLine().getStatusCode());
        Header[] values = result.getHeaders(Headers.WWW_AUTHENTICATE.toString());
        Assert.assertEquals((long)1L, (long)values.length);
        String value = values[0].getValue();
        Assert.assertTrue((boolean)value.startsWith(Headers.DIGEST.toString()));
        Map parsedHeader = DigestWWWAuthenticateToken.parseHeader((String)value.substring(7));
        Assert.assertEquals((Object)REALM_NAME, parsedHeader.get(DigestWWWAuthenticateToken.REALM));
        Assert.assertEquals((Object)DigestAlgorithm.MD5.getToken(), parsedHeader.get(DigestWWWAuthenticateToken.ALGORITHM));
        String nonce = (String)parsedHeader.get(DigestWWWAuthenticateToken.NONCE);
        String response = this.createResponse("badUser", REALM_NAME, "passwordOne", "GET", "/", nonce);
        client = new TestHttpClient();
        get = new HttpGet(DefaultServer.getDefaultServerURL());
        StringBuilder sb = new StringBuilder(Headers.DIGEST.toString());
        sb.append(" ");
        sb.append(DigestAuthorizationToken.USERNAME.getName()).append("=").append("\"badUser\"").append(",");
        sb.append(DigestAuthorizationToken.REALM.getName()).append("=\"").append(REALM_NAME).append("\",");
        sb.append(DigestAuthorizationToken.NONCE.getName()).append("=\"").append(nonce).append("\",");
        sb.append(DigestAuthorizationToken.DIGEST_URI.getName()).append("=\"/\",");
        sb.append(DigestAuthorizationToken.RESPONSE.getName()).append("=\"").append(response).append("\"");
        get.addHeader(Headers.AUTHORIZATION.toString(), sb.toString());
        result = client.execute((HttpUriRequest)get);
        Assert.assertEquals((long)401L, (long)result.getStatusLine().getStatusCode());
        DigestAuthentication2069TestCase.assertSingleNotificationType(SecurityNotification.EventType.FAILED_AUTHENTICATION);
    }

    @Test
    public void testBadPassword() throws Exception {
        TestHttpClient client = new TestHttpClient();
        HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL());
        HttpResponse result = client.execute((HttpUriRequest)get);
        Assert.assertEquals((long)401L, (long)result.getStatusLine().getStatusCode());
        Header[] values = result.getHeaders(Headers.WWW_AUTHENTICATE.toString());
        Assert.assertEquals((long)1L, (long)values.length);
        String value = values[0].getValue();
        Assert.assertTrue((boolean)value.startsWith(Headers.DIGEST.toString()));
        Map parsedHeader = DigestWWWAuthenticateToken.parseHeader((String)value.substring(7));
        Assert.assertEquals((Object)REALM_NAME, parsedHeader.get(DigestWWWAuthenticateToken.REALM));
        Assert.assertEquals((Object)DigestAlgorithm.MD5.getToken(), parsedHeader.get(DigestWWWAuthenticateToken.ALGORITHM));
        String nonce = (String)parsedHeader.get(DigestWWWAuthenticateToken.NONCE);
        String response = this.createResponse("userOne", REALM_NAME, "badPassword", "GET", "/", nonce);
        client = new TestHttpClient();
        get = new HttpGet(DefaultServer.getDefaultServerURL());
        StringBuilder sb = new StringBuilder(Headers.DIGEST.toString());
        sb.append(" ");
        sb.append(DigestAuthorizationToken.USERNAME.getName()).append("=").append("\"userOne\"").append(",");
        sb.append(DigestAuthorizationToken.REALM.getName()).append("=\"").append(REALM_NAME).append("\",");
        sb.append(DigestAuthorizationToken.NONCE.getName()).append("=\"").append(nonce).append("\",");
        sb.append(DigestAuthorizationToken.DIGEST_URI.getName()).append("=\"/\",");
        sb.append(DigestAuthorizationToken.RESPONSE.getName()).append("=\"").append(response).append("\"");
        get.addHeader(Headers.AUTHORIZATION.toString(), sb.toString());
        result = client.execute((HttpUriRequest)get);
        Assert.assertEquals((long)401L, (long)result.getStatusLine().getStatusCode());
        DigestAuthentication2069TestCase.assertSingleNotificationType(SecurityNotification.EventType.FAILED_AUTHENTICATION);
    }

    @Test
    public void testDifferentNonce() throws Exception {
        TestHttpClient client = new TestHttpClient();
        HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL());
        HttpResponse result = client.execute((HttpUriRequest)get);
        Assert.assertEquals((long)401L, (long)result.getStatusLine().getStatusCode());
        Header[] values = result.getHeaders(Headers.WWW_AUTHENTICATE.toString());
        Assert.assertEquals((long)1L, (long)values.length);
        String value = values[0].getValue();
        Assert.assertTrue((boolean)value.startsWith(Headers.DIGEST.toString()));
        Map parsedHeader = DigestWWWAuthenticateToken.parseHeader((String)value.substring(7));
        Assert.assertEquals((Object)REALM_NAME, parsedHeader.get(DigestWWWAuthenticateToken.REALM));
        Assert.assertEquals((Object)DigestAlgorithm.MD5.getToken(), parsedHeader.get(DigestWWWAuthenticateToken.ALGORITHM));
        String nonce = "AU1aCIiy48ENMTM1MTE3OTUxMDU2OLrHnBlV2GBzzguCWOPET+0=";
        String response = this.createResponse("userOne", REALM_NAME, "passwordOne", "GET", "/", nonce);
        client = new TestHttpClient();
        get = new HttpGet(DefaultServer.getDefaultServerURL());
        StringBuilder sb = new StringBuilder(Headers.DIGEST.toString());
        sb.append(" ");
        sb.append(DigestAuthorizationToken.USERNAME.getName()).append("=").append("\"userOne\"").append(",");
        sb.append(DigestAuthorizationToken.REALM.getName()).append("=\"").append(REALM_NAME).append("\",");
        sb.append(DigestAuthorizationToken.NONCE.getName()).append("=\"").append(nonce).append("\",");
        sb.append(DigestAuthorizationToken.DIGEST_URI.getName()).append("=\"/\",");
        sb.append(DigestAuthorizationToken.RESPONSE.getName()).append("=\"").append(response).append("\"");
        get.addHeader(Headers.AUTHORIZATION.toString(), sb.toString());
        result = client.execute((HttpUriRequest)get);
        Assert.assertEquals((long)401L, (long)result.getStatusLine().getStatusCode());
        values = result.getHeaders(Headers.WWW_AUTHENTICATE.toString());
        Assert.assertEquals((long)1L, (long)values.length);
        value = values[0].getValue();
        Assert.assertTrue((boolean)value.startsWith(Headers.DIGEST.toString()));
        parsedHeader = DigestWWWAuthenticateToken.parseHeader((String)value.substring(7));
        Assert.assertEquals((Object)REALM_NAME, parsedHeader.get(DigestWWWAuthenticateToken.REALM));
        Assert.assertEquals((Object)DigestAlgorithm.MD5.getToken(), parsedHeader.get(DigestWWWAuthenticateToken.ALGORITHM));
        Assert.assertEquals((Object)"true", parsedHeader.get(DigestWWWAuthenticateToken.STALE));
        nonce = (String)parsedHeader.get(DigestWWWAuthenticateToken.NONCE);
        response = this.createResponse("userOne", REALM_NAME, "passwordOne", "GET", "/", nonce);
        client = new TestHttpClient();
        get = new HttpGet(DefaultServer.getDefaultServerURL());
        sb = new StringBuilder(Headers.DIGEST.toString());
        sb.append(" ");
        sb.append(DigestAuthorizationToken.USERNAME.getName()).append("=").append("\"userOne\"").append(",");
        sb.append(DigestAuthorizationToken.REALM.getName()).append("=\"").append(REALM_NAME).append("\",");
        sb.append(DigestAuthorizationToken.NONCE.getName()).append("=\"").append(nonce).append("\",");
        sb.append(DigestAuthorizationToken.DIGEST_URI.getName()).append("=\"/\",");
        sb.append(DigestAuthorizationToken.RESPONSE.getName()).append("=\"").append(response).append("\"");
        get.addHeader(Headers.AUTHORIZATION.toString(), sb.toString());
        result = client.execute((HttpUriRequest)get);
        Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
        values = result.getHeaders("ProcessedBy");
        Assert.assertEquals((long)1L, (long)values.length);
        Assert.assertEquals((Object)"ResponseHandler", (Object)values[0].getValue());
        DigestAuthentication2069TestCase.assertSingleNotificationType(SecurityNotification.EventType.AUTHENTICATED);
    }

    @Test
    public void testNonceReUse() throws Exception {
        TestHttpClient client = new TestHttpClient();
        HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL());
        HttpResponse result = client.execute((HttpUriRequest)get);
        Assert.assertEquals((long)401L, (long)result.getStatusLine().getStatusCode());
        Header[] values = result.getHeaders(Headers.WWW_AUTHENTICATE.toString());
        Assert.assertEquals((long)1L, (long)values.length);
        String value = values[0].getValue();
        Assert.assertTrue((boolean)value.startsWith(Headers.DIGEST.toString()));
        Map parsedHeader = DigestWWWAuthenticateToken.parseHeader((String)value.substring(7));
        Assert.assertEquals((Object)REALM_NAME, parsedHeader.get(DigestWWWAuthenticateToken.REALM));
        Assert.assertEquals((Object)DigestAlgorithm.MD5.getToken(), parsedHeader.get(DigestWWWAuthenticateToken.ALGORITHM));
        String nonce = (String)parsedHeader.get(DigestWWWAuthenticateToken.NONCE);
        String response = this.createResponse("userOne", REALM_NAME, "passwordOne", "GET", "/", nonce);
        client = new TestHttpClient();
        get = new HttpGet(DefaultServer.getDefaultServerURL());
        StringBuilder sb = new StringBuilder(Headers.DIGEST.toString());
        sb.append(" ");
        sb.append(DigestAuthorizationToken.USERNAME.getName()).append("=").append("\"userOne\"").append(",");
        sb.append(DigestAuthorizationToken.REALM.getName()).append("=\"").append(REALM_NAME).append("\",");
        sb.append(DigestAuthorizationToken.NONCE.getName()).append("=\"").append(nonce).append("\",");
        sb.append(DigestAuthorizationToken.DIGEST_URI.getName()).append("=\"/\",");
        sb.append(DigestAuthorizationToken.RESPONSE.getName()).append("=\"").append(response).append("\"");
        get.addHeader(Headers.AUTHORIZATION.toString(), sb.toString());
        result = client.execute((HttpUriRequest)get);
        Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
        values = result.getHeaders("ProcessedBy");
        Assert.assertEquals((long)1L, (long)values.length);
        Assert.assertEquals((Object)"ResponseHandler", (Object)values[0].getValue());
        DigestAuthentication2069TestCase.assertSingleNotificationType(SecurityNotification.EventType.AUTHENTICATED);
        client = new TestHttpClient();
        get = new HttpGet(DefaultServer.getDefaultServerURL());
        get.addHeader(Headers.AUTHORIZATION.toString(), sb.toString());
        result = client.execute((HttpUriRequest)get);
        Assert.assertEquals((long)401L, (long)result.getStatusLine().getStatusCode());
        values = result.getHeaders(Headers.WWW_AUTHENTICATE.toString());
        Assert.assertEquals((long)1L, (long)values.length);
        value = values[0].getValue();
        Assert.assertTrue((boolean)value.startsWith(Headers.DIGEST.toString()));
        parsedHeader = DigestWWWAuthenticateToken.parseHeader((String)value.substring(7));
        Assert.assertEquals((Object)REALM_NAME, parsedHeader.get(DigestWWWAuthenticateToken.REALM));
        Assert.assertEquals((Object)DigestAlgorithm.MD5.getToken(), parsedHeader.get(DigestWWWAuthenticateToken.ALGORITHM));
        Assert.assertEquals((Object)"true", parsedHeader.get(DigestWWWAuthenticateToken.STALE));
        nonce = (String)parsedHeader.get(DigestWWWAuthenticateToken.NONCE);
        response = this.createResponse("userOne", REALM_NAME, "passwordOne", "GET", "/", nonce);
        client = new TestHttpClient();
        get = new HttpGet(DefaultServer.getDefaultServerURL());
        sb = new StringBuilder(Headers.DIGEST.toString());
        sb.append(" ");
        sb.append(DigestAuthorizationToken.USERNAME.getName()).append("=").append("\"userOne\"").append(",");
        sb.append(DigestAuthorizationToken.REALM.getName()).append("=\"").append(REALM_NAME).append("\",");
        sb.append(DigestAuthorizationToken.NONCE.getName()).append("=\"").append(nonce).append("\",");
        sb.append(DigestAuthorizationToken.DIGEST_URI.getName()).append("=\"/\",");
        sb.append(DigestAuthorizationToken.RESPONSE.getName()).append("=\"").append(response).append("\"");
        get.addHeader(Headers.AUTHORIZATION.toString(), sb.toString());
        result = client.execute((HttpUriRequest)get);
        Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
        values = result.getHeaders("ProcessedBy");
        Assert.assertEquals((long)1L, (long)values.length);
        Assert.assertEquals((Object)"ResponseHandler", (Object)values[0].getValue());
        DigestAuthentication2069TestCase.assertSingleNotificationType(SecurityNotification.EventType.AUTHENTICATED);
    }
}

