/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.GracefulShutdownHandler;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class GracefulShutdownTestCase {
    static final AtomicReference<CountDownLatch> latch1 = new AtomicReference();
    static final AtomicReference<CountDownLatch> latch2 = new AtomicReference();
    private static GracefulShutdownHandler shutdown;

    @BeforeClass
    public static void setup() {
        shutdown = Handlers.gracefulShutdown((HttpHandler)new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                CountDownLatch countDownLatch = latch2.get();
                CountDownLatch latch = latch1.get();
                if (latch != null) {
                    latch.countDown();
                }
                if (countDownLatch != null) {
                    countDownLatch.await();
                }
            }
        });
        DefaultServer.setRootHandler((HttpHandler)shutdown);
    }

    @After
    public void after() {
        latch1.set(null);
        latch2.set(null);
        shutdown.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void simpleGracefulShutdownTestCase() throws IOException, InterruptedException {
        HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
        TestHttpClient client = new TestHttpClient();
        try {
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse((HttpResponse)result);
            shutdown.shutdown();
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)503L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse((HttpResponse)result);
            shutdown.start();
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse((HttpResponse)result);
            CountDownLatch latch = new CountDownLatch(1);
            latch2.set(latch);
            latch1.set(new CountDownLatch(1));
            Thread t = new Thread(new RequestTask());
            t.start();
            latch1.get().await();
            shutdown.shutdown();
            Assert.assertFalse((boolean)shutdown.awaitShutdown(10L));
            latch.countDown();
            Assert.assertTrue((boolean)shutdown.awaitShutdown(10000L));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void gracefulShutdownListenerTestCase() throws IOException, InterruptedException {
        HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
        TestHttpClient client = new TestHttpClient();
        try {
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse((HttpResponse)result);
            shutdown.shutdown();
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)503L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse((HttpResponse)result);
            shutdown.start();
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse((HttpResponse)result);
            CountDownLatch latch = new CountDownLatch(1);
            latch2.set(latch);
            latch1.set(new CountDownLatch(1));
            Thread t = new Thread(new RequestTask());
            t.start();
            latch1.get().await();
            ShutdownListener listener = new ShutdownListener();
            shutdown.shutdown();
            shutdown.addShutdownListener((GracefulShutdownHandler.ShutdownListener)listener);
            Assert.assertFalse((boolean)listener.invoked);
            latch.countDown();
            long end = System.currentTimeMillis() + 5000L;
            while (!listener.invoked && System.currentTimeMillis() < end) {
                Thread.sleep(10L);
            }
            Assert.assertTrue((boolean)listener.invoked);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    private final class RequestTask
    implements Runnable {
        private RequestTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
            TestHttpClient client = new TestHttpClient();
            try {
                CloseableHttpResponse result = client.execute((HttpUriRequest)get);
                Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
                HttpClientUtils.readResponse((HttpResponse)result);
            }
            catch (ClientProtocolException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                client.getConnectionManager().shutdown();
            }
        }
    }

    private class ShutdownListener
    implements GracefulShutdownHandler.ShutdownListener {
        private volatile boolean invoked = false;

        private ShutdownListener() {
        }

        public synchronized void shutdown(boolean successful) {
            this.invoked = true;
        }
    }
}

