/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.form;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.BlockingHandler;
import io.undertow.server.handlers.form.FormData;
import io.undertow.server.handlers.form.FormDataParser;
import io.undertow.server.handlers.form.FormParserFactory;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import io.undertow.util.HttpString;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import junit.textui.TestRunner;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=DefaultServer.Parameterized.class)
public class FormDataParserTestCase {
    private final HttpHandler rootHandler;

    public FormDataParserTestCase(HttpHandler rootHandler) {
        this.rootHandler = rootHandler;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> handlerChains() {
        ArrayList<Object[]> ret = new ArrayList<Object[]>();
        final FormParserFactory parserFactory = FormParserFactory.builder().build();
        HttpHandler fd = new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                FormDataParser parser = parserFactory.createParser(exchange);
                parser.parse(new HttpHandler(){

                    public void handleRequest(HttpServerExchange exchange) throws Exception {
                        FormData data = (FormData)exchange.getAttachment(FormDataParser.FORM_DATA);
                        for (String fd : data) {
                            for (FormData.FormValue val : data.get(fd)) {
                                exchange.getResponseHeaders().add(new HttpString("res"), fd + ":" + val.getValue());
                            }
                        }
                    }
                });
            }
        };
        ret.add(new Object[]{fd});
        BlockingHandler blocking = new BlockingHandler();
        blocking.setRootHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                FormDataParser parser = parserFactory.createParser(exchange);
                try {
                    FormData data = parser.parseBlocking();
                    for (String fd : data) {
                        for (FormData.FormValue val : data.get(fd)) {
                            exchange.getResponseHeaders().add(new HttpString("res"), fd + ":" + val.getValue());
                        }
                    }
                }
                catch (IOException e) {
                    exchange.setStatusCode(500);
                }
            }
        });
        ret.add(new Object[]{blocking});
        return ret;
    }

    @Test
    public void testFormDataParsing() throws Exception {
        this.runTest(new NameValuePair[]{new BasicNameValuePair("name", "A Value")});
        this.runTest(new NameValuePair[]{new BasicNameValuePair("name", "A Value"), new BasicNameValuePair("Single-value", null)});
        this.runTest(new NameValuePair[]{new BasicNameValuePair("name", "A Value"), new BasicNameValuePair("A/name/with_special*chars", "A $ value&& with=SomeCharacters")});
        this.runTest(new NameValuePair[]{new BasicNameValuePair("name", "A Value"), new BasicNameValuePair("Single-value", null), new BasicNameValuePair("A/name/with_special*chars", "A $ value&& with=SomeCharacters")});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTest(NameValuePair ... pairs) throws Exception {
        DefaultServer.setRootHandler(this.rootHandler);
        TestHttpClient client = new TestHttpClient();
        try {
            ArrayList<NameValuePair> data = new ArrayList<NameValuePair>();
            data.addAll(Arrays.asList(pairs));
            HttpPost post = new HttpPost(DefaultServer.getDefaultServerURL() + "/path");
            post.setHeader("Content-Type", "application/x-www-form-urlencoded");
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(data));
            CloseableHttpResponse result = client.execute((HttpUriRequest)post);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            this.checkResult(data, (HttpResponse)result);
            HttpClientUtils.readResponse((HttpResponse)result);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    private void checkResult(List<NameValuePair> data, HttpResponse result) {
        HashMap<String, String> res = new HashMap<String, String>();
        for (Header d : result.getHeaders("res")) {
            String[] split = d.getValue().split(":");
            res.put(split[0], split.length == 1 ? "" : split[1]);
        }
        for (NameValuePair vp : data) {
            Assert.assertEquals((Object)(vp.getValue() == null ? "" : vp.getValue()), res.get(vp.getName()));
        }
    }

    static class AggregateRunner
    extends TestRunner {
        AggregateRunner() {
        }
    }
}

